/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IcmpTypeCode;
import software.amazon.awssdk.services.ec2.model.PortRange;
import software.amazon.awssdk.services.ec2.model.RuleAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNetworkAclEntryRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateNetworkAclEntryRequest> {
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CidrBlock").getter(CreateNetworkAclEntryRequest.getter(CreateNetworkAclEntryRequest::cidrBlock)).setter(CreateNetworkAclEntryRequest.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").unmarshallLocationName("cidrBlock").build()}).build();
    private static final SdkField<Boolean> EGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Egress").getter(CreateNetworkAclEntryRequest.getter(CreateNetworkAclEntryRequest::egress)).setter(CreateNetworkAclEntryRequest.setter(Builder::egress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Egress").unmarshallLocationName("egress").build()}).build();
    private static final SdkField<IcmpTypeCode> ICMP_TYPE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IcmpTypeCode").getter(CreateNetworkAclEntryRequest.getter(CreateNetworkAclEntryRequest::icmpTypeCode)).setter(CreateNetworkAclEntryRequest.setter(Builder::icmpTypeCode)).constructor(IcmpTypeCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Icmp").unmarshallLocationName("Icmp").build()}).build();
    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6CidrBlock").getter(CreateNetworkAclEntryRequest.getter(CreateNetworkAclEntryRequest::ipv6CidrBlock)).setter(CreateNetworkAclEntryRequest.setter(Builder::ipv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock").unmarshallLocationName("ipv6CidrBlock").build()}).build();
    private static final SdkField<String> NETWORK_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkAclId").getter(CreateNetworkAclEntryRequest.getter(CreateNetworkAclEntryRequest::networkAclId)).setter(CreateNetworkAclEntryRequest.setter(Builder::networkAclId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclId").unmarshallLocationName("networkAclId").build()}).build();
    private static final SdkField<PortRange> PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PortRange").getter(CreateNetworkAclEntryRequest.getter(CreateNetworkAclEntryRequest::portRange)).setter(CreateNetworkAclEntryRequest.setter(Builder::portRange)).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRange").unmarshallLocationName("portRange").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(CreateNetworkAclEntryRequest.getter(CreateNetworkAclEntryRequest::protocol)).setter(CreateNetworkAclEntryRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("protocol").build()}).build();
    private static final SdkField<String> RULE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleAction").getter(CreateNetworkAclEntryRequest.getter(CreateNetworkAclEntryRequest::ruleActionAsString)).setter(CreateNetworkAclEntryRequest.setter(Builder::ruleAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction").unmarshallLocationName("ruleAction").build()}).build();
    private static final SdkField<Integer> RULE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RuleNumber").getter(CreateNetworkAclEntryRequest.getter(CreateNetworkAclEntryRequest::ruleNumber)).setter(CreateNetworkAclEntryRequest.setter(Builder::ruleNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNumber").unmarshallLocationName("ruleNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_BLOCK_FIELD, EGRESS_FIELD, ICMP_TYPE_CODE_FIELD, IPV6_CIDR_BLOCK_FIELD, NETWORK_ACL_ID_FIELD, PORT_RANGE_FIELD, PROTOCOL_FIELD, RULE_ACTION_FIELD, RULE_NUMBER_FIELD));
    private final String cidrBlock;
    private final Boolean egress;
    private final IcmpTypeCode icmpTypeCode;
    private final String ipv6CidrBlock;
    private final String networkAclId;
    private final PortRange portRange;
    private final String protocol;
    private final String ruleAction;
    private final Integer ruleNumber;

    private CreateNetworkAclEntryRequest(BuilderImpl builder) {
        super(builder);
        this.cidrBlock = builder.cidrBlock;
        this.egress = builder.egress;
        this.icmpTypeCode = builder.icmpTypeCode;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.networkAclId = builder.networkAclId;
        this.portRange = builder.portRange;
        this.protocol = builder.protocol;
        this.ruleAction = builder.ruleAction;
        this.ruleNumber = builder.ruleNumber;
    }

    public final String cidrBlock() {
        return this.cidrBlock;
    }

    public final Boolean egress() {
        return this.egress;
    }

    public final IcmpTypeCode icmpTypeCode() {
        return this.icmpTypeCode;
    }

    public final String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public final String networkAclId() {
        return this.networkAclId;
    }

    public final PortRange portRange() {
        return this.portRange;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final RuleAction ruleAction() {
        return RuleAction.fromValue(this.ruleAction);
    }

    public final String ruleActionAsString() {
        return this.ruleAction;
    }

    public final Integer ruleNumber() {
        return this.ruleNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.egress());
        hashCode = 31 * hashCode + Objects.hashCode(this.icmpTypeCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAclId());
        hashCode = 31 * hashCode + Objects.hashCode(this.portRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkAclEntryRequest)) {
            return false;
        }
        CreateNetworkAclEntryRequest other = (CreateNetworkAclEntryRequest)((Object)obj);
        return Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.egress(), other.egress()) && Objects.equals(this.icmpTypeCode(), other.icmpTypeCode()) && Objects.equals(this.ipv6CidrBlock(), other.ipv6CidrBlock()) && Objects.equals(this.networkAclId(), other.networkAclId()) && Objects.equals(this.portRange(), other.portRange()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.ruleActionAsString(), other.ruleActionAsString()) && Objects.equals(this.ruleNumber(), other.ruleNumber());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNetworkAclEntryRequest").add("CidrBlock", (Object)this.cidrBlock()).add("Egress", (Object)this.egress()).add("IcmpTypeCode", (Object)this.icmpTypeCode()).add("Ipv6CidrBlock", (Object)this.ipv6CidrBlock()).add("NetworkAclId", (Object)this.networkAclId()).add("PortRange", (Object)this.portRange()).add("Protocol", (Object)this.protocol()).add("RuleAction", (Object)this.ruleActionAsString()).add("RuleNumber", (Object)this.ruleNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "Egress": {
                return Optional.ofNullable(clazz.cast(this.egress()));
            }
            case "IcmpTypeCode": {
                return Optional.ofNullable(clazz.cast(this.icmpTypeCode()));
            }
            case "Ipv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlock()));
            }
            case "NetworkAclId": {
                return Optional.ofNullable(clazz.cast(this.networkAclId()));
            }
            case "PortRange": {
                return Optional.ofNullable(clazz.cast(this.portRange()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "RuleAction": {
                return Optional.ofNullable(clazz.cast(this.ruleActionAsString()));
            }
            case "RuleNumber": {
                return Optional.ofNullable(clazz.cast(this.ruleNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkAclEntryRequest, T> g) {
        return obj -> g.apply((CreateNetworkAclEntryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String cidrBlock;
        private Boolean egress;
        private IcmpTypeCode icmpTypeCode;
        private String ipv6CidrBlock;
        private String networkAclId;
        private PortRange portRange;
        private String protocol;
        private String ruleAction;
        private Integer ruleNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkAclEntryRequest model) {
            super(model);
            this.cidrBlock(model.cidrBlock);
            this.egress(model.egress);
            this.icmpTypeCode(model.icmpTypeCode);
            this.ipv6CidrBlock(model.ipv6CidrBlock);
            this.networkAclId(model.networkAclId);
            this.portRange(model.portRange);
            this.protocol(model.protocol);
            this.ruleAction(model.ruleAction);
            this.ruleNumber(model.ruleNumber);
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getEgress() {
            return this.egress;
        }

        @Override
        public final Builder egress(Boolean egress) {
            this.egress = egress;
            return this;
        }

        public final void setEgress(Boolean egress) {
            this.egress = egress;
        }

        public final IcmpTypeCode.Builder getIcmpTypeCode() {
            return this.icmpTypeCode != null ? this.icmpTypeCode.toBuilder() : null;
        }

        @Override
        public final Builder icmpTypeCode(IcmpTypeCode icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode;
            return this;
        }

        public final void setIcmpTypeCode(IcmpTypeCode.BuilderImpl icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode != null ? icmpTypeCode.build() : null;
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final String getNetworkAclId() {
            return this.networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        public final PortRange.Builder getPortRange() {
            return this.portRange != null ? this.portRange.toBuilder() : null;
        }

        @Override
        public final Builder portRange(PortRange portRange) {
            this.portRange = portRange;
            return this;
        }

        public final void setPortRange(PortRange.BuilderImpl portRange) {
            this.portRange = portRange != null ? portRange.build() : null;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getRuleAction() {
            return this.ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        public final Builder ruleAction(RuleAction ruleAction) {
            this.ruleAction(ruleAction == null ? null : ruleAction.toString());
            return this;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        public final Integer getRuleNumber() {
            return this.ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkAclEntryRequest build() {
            return new CreateNetworkAclEntryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNetworkAclEntryRequest> {
        public Builder cidrBlock(String var1);

        public Builder egress(Boolean var1);

        public Builder icmpTypeCode(IcmpTypeCode var1);

        default public Builder icmpTypeCode(Consumer<IcmpTypeCode.Builder> icmpTypeCode) {
            return this.icmpTypeCode((IcmpTypeCode)((IcmpTypeCode.Builder)IcmpTypeCode.builder().applyMutation(icmpTypeCode)).build());
        }

        public Builder ipv6CidrBlock(String var1);

        public Builder networkAclId(String var1);

        public Builder portRange(PortRange var1);

        default public Builder portRange(Consumer<PortRange.Builder> portRange) {
            return this.portRange((PortRange)((PortRange.Builder)PortRange.builder().applyMutation(portRange)).build());
        }

        public Builder protocol(String var1);

        public Builder ruleAction(String var1);

        public Builder ruleAction(RuleAction var1);

        public Builder ruleNumber(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

