/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClientData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClientData> {
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(ClientData.getter(ClientData::comment)).setter(ClientData.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").unmarshallLocationName("Comment").build()}).build();
    private static final SdkField<Instant> UPLOAD_END_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UploadEnd").getter(ClientData.getter(ClientData::uploadEnd)).setter(ClientData.setter(Builder::uploadEnd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadEnd").unmarshallLocationName("UploadEnd").build()}).build();
    private static final SdkField<Double> UPLOAD_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("UploadSize").getter(ClientData.getter(ClientData::uploadSize)).setter(ClientData.setter(Builder::uploadSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadSize").unmarshallLocationName("UploadSize").build()}).build();
    private static final SdkField<Instant> UPLOAD_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UploadStart").getter(ClientData.getter(ClientData::uploadStart)).setter(ClientData.setter(Builder::uploadStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadStart").unmarshallLocationName("UploadStart").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD, UPLOAD_END_FIELD, UPLOAD_SIZE_FIELD, UPLOAD_START_FIELD));
    private static final long serialVersionUID = 1L;
    private final String comment;
    private final Instant uploadEnd;
    private final Double uploadSize;
    private final Instant uploadStart;

    private ClientData(BuilderImpl builder) {
        this.comment = builder.comment;
        this.uploadEnd = builder.uploadEnd;
        this.uploadSize = builder.uploadSize;
        this.uploadStart = builder.uploadStart;
    }

    public final String comment() {
        return this.comment;
    }

    public final Instant uploadEnd() {
        return this.uploadEnd;
    }

    public final Double uploadSize() {
        return this.uploadSize;
    }

    public final Instant uploadStart() {
        return this.uploadStart;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadEnd());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadStart());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientData)) {
            return false;
        }
        ClientData other = (ClientData)obj;
        return Objects.equals(this.comment(), other.comment()) && Objects.equals(this.uploadEnd(), other.uploadEnd()) && Objects.equals(this.uploadSize(), other.uploadSize()) && Objects.equals(this.uploadStart(), other.uploadStart());
    }

    public final String toString() {
        return ToString.builder((String)"ClientData").add("Comment", (Object)this.comment()).add("UploadEnd", (Object)this.uploadEnd()).add("UploadSize", (Object)this.uploadSize()).add("UploadStart", (Object)this.uploadStart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "UploadEnd": {
                return Optional.ofNullable(clazz.cast(this.uploadEnd()));
            }
            case "UploadSize": {
                return Optional.ofNullable(clazz.cast(this.uploadSize()));
            }
            case "UploadStart": {
                return Optional.ofNullable(clazz.cast(this.uploadStart()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientData, T> g) {
        return obj -> g.apply((ClientData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comment;
        private Instant uploadEnd;
        private Double uploadSize;
        private Instant uploadStart;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientData model) {
            this.comment(model.comment);
            this.uploadEnd(model.uploadEnd);
            this.uploadSize(model.uploadSize);
            this.uploadStart(model.uploadStart);
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Instant getUploadEnd() {
            return this.uploadEnd;
        }

        @Override
        public final Builder uploadEnd(Instant uploadEnd) {
            this.uploadEnd = uploadEnd;
            return this;
        }

        public final void setUploadEnd(Instant uploadEnd) {
            this.uploadEnd = uploadEnd;
        }

        public final Double getUploadSize() {
            return this.uploadSize;
        }

        @Override
        public final Builder uploadSize(Double uploadSize) {
            this.uploadSize = uploadSize;
            return this;
        }

        public final void setUploadSize(Double uploadSize) {
            this.uploadSize = uploadSize;
        }

        public final Instant getUploadStart() {
            return this.uploadStart;
        }

        @Override
        public final Builder uploadStart(Instant uploadStart) {
            this.uploadStart = uploadStart;
            return this;
        }

        public final void setUploadStart(Instant uploadStart) {
            this.uploadStart = uploadStart;
        }

        public ClientData build() {
            return new ClientData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClientData> {
        public Builder comment(String var1);

        public Builder uploadEnd(Instant var1);

        public Builder uploadSize(Double var1);

        public Builder uploadStart(Instant var1);
    }
}

