/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceNetworkInterfaceSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceNetworkInterfaceSpecification.Builder, InstanceNetworkInterfaceSpecification> {
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AssociatePublicIpAddress")
            .getter(getter(InstanceNetworkInterfaceSpecification::associatePublicIpAddress))
            .setter(setter(Builder::associatePublicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress")
                    .unmarshallLocationName("associatePublicIpAddress").build()).build();

    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteOnTermination")
            .getter(getter(InstanceNetworkInterfaceSpecification::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination")
                    .unmarshallLocationName("deleteOnTermination").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(InstanceNetworkInterfaceSpecification::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<Integer> DEVICE_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeviceIndex")
            .getter(getter(InstanceNetworkInterfaceSpecification::deviceIndex))
            .setter(setter(Builder::deviceIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIndex")
                    .unmarshallLocationName("deviceIndex").build()).build();

    private static final SdkField<List<String>> GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(InstanceNetworkInterfaceSpecification::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId")
                    .unmarshallLocationName("SecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId")
                                                    .build()).build()).build()).build();

    private static final SdkField<Integer> IPV6_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6AddressCount")
            .getter(getter(InstanceNetworkInterfaceSpecification::ipv6AddressCount))
            .setter(setter(Builder::ipv6AddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressCount")
                    .unmarshallLocationName("ipv6AddressCount").build()).build();

    private static final SdkField<List<InstanceIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField
            .<List<InstanceIpv6Address>> builder(MarshallingType.LIST)
            .memberName("Ipv6Addresses")
            .getter(getter(InstanceNetworkInterfaceSpecification::ipv6Addresses))
            .setter(setter(Builder::ipv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Addresses")
                    .unmarshallLocationName("ipv6AddressesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceIpv6Address> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceIpv6Address::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(InstanceNetworkInterfaceSpecification::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress")
            .getter(getter(InstanceNetworkInterfaceSpecification::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("privateIpAddress").build()).build();

    private static final SdkField<List<PrivateIpAddressSpecification>> PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<PrivateIpAddressSpecification>> builder(MarshallingType.LIST)
            .memberName("PrivateIpAddresses")
            .getter(getter(InstanceNetworkInterfaceSpecification::privateIpAddresses))
            .setter(setter(Builder::privateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddresses")
                    .unmarshallLocationName("privateIpAddressesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PrivateIpAddressSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrivateIpAddressSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SecondaryPrivateIpAddressCount")
            .getter(getter(InstanceNetworkInterfaceSpecification::secondaryPrivateIpAddressCount))
            .setter(setter(Builder::secondaryPrivateIpAddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddressCount")
                    .unmarshallLocationName("secondaryPrivateIpAddressCount").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(InstanceNetworkInterfaceSpecification::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<Boolean> ASSOCIATE_CARRIER_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AssociateCarrierIpAddress")
            .getter(getter(InstanceNetworkInterfaceSpecification::associateCarrierIpAddress))
            .setter(setter(Builder::associateCarrierIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociateCarrierIpAddress")
                    .unmarshallLocationName("AssociateCarrierIpAddress").build()).build();

    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InterfaceType")
            .getter(getter(InstanceNetworkInterfaceSpecification::interfaceType))
            .setter(setter(Builder::interfaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType")
                    .unmarshallLocationName("InterfaceType").build()).build();

    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NetworkCardIndex")
            .getter(getter(InstanceNetworkInterfaceSpecification::networkCardIndex))
            .setter(setter(Builder::networkCardIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex")
                    .unmarshallLocationName("NetworkCardIndex").build()).build();

    private static final SdkField<List<Ipv4PrefixSpecificationRequest>> IPV4_PREFIXES_FIELD = SdkField
            .<List<Ipv4PrefixSpecificationRequest>> builder(MarshallingType.LIST)
            .memberName("Ipv4Prefixes")
            .getter(getter(InstanceNetworkInterfaceSpecification::ipv4Prefixes))
            .setter(setter(Builder::ipv4Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4Prefix")
                    .unmarshallLocationName("Ipv4Prefix").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Ipv4PrefixSpecificationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv4PrefixSpecificationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> IPV4_PREFIX_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv4PrefixCount")
            .getter(getter(InstanceNetworkInterfaceSpecification::ipv4PrefixCount))
            .setter(setter(Builder::ipv4PrefixCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4PrefixCount")
                    .unmarshallLocationName("Ipv4PrefixCount").build()).build();

    private static final SdkField<List<Ipv6PrefixSpecificationRequest>> IPV6_PREFIXES_FIELD = SdkField
            .<List<Ipv6PrefixSpecificationRequest>> builder(MarshallingType.LIST)
            .memberName("Ipv6Prefixes")
            .getter(getter(InstanceNetworkInterfaceSpecification::ipv6Prefixes))
            .setter(setter(Builder::ipv6Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Prefix")
                    .unmarshallLocationName("Ipv6Prefix").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Ipv6PrefixSpecificationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv6PrefixSpecificationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> IPV6_PREFIX_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6PrefixCount")
            .getter(getter(InstanceNetworkInterfaceSpecification::ipv6PrefixCount))
            .setter(setter(Builder::ipv6PrefixCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6PrefixCount")
                    .unmarshallLocationName("Ipv6PrefixCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, DELETE_ON_TERMINATION_FIELD, DESCRIPTION_FIELD, DEVICE_INDEX_FIELD, GROUPS_FIELD,
            IPV6_ADDRESS_COUNT_FIELD, IPV6_ADDRESSES_FIELD, NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_ADDRESS_FIELD,
            PRIVATE_IP_ADDRESSES_FIELD, SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD, SUBNET_ID_FIELD,
            ASSOCIATE_CARRIER_IP_ADDRESS_FIELD, INTERFACE_TYPE_FIELD, NETWORK_CARD_INDEX_FIELD, IPV4_PREFIXES_FIELD,
            IPV4_PREFIX_COUNT_FIELD, IPV6_PREFIXES_FIELD, IPV6_PREFIX_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean associatePublicIpAddress;

    private final Boolean deleteOnTermination;

    private final String description;

    private final Integer deviceIndex;

    private final List<String> groups;

    private final Integer ipv6AddressCount;

    private final List<InstanceIpv6Address> ipv6Addresses;

    private final String networkInterfaceId;

    private final String privateIpAddress;

    private final List<PrivateIpAddressSpecification> privateIpAddresses;

    private final Integer secondaryPrivateIpAddressCount;

    private final String subnetId;

    private final Boolean associateCarrierIpAddress;

    private final String interfaceType;

    private final Integer networkCardIndex;

    private final List<Ipv4PrefixSpecificationRequest> ipv4Prefixes;

    private final Integer ipv4PrefixCount;

    private final List<Ipv6PrefixSpecificationRequest> ipv6Prefixes;

    private final Integer ipv6PrefixCount;

    private InstanceNetworkInterfaceSpecification(BuilderImpl builder) {
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.description = builder.description;
        this.deviceIndex = builder.deviceIndex;
        this.groups = builder.groups;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
        this.subnetId = builder.subnetId;
        this.associateCarrierIpAddress = builder.associateCarrierIpAddress;
        this.interfaceType = builder.interfaceType;
        this.networkCardIndex = builder.networkCardIndex;
        this.ipv4Prefixes = builder.ipv4Prefixes;
        this.ipv4PrefixCount = builder.ipv4PrefixCount;
        this.ipv6Prefixes = builder.ipv6Prefixes;
        this.ipv6PrefixCount = builder.ipv6PrefixCount;
    }

    /**
     * <p>
     * Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The public IP address can
     * only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an
     * existing one. You cannot specify more than one network interface in the request. If launching into a default
     * subnet, the default value is <code>true</code>.
     * </p>
     * 
     * @return Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The public IP
     *         address can only be assigned to a network interface for eth0, and can only be assigned to a new network
     *         interface, not an existing one. You cannot specify more than one network interface in the request. If
     *         launching into a default subnet, the default value is <code>true</code>.
     */
    public final Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * If set to <code>true</code>, the interface is deleted when the instance is terminated. You can specify
     * <code>true</code> only if creating a new network interface when launching an instance.
     * </p>
     * 
     * @return If set to <code>true</code>, the interface is deleted when the instance is terminated. You can specify
     *         <code>true</code> only if creating a new network interface when launching an instance.
     */
    public final Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * The description of the network interface. Applies only if creating a network interface when launching an
     * instance.
     * </p>
     * 
     * @return The description of the network interface. Applies only if creating a network interface when launching an
     *         instance.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The position of the network interface in the attachment order. A primary network interface has a device index of
     * 0.
     * </p>
     * <p>
     * If you specify a network interface when launching an instance, you must specify the device index.
     * </p>
     * 
     * @return The position of the network interface in the attachment order. A primary network interface has a device
     *         index of 0.</p>
     *         <p>
     *         If you specify a network interface when launching an instance, you must specify the device index.
     */
    public final Integer deviceIndex() {
        return deviceIndex;
    }

    /**
     * Returns true if the Groups property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security groups for the network interface. Applies only if creating a network interface when
     * launching an instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the security groups for the network interface. Applies only if creating a network interface
     *         when launching an instance.
     */
    public final List<String> groups() {
        return groups;
    }

    /**
     * <p>
     * A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses the IPv6 addresses from the
     * range of the subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same
     * request. You can specify this option if you've specified a minimum number of instances to launch.
     * </p>
     * 
     * @return A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses the IPv6 addresses from
     *         the range of the subnet. You cannot specify this option and the option to assign specific IPv6 addresses
     *         in the same request. You can specify this option if you've specified a minimum number of instances to
     *         launch.
     */
    public final Integer ipv6AddressCount() {
        return ipv6AddressCount;
    }

    /**
     * Returns true if the Ipv6Addresses property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIpv6Addresses() {
        return ipv6Addresses != null && !(ipv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the option to
     * assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a
     * minimum number of instances to launch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpv6Addresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the
     *         option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've
     *         specified a minimum number of instances to launch.
     */
    public final List<InstanceIpv6Address> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * <p>
     * If you are creating a Spot Fleet, omit this parameter because you can’t specify a network interface ID in a
     * launch specification.
     * </p>
     * 
     * @return The ID of the network interface.</p>
     *         <p>
     *         If you are creating a Spot Fleet, omit this parameter because you can’t specify a network interface ID in
     *         a launch specification.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The private IPv4 address of the network interface. Applies only if creating a network interface when launching an
     * instance. You cannot specify this option if you're launching more than one instance in a <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.
     * </p>
     * 
     * @return The private IPv4 address of the network interface. Applies only if creating a network interface when
     *         launching an instance. You cannot specify this option if you're launching more than one instance in a <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>
     *         request.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * Returns true if the PrivateIpAddresses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPrivateIpAddresses() {
        return privateIpAddresses != null && !(privateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be
     * designated as primary. You cannot specify this option if you're launching more than one instance in a <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPrivateIpAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can
     *         be designated as primary. You cannot specify this option if you're launching more than one instance in a
     *         <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>
     *         request.
     */
    public final List<PrivateIpAddressSpecification> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * The number of secondary private IPv4 addresses. You can't specify this option and specify more than one private
     * IP address using the private IP addresses option. You cannot specify this option if you're launching more than
     * one instance in a <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.
     * </p>
     * 
     * @return The number of secondary private IPv4 addresses. You can't specify this option and specify more than one
     *         private IP address using the private IP addresses option. You cannot specify this option if you're
     *         launching more than one instance in a <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>
     *         request.
     */
    public final Integer secondaryPrivateIpAddressCount() {
        return secondaryPrivateIpAddressCount;
    }

    /**
     * <p>
     * The ID of the subnet associated with the network interface. Applies only if creating a network interface when
     * launching an instance.
     * </p>
     * 
     * @return The ID of the subnet associated with the network interface. Applies only if creating a network interface
     *         when launching an instance.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * Indicates whether to assign a carrier IP address to the network interface.
     * </p>
     * <p>
     * You can only assign a carrier IP address to a network interface that is in a subnet in a Wavelength Zone. For
     * more information about carrier IP addresses, see Carrier IP addresses in the Amazon Web Services Wavelength
     * Developer Guide.
     * </p>
     * 
     * @return Indicates whether to assign a carrier IP address to the network interface.</p>
     *         <p>
     *         You can only assign a carrier IP address to a network interface that is in a subnet in a Wavelength Zone.
     *         For more information about carrier IP addresses, see Carrier IP addresses in the Amazon Web Services
     *         Wavelength Developer Guide.
     */
    public final Boolean associateCarrierIpAddress() {
        return associateCarrierIpAddress;
    }

    /**
     * <p>
     * The type of network interface.
     * </p>
     * <p>
     * To create an Elastic Fabric Adapter (EFA), specify <code>efa</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html">Elastic Fabric Adapter</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Valid values: <code>interface</code> | <code>efa</code>
     * </p>
     * 
     * @return The type of network interface.</p>
     *         <p>
     *         To create an Elastic Fabric Adapter (EFA), specify <code>efa</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html">Elastic Fabric Adapter</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     *         </p>
     *         <p>
     *         Valid values: <code>interface</code> | <code>efa</code>
     */
    public final String interfaceType() {
        return interfaceType;
    }

    /**
     * <p>
     * The index of the network card. Some instance types support multiple network cards. The primary network interface
     * must be assigned to network card index 0. The default is network card index 0.
     * </p>
     * 
     * @return The index of the network card. Some instance types support multiple network cards. The primary network
     *         interface must be assigned to network card index 0. The default is network card index 0.
     */
    public final Integer networkCardIndex() {
        return networkCardIndex;
    }

    /**
     * Returns true if the Ipv4Prefixes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIpv4Prefixes() {
        return ipv4Prefixes != null && !(ipv4Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more IPv4 delegated prefixes to be assigned to the network interface. You cannot use this option if you
     * use the <code>Ipv4PrefixCount</code> option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpv4Prefixes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more IPv4 delegated prefixes to be assigned to the network interface. You cannot use this option
     *         if you use the <code>Ipv4PrefixCount</code> option.
     */
    public final List<Ipv4PrefixSpecificationRequest> ipv4Prefixes() {
        return ipv4Prefixes;
    }

    /**
     * <p>
     * The number of IPv4 delegated prefixes to be automatically assigned to the network interface. You cannot use this
     * option if you use the <code>Ipv4Prefix</code> option.
     * </p>
     * 
     * @return The number of IPv4 delegated prefixes to be automatically assigned to the network interface. You cannot
     *         use this option if you use the <code>Ipv4Prefix</code> option.
     */
    public final Integer ipv4PrefixCount() {
        return ipv4PrefixCount;
    }

    /**
     * Returns true if the Ipv6Prefixes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIpv6Prefixes() {
        return ipv6Prefixes != null && !(ipv6Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more IPv6 delegated prefixes to be assigned to the network interface. You cannot use this option if you
     * use the <code>Ipv6PrefixCount</code> option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpv6Prefixes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more IPv6 delegated prefixes to be assigned to the network interface. You cannot use this option
     *         if you use the <code>Ipv6PrefixCount</code> option.
     */
    public final List<Ipv6PrefixSpecificationRequest> ipv6Prefixes() {
        return ipv6Prefixes;
    }

    /**
     * <p>
     * The number of IPv6 delegated prefixes to be automatically assigned to the network interface. You cannot use this
     * option if you use the <code>Ipv6Prefix</code> option.
     * </p>
     * 
     * @return The number of IPv6 delegated prefixes to be automatically assigned to the network interface. You cannot
     *         use this option if you use the <code>Ipv6Prefix</code> option.
     */
    public final Integer ipv6PrefixCount() {
        return ipv6PrefixCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Addresses() ? ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateIpAddresses() ? privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(secondaryPrivateIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(associateCarrierIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceType());
        hashCode = 31 * hashCode + Objects.hashCode(networkCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv4Prefixes() ? ipv4Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipv4PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Prefixes() ? ipv6Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipv6PrefixCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterfaceSpecification)) {
            return false;
        }
        InstanceNetworkInterfaceSpecification other = (InstanceNetworkInterfaceSpecification) obj;
        return Objects.equals(associatePublicIpAddress(), other.associatePublicIpAddress())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination())
                && Objects.equals(description(), other.description()) && Objects.equals(deviceIndex(), other.deviceIndex())
                && hasGroups() == other.hasGroups() && Objects.equals(groups(), other.groups())
                && Objects.equals(ipv6AddressCount(), other.ipv6AddressCount()) && hasIpv6Addresses() == other.hasIpv6Addresses()
                && Objects.equals(ipv6Addresses(), other.ipv6Addresses())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && hasPrivateIpAddresses() == other.hasPrivateIpAddresses()
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && Objects.equals(secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount())
                && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(associateCarrierIpAddress(), other.associateCarrierIpAddress())
                && Objects.equals(interfaceType(), other.interfaceType())
                && Objects.equals(networkCardIndex(), other.networkCardIndex()) && hasIpv4Prefixes() == other.hasIpv4Prefixes()
                && Objects.equals(ipv4Prefixes(), other.ipv4Prefixes())
                && Objects.equals(ipv4PrefixCount(), other.ipv4PrefixCount()) && hasIpv6Prefixes() == other.hasIpv6Prefixes()
                && Objects.equals(ipv6Prefixes(), other.ipv6Prefixes())
                && Objects.equals(ipv6PrefixCount(), other.ipv6PrefixCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceNetworkInterfaceSpecification")
                .add("AssociatePublicIpAddress", associatePublicIpAddress()).add("DeleteOnTermination", deleteOnTermination())
                .add("Description", description()).add("DeviceIndex", deviceIndex()).add("Groups", hasGroups() ? groups() : null)
                .add("Ipv6AddressCount", ipv6AddressCount()).add("Ipv6Addresses", hasIpv6Addresses() ? ipv6Addresses() : null)
                .add("NetworkInterfaceId", networkInterfaceId()).add("PrivateIpAddress", privateIpAddress())
                .add("PrivateIpAddresses", hasPrivateIpAddresses() ? privateIpAddresses() : null)
                .add("SecondaryPrivateIpAddressCount", secondaryPrivateIpAddressCount()).add("SubnetId", subnetId())
                .add("AssociateCarrierIpAddress", associateCarrierIpAddress()).add("InterfaceType", interfaceType())
                .add("NetworkCardIndex", networkCardIndex()).add("Ipv4Prefixes", hasIpv4Prefixes() ? ipv4Prefixes() : null)
                .add("Ipv4PrefixCount", ipv4PrefixCount()).add("Ipv6Prefixes", hasIpv6Prefixes() ? ipv6Prefixes() : null)
                .add("Ipv6PrefixCount", ipv6PrefixCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociatePublicIpAddress":
            return Optional.ofNullable(clazz.cast(associatePublicIpAddress()));
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DeviceIndex":
            return Optional.ofNullable(clazz.cast(deviceIndex()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "Ipv6AddressCount":
            return Optional.ofNullable(clazz.cast(ipv6AddressCount()));
        case "Ipv6Addresses":
            return Optional.ofNullable(clazz.cast(ipv6Addresses()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "PrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(privateIpAddresses()));
        case "SecondaryPrivateIpAddressCount":
            return Optional.ofNullable(clazz.cast(secondaryPrivateIpAddressCount()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "AssociateCarrierIpAddress":
            return Optional.ofNullable(clazz.cast(associateCarrierIpAddress()));
        case "InterfaceType":
            return Optional.ofNullable(clazz.cast(interfaceType()));
        case "NetworkCardIndex":
            return Optional.ofNullable(clazz.cast(networkCardIndex()));
        case "Ipv4Prefixes":
            return Optional.ofNullable(clazz.cast(ipv4Prefixes()));
        case "Ipv4PrefixCount":
            return Optional.ofNullable(clazz.cast(ipv4PrefixCount()));
        case "Ipv6Prefixes":
            return Optional.ofNullable(clazz.cast(ipv6Prefixes()));
        case "Ipv6PrefixCount":
            return Optional.ofNullable(clazz.cast(ipv6PrefixCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceNetworkInterfaceSpecification, T> g) {
        return obj -> g.apply((InstanceNetworkInterfaceSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceNetworkInterfaceSpecification> {
        /**
         * <p>
         * Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The public IP address
         * can only be assigned to a network interface for eth0, and can only be assigned to a new network interface,
         * not an existing one. You cannot specify more than one network interface in the request. If launching into a
         * default subnet, the default value is <code>true</code>.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The public IP
         *        address can only be assigned to a network interface for eth0, and can only be assigned to a new
         *        network interface, not an existing one. You cannot specify more than one network interface in the
         *        request. If launching into a default subnet, the default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * If set to <code>true</code>, the interface is deleted when the instance is terminated. You can specify
         * <code>true</code> only if creating a new network interface when launching an instance.
         * </p>
         * 
         * @param deleteOnTermination
         *        If set to <code>true</code>, the interface is deleted when the instance is terminated. You can specify
         *        <code>true</code> only if creating a new network interface when launching an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * The description of the network interface. Applies only if creating a network interface when launching an
         * instance.
         * </p>
         * 
         * @param description
         *        The description of the network interface. Applies only if creating a network interface when launching
         *        an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The position of the network interface in the attachment order. A primary network interface has a device index
         * of 0.
         * </p>
         * <p>
         * If you specify a network interface when launching an instance, you must specify the device index.
         * </p>
         * 
         * @param deviceIndex
         *        The position of the network interface in the attachment order. A primary network interface has a
         *        device index of 0.</p>
         *        <p>
         *        If you specify a network interface when launching an instance, you must specify the device index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIndex(Integer deviceIndex);

        /**
         * <p>
         * The IDs of the security groups for the network interface. Applies only if creating a network interface when
         * launching an instance.
         * </p>
         * 
         * @param groups
         *        The IDs of the security groups for the network interface. Applies only if creating a network interface
         *        when launching an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * The IDs of the security groups for the network interface. Applies only if creating a network interface when
         * launching an instance.
         * </p>
         * 
         * @param groups
         *        The IDs of the security groups for the network interface. Applies only if creating a network interface
         *        when launching an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * <p>
         * A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses the IPv6 addresses from the
         * range of the subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the
         * same request. You can specify this option if you've specified a minimum number of instances to launch.
         * </p>
         * 
         * @param ipv6AddressCount
         *        A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses the IPv6 addresses
         *        from the range of the subnet. You cannot specify this option and the option to assign specific IPv6
         *        addresses in the same request. You can specify this option if you've specified a minimum number of
         *        instances to launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6AddressCount(Integer ipv6AddressCount);

        /**
         * <p>
         * One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the option
         * to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified
         * a minimum number of instances to launch.
         * </p>
         * 
         * @param ipv6Addresses
         *        One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the
         *        option to assign a number of IPv6 addresses in the same request. You cannot specify this option if
         *        you've specified a minimum number of instances to launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses);

        /**
         * <p>
         * One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the option
         * to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified
         * a minimum number of instances to launch.
         * </p>
         * 
         * @param ipv6Addresses
         *        One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the
         *        option to assign a number of IPv6 addresses in the same request. You cannot specify this option if
         *        you've specified a minimum number of instances to launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses);

        /**
         * <p>
         * One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the option
         * to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified
         * a minimum number of instances to launch.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceIpv6Address>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceIpv6Address>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceIpv6Address>.Builder#build()} is called immediately
         * and its result is passed to {@link #ipv6Addresses(List<InstanceIpv6Address>)}.
         * 
         * @param ipv6Addresses
         *        a consumer that will call methods on {@link List<InstanceIpv6Address>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Addresses(List<InstanceIpv6Address>)
         */
        Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder>... ipv6Addresses);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * <p>
         * If you are creating a Spot Fleet, omit this parameter because you can’t specify a network interface ID in a
         * launch specification.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.</p>
         *        <p>
         *        If you are creating a Spot Fleet, omit this parameter because you can’t specify a network interface ID
         *        in a launch specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The private IPv4 address of the network interface. Applies only if creating a network interface when
         * launching an instance. You cannot specify this option if you're launching more than one instance in a <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IPv4 address of the network interface. Applies only if creating a network interface when
         *        launching an instance. You cannot specify this option if you're launching more than one instance in a
         *        <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be
         * designated as primary. You cannot specify this option if you're launching more than one instance in a <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address
         *        can be designated as primary. You cannot specify this option if you're launching more than one
         *        instance in a <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses);

        /**
         * <p>
         * One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be
         * designated as primary. You cannot specify this option if you're launching more than one instance in a <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address
         *        can be designated as primary. You cannot specify this option if you're launching more than one
         *        instance in a <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(PrivateIpAddressSpecification... privateIpAddresses);

        /**
         * <p>
         * One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be
         * designated as primary. You cannot specify this option if you're launching more than one instance in a <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PrivateIpAddressSpecification>.Builder}
         * avoiding the need to create one manually via {@link List<PrivateIpAddressSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PrivateIpAddressSpecification>.Builder#build()} is called
         * immediately and its result is passed to {@link #privateIpAddresses(List<PrivateIpAddressSpecification>)}.
         * 
         * @param privateIpAddresses
         *        a consumer that will call methods on {@link List<PrivateIpAddressSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateIpAddresses(List<PrivateIpAddressSpecification>)
         */
        Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder>... privateIpAddresses);

        /**
         * <p>
         * The number of secondary private IPv4 addresses. You can't specify this option and specify more than one
         * private IP address using the private IP addresses option. You cannot specify this option if you're launching
         * more than one instance in a <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.
         * </p>
         * 
         * @param secondaryPrivateIpAddressCount
         *        The number of secondary private IPv4 addresses. You can't specify this option and specify more than
         *        one private IP address using the private IP addresses option. You cannot specify this option if you're
         *        launching more than one instance in a <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount);

        /**
         * <p>
         * The ID of the subnet associated with the network interface. Applies only if creating a network interface when
         * launching an instance.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet associated with the network interface. Applies only if creating a network
         *        interface when launching an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * Indicates whether to assign a carrier IP address to the network interface.
         * </p>
         * <p>
         * You can only assign a carrier IP address to a network interface that is in a subnet in a Wavelength Zone. For
         * more information about carrier IP addresses, see Carrier IP addresses in the Amazon Web Services Wavelength
         * Developer Guide.
         * </p>
         * 
         * @param associateCarrierIpAddress
         *        Indicates whether to assign a carrier IP address to the network interface.</p>
         *        <p>
         *        You can only assign a carrier IP address to a network interface that is in a subnet in a Wavelength
         *        Zone. For more information about carrier IP addresses, see Carrier IP addresses in the Amazon Web
         *        Services Wavelength Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associateCarrierIpAddress(Boolean associateCarrierIpAddress);

        /**
         * <p>
         * The type of network interface.
         * </p>
         * <p>
         * To create an Elastic Fabric Adapter (EFA), specify <code>efa</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html">Elastic Fabric Adapter</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * <p>
         * Valid values: <code>interface</code> | <code>efa</code>
         * </p>
         * 
         * @param interfaceType
         *        The type of network interface.</p>
         *        <p>
         *        To create an Elastic Fabric Adapter (EFA), specify <code>efa</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html">Elastic Fabric Adapter</a> in the
         *        <i>Amazon Elastic Compute Cloud User Guide</i>.
         *        </p>
         *        <p>
         *        Valid values: <code>interface</code> | <code>efa</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceType(String interfaceType);

        /**
         * <p>
         * The index of the network card. Some instance types support multiple network cards. The primary network
         * interface must be assigned to network card index 0. The default is network card index 0.
         * </p>
         * 
         * @param networkCardIndex
         *        The index of the network card. Some instance types support multiple network cards. The primary network
         *        interface must be assigned to network card index 0. The default is network card index 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkCardIndex(Integer networkCardIndex);

        /**
         * <p>
         * One or more IPv4 delegated prefixes to be assigned to the network interface. You cannot use this option if
         * you use the <code>Ipv4PrefixCount</code> option.
         * </p>
         * 
         * @param ipv4Prefixes
         *        One or more IPv4 delegated prefixes to be assigned to the network interface. You cannot use this
         *        option if you use the <code>Ipv4PrefixCount</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(Collection<Ipv4PrefixSpecificationRequest> ipv4Prefixes);

        /**
         * <p>
         * One or more IPv4 delegated prefixes to be assigned to the network interface. You cannot use this option if
         * you use the <code>Ipv4PrefixCount</code> option.
         * </p>
         * 
         * @param ipv4Prefixes
         *        One or more IPv4 delegated prefixes to be assigned to the network interface. You cannot use this
         *        option if you use the <code>Ipv4PrefixCount</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(Ipv4PrefixSpecificationRequest... ipv4Prefixes);

        /**
         * <p>
         * One or more IPv4 delegated prefixes to be assigned to the network interface. You cannot use this option if
         * you use the <code>Ipv4PrefixCount</code> option.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Ipv4PrefixSpecificationRequest>.Builder}
         * avoiding the need to create one manually via {@link List<Ipv4PrefixSpecificationRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Ipv4PrefixSpecificationRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv4Prefixes(List<Ipv4PrefixSpecificationRequest>)}.
         * 
         * @param ipv4Prefixes
         *        a consumer that will call methods on {@link List<Ipv4PrefixSpecificationRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv4Prefixes(List<Ipv4PrefixSpecificationRequest>)
         */
        Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecificationRequest.Builder>... ipv4Prefixes);

        /**
         * <p>
         * The number of IPv4 delegated prefixes to be automatically assigned to the network interface. You cannot use
         * this option if you use the <code>Ipv4Prefix</code> option.
         * </p>
         * 
         * @param ipv4PrefixCount
         *        The number of IPv4 delegated prefixes to be automatically assigned to the network interface. You
         *        cannot use this option if you use the <code>Ipv4Prefix</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4PrefixCount(Integer ipv4PrefixCount);

        /**
         * <p>
         * One or more IPv6 delegated prefixes to be assigned to the network interface. You cannot use this option if
         * you use the <code>Ipv6PrefixCount</code> option.
         * </p>
         * 
         * @param ipv6Prefixes
         *        One or more IPv6 delegated prefixes to be assigned to the network interface. You cannot use this
         *        option if you use the <code>Ipv6PrefixCount</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Prefixes(Collection<Ipv6PrefixSpecificationRequest> ipv6Prefixes);

        /**
         * <p>
         * One or more IPv6 delegated prefixes to be assigned to the network interface. You cannot use this option if
         * you use the <code>Ipv6PrefixCount</code> option.
         * </p>
         * 
         * @param ipv6Prefixes
         *        One or more IPv6 delegated prefixes to be assigned to the network interface. You cannot use this
         *        option if you use the <code>Ipv6PrefixCount</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Prefixes(Ipv6PrefixSpecificationRequest... ipv6Prefixes);

        /**
         * <p>
         * One or more IPv6 delegated prefixes to be assigned to the network interface. You cannot use this option if
         * you use the <code>Ipv6PrefixCount</code> option.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Ipv6PrefixSpecificationRequest>.Builder}
         * avoiding the need to create one manually via {@link List<Ipv6PrefixSpecificationRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Ipv6PrefixSpecificationRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv6Prefixes(List<Ipv6PrefixSpecificationRequest>)}.
         * 
         * @param ipv6Prefixes
         *        a consumer that will call methods on {@link List<Ipv6PrefixSpecificationRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Prefixes(List<Ipv6PrefixSpecificationRequest>)
         */
        Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecificationRequest.Builder>... ipv6Prefixes);

        /**
         * <p>
         * The number of IPv6 delegated prefixes to be automatically assigned to the network interface. You cannot use
         * this option if you use the <code>Ipv6Prefix</code> option.
         * </p>
         * 
         * @param ipv6PrefixCount
         *        The number of IPv6 delegated prefixes to be automatically assigned to the network interface. You
         *        cannot use this option if you use the <code>Ipv6Prefix</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6PrefixCount(Integer ipv6PrefixCount);
    }

    static final class BuilderImpl implements Builder {
        private Boolean associatePublicIpAddress;

        private Boolean deleteOnTermination;

        private String description;

        private Integer deviceIndex;

        private List<String> groups = DefaultSdkAutoConstructList.getInstance();

        private Integer ipv6AddressCount;

        private List<InstanceIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private String networkInterfaceId;

        private String privateIpAddress;

        private List<PrivateIpAddressSpecification> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private Integer secondaryPrivateIpAddressCount;

        private String subnetId;

        private Boolean associateCarrierIpAddress;

        private String interfaceType;

        private Integer networkCardIndex;

        private List<Ipv4PrefixSpecificationRequest> ipv4Prefixes = DefaultSdkAutoConstructList.getInstance();

        private Integer ipv4PrefixCount;

        private List<Ipv6PrefixSpecificationRequest> ipv6Prefixes = DefaultSdkAutoConstructList.getInstance();

        private Integer ipv6PrefixCount;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworkInterfaceSpecification model) {
            associatePublicIpAddress(model.associatePublicIpAddress);
            deleteOnTermination(model.deleteOnTermination);
            description(model.description);
            deviceIndex(model.deviceIndex);
            groups(model.groups);
            ipv6AddressCount(model.ipv6AddressCount);
            ipv6Addresses(model.ipv6Addresses);
            networkInterfaceId(model.networkInterfaceId);
            privateIpAddress(model.privateIpAddress);
            privateIpAddresses(model.privateIpAddresses);
            secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
            subnetId(model.subnetId);
            associateCarrierIpAddress(model.associateCarrierIpAddress);
            interfaceType(model.interfaceType);
            networkCardIndex(model.networkCardIndex);
            ipv4Prefixes(model.ipv4Prefixes);
            ipv4PrefixCount(model.ipv4PrefixCount);
            ipv6Prefixes(model.ipv6Prefixes);
            ipv6PrefixCount(model.ipv6PrefixCount);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getDeviceIndex() {
            return deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        public final Collection<String> getGroups() {
            if (groups instanceof SdkAutoConstructList) {
                return null;
            }
            return groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
        }

        public final Integer getIpv6AddressCount() {
            return ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        public final List<InstanceIpv6Address.Builder> getIpv6Addresses() {
            List<InstanceIpv6Address.Builder> result = InstanceIpv6AddressListCopier.copyToBuilder(this.ipv6Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder>... ipv6Addresses) {
            ipv6Addresses(Stream.of(ipv6Addresses).map(c -> InstanceIpv6Address.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copyFromBuilder(ipv6Addresses);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final List<PrivateIpAddressSpecification.Builder> getPrivateIpAddresses() {
            List<PrivateIpAddressSpecification.Builder> result = PrivateIpAddressSpecificationListCopier
                    .copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(PrivateIpAddressSpecification... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder>... privateIpAddresses) {
            privateIpAddresses(Stream.of(privateIpAddresses)
                    .map(c -> PrivateIpAddressSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<PrivateIpAddressSpecification.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copyFromBuilder(privateIpAddresses);
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Boolean getAssociateCarrierIpAddress() {
            return associateCarrierIpAddress;
        }

        @Override
        public final Builder associateCarrierIpAddress(Boolean associateCarrierIpAddress) {
            this.associateCarrierIpAddress = associateCarrierIpAddress;
            return this;
        }

        public final void setAssociateCarrierIpAddress(Boolean associateCarrierIpAddress) {
            this.associateCarrierIpAddress = associateCarrierIpAddress;
        }

        public final String getInterfaceType() {
            return interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        public final Integer getNetworkCardIndex() {
            return networkCardIndex;
        }

        @Override
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        public final List<Ipv4PrefixSpecificationRequest.Builder> getIpv4Prefixes() {
            List<Ipv4PrefixSpecificationRequest.Builder> result = Ipv4PrefixListCopier.copyToBuilder(this.ipv4Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ipv4Prefixes(Collection<Ipv4PrefixSpecificationRequest> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixListCopier.copy(ipv4Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(Ipv4PrefixSpecificationRequest... ipv4Prefixes) {
            ipv4Prefixes(Arrays.asList(ipv4Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecificationRequest.Builder>... ipv4Prefixes) {
            ipv4Prefixes(Stream.of(ipv4Prefixes).map(c -> Ipv4PrefixSpecificationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIpv4Prefixes(Collection<Ipv4PrefixSpecificationRequest.BuilderImpl> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixListCopier.copyFromBuilder(ipv4Prefixes);
        }

        public final Integer getIpv4PrefixCount() {
            return ipv4PrefixCount;
        }

        @Override
        public final Builder ipv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
            return this;
        }

        public final void setIpv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
        }

        public final List<Ipv6PrefixSpecificationRequest.Builder> getIpv6Prefixes() {
            List<Ipv6PrefixSpecificationRequest.Builder> result = Ipv6PrefixListCopier.copyToBuilder(this.ipv6Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ipv6Prefixes(Collection<Ipv6PrefixSpecificationRequest> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixListCopier.copy(ipv6Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(Ipv6PrefixSpecificationRequest... ipv6Prefixes) {
            ipv6Prefixes(Arrays.asList(ipv6Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecificationRequest.Builder>... ipv6Prefixes) {
            ipv6Prefixes(Stream.of(ipv6Prefixes).map(c -> Ipv6PrefixSpecificationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6Prefixes(Collection<Ipv6PrefixSpecificationRequest.BuilderImpl> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixListCopier.copyFromBuilder(ipv6Prefixes);
        }

        public final Integer getIpv6PrefixCount() {
            return ipv6PrefixCount;
        }

        @Override
        public final Builder ipv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
            return this;
        }

        public final void setIpv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
        }

        @Override
        public InstanceNetworkInterfaceSpecification build() {
            return new InstanceNetworkInterfaceSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
