/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateInstanceEventWindowRequest extends Ec2Request implements
        ToCopyableBuilder<DisassociateInstanceEventWindowRequest.Builder, DisassociateInstanceEventWindowRequest> {
    private static final SdkField<String> INSTANCE_EVENT_WINDOW_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceEventWindowId")
            .getter(getter(DisassociateInstanceEventWindowRequest::instanceEventWindowId))
            .setter(setter(Builder::instanceEventWindowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceEventWindowId")
                    .unmarshallLocationName("InstanceEventWindowId").build()).build();

    private static final SdkField<InstanceEventWindowDisassociationRequest> ASSOCIATION_TARGET_FIELD = SdkField
            .<InstanceEventWindowDisassociationRequest> builder(MarshallingType.SDK_POJO)
            .memberName("AssociationTarget")
            .getter(getter(DisassociateInstanceEventWindowRequest::associationTarget))
            .setter(setter(Builder::associationTarget))
            .constructor(InstanceEventWindowDisassociationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationTarget")
                    .unmarshallLocationName("AssociationTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INSTANCE_EVENT_WINDOW_ID_FIELD, ASSOCIATION_TARGET_FIELD));

    private final String instanceEventWindowId;

    private final InstanceEventWindowDisassociationRequest associationTarget;

    private DisassociateInstanceEventWindowRequest(BuilderImpl builder) {
        super(builder);
        this.instanceEventWindowId = builder.instanceEventWindowId;
        this.associationTarget = builder.associationTarget;
    }

    /**
     * <p>
     * The ID of the event window.
     * </p>
     * 
     * @return The ID of the event window.
     */
    public final String instanceEventWindowId() {
        return instanceEventWindowId;
    }

    /**
     * <p>
     * One or more targets to disassociate from the specified event window.
     * </p>
     * 
     * @return One or more targets to disassociate from the specified event window.
     */
    public final InstanceEventWindowDisassociationRequest associationTarget() {
        return associationTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceEventWindowId());
        hashCode = 31 * hashCode + Objects.hashCode(associationTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateInstanceEventWindowRequest)) {
            return false;
        }
        DisassociateInstanceEventWindowRequest other = (DisassociateInstanceEventWindowRequest) obj;
        return Objects.equals(instanceEventWindowId(), other.instanceEventWindowId())
                && Objects.equals(associationTarget(), other.associationTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateInstanceEventWindowRequest").add("InstanceEventWindowId", instanceEventWindowId())
                .add("AssociationTarget", associationTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceEventWindowId":
            return Optional.ofNullable(clazz.cast(instanceEventWindowId()));
        case "AssociationTarget":
            return Optional.ofNullable(clazz.cast(associationTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateInstanceEventWindowRequest, T> g) {
        return obj -> g.apply((DisassociateInstanceEventWindowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateInstanceEventWindowRequest> {
        /**
         * <p>
         * The ID of the event window.
         * </p>
         * 
         * @param instanceEventWindowId
         *        The ID of the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceEventWindowId(String instanceEventWindowId);

        /**
         * <p>
         * One or more targets to disassociate from the specified event window.
         * </p>
         * 
         * @param associationTarget
         *        One or more targets to disassociate from the specified event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationTarget(InstanceEventWindowDisassociationRequest associationTarget);

        /**
         * <p>
         * One or more targets to disassociate from the specified event window.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link InstanceEventWindowDisassociationRequest.Builder} avoiding the need to create one manually via
         * {@link InstanceEventWindowDisassociationRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceEventWindowDisassociationRequest.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #associationTarget(InstanceEventWindowDisassociationRequest)}.
         * 
         * @param associationTarget
         *        a consumer that will call methods on {@link InstanceEventWindowDisassociationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationTarget(InstanceEventWindowDisassociationRequest)
         */
        default Builder associationTarget(Consumer<InstanceEventWindowDisassociationRequest.Builder> associationTarget) {
            return associationTarget(InstanceEventWindowDisassociationRequest.builder().applyMutation(associationTarget).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String instanceEventWindowId;

        private InstanceEventWindowDisassociationRequest associationTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateInstanceEventWindowRequest model) {
            super(model);
            instanceEventWindowId(model.instanceEventWindowId);
            associationTarget(model.associationTarget);
        }

        public final String getInstanceEventWindowId() {
            return instanceEventWindowId;
        }

        @Override
        public final Builder instanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
            return this;
        }

        public final void setInstanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
        }

        public final InstanceEventWindowDisassociationRequest.Builder getAssociationTarget() {
            return associationTarget != null ? associationTarget.toBuilder() : null;
        }

        @Override
        public final Builder associationTarget(InstanceEventWindowDisassociationRequest associationTarget) {
            this.associationTarget = associationTarget;
            return this;
        }

        public final void setAssociationTarget(InstanceEventWindowDisassociationRequest.BuilderImpl associationTarget) {
            this.associationTarget = associationTarget != null ? associationTarget.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateInstanceEventWindowRequest build() {
            return new DisassociateInstanceEventWindowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
