/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeElasticGpusResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeElasticGpusResponse.Builder, DescribeElasticGpusResponse> {
    private static final SdkField<List<ElasticGpus>> ELASTIC_GPU_SET_FIELD = SdkField
            .<List<ElasticGpus>> builder(MarshallingType.LIST)
            .memberName("ElasticGpuSet")
            .getter(getter(DescribeElasticGpusResponse::elasticGpuSet))
            .setter(setter(Builder::elasticGpuSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuSet")
                    .unmarshallLocationName("elasticGpuSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ElasticGpus> builder(MarshallingType.SDK_POJO)
                                            .constructor(ElasticGpus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeElasticGpusResponse::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeElasticGpusResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTIC_GPU_SET_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<ElasticGpus> elasticGpuSet;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeElasticGpusResponse(BuilderImpl builder) {
        super(builder);
        this.elasticGpuSet = builder.elasticGpuSet;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ElasticGpuSet property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasElasticGpuSet() {
        return elasticGpuSet != null && !(elasticGpuSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Elastic Graphics accelerators.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasElasticGpuSet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the Elastic Graphics accelerators.
     */
    public final List<ElasticGpus> elasticGpuSet() {
        return elasticGpuSet;
    }

    /**
     * <p>
     * The total number of items to return. If the total number of items available is more than the value specified in
     * max-items then a Next-Token will be provided in the output that you can use to resume pagination.
     * </p>
     * 
     * @return The total number of items to return. If the total number of items available is more than the value
     *         specified in max-items then a Next-Token will be provided in the output that you can use to resume
     *         pagination.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasElasticGpuSet() ? elasticGpuSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticGpusResponse)) {
            return false;
        }
        DescribeElasticGpusResponse other = (DescribeElasticGpusResponse) obj;
        return hasElasticGpuSet() == other.hasElasticGpuSet() && Objects.equals(elasticGpuSet(), other.elasticGpuSet())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeElasticGpusResponse").add("ElasticGpuSet", hasElasticGpuSet() ? elasticGpuSet() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticGpuSet":
            return Optional.ofNullable(clazz.cast(elasticGpuSet()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeElasticGpusResponse, T> g) {
        return obj -> g.apply((DescribeElasticGpusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeElasticGpusResponse> {
        /**
         * <p>
         * Information about the Elastic Graphics accelerators.
         * </p>
         * 
         * @param elasticGpuSet
         *        Information about the Elastic Graphics accelerators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuSet(Collection<ElasticGpus> elasticGpuSet);

        /**
         * <p>
         * Information about the Elastic Graphics accelerators.
         * </p>
         * 
         * @param elasticGpuSet
         *        Information about the Elastic Graphics accelerators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuSet(ElasticGpus... elasticGpuSet);

        /**
         * <p>
         * Information about the Elastic Graphics accelerators.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ElasticGpus>.Builder} avoiding the need to
         * create one manually via {@link List<ElasticGpus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ElasticGpus>.Builder#build()} is called immediately and its
         * result is passed to {@link #elasticGpuSet(List<ElasticGpus>)}.
         * 
         * @param elasticGpuSet
         *        a consumer that will call methods on {@link List<ElasticGpus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticGpuSet(List<ElasticGpus>)
         */
        Builder elasticGpuSet(Consumer<ElasticGpus.Builder>... elasticGpuSet);

        /**
         * <p>
         * The total number of items to return. If the total number of items available is more than the value specified
         * in max-items then a Next-Token will be provided in the output that you can use to resume pagination.
         * </p>
         * 
         * @param maxResults
         *        The total number of items to return. If the total number of items available is more than the value
         *        specified in max-items then a Next-Token will be provided in the output that you can use to resume
         *        pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ElasticGpus> elasticGpuSet = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticGpusResponse model) {
            super(model);
            elasticGpuSet(model.elasticGpuSet);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final List<ElasticGpus.Builder> getElasticGpuSet() {
            List<ElasticGpus.Builder> result = ElasticGpuSetCopier.copyToBuilder(this.elasticGpuSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder elasticGpuSet(Collection<ElasticGpus> elasticGpuSet) {
            this.elasticGpuSet = ElasticGpuSetCopier.copy(elasticGpuSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSet(ElasticGpus... elasticGpuSet) {
            elasticGpuSet(Arrays.asList(elasticGpuSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSet(Consumer<ElasticGpus.Builder>... elasticGpuSet) {
            elasticGpuSet(Stream.of(elasticGpuSet).map(c -> ElasticGpus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setElasticGpuSet(Collection<ElasticGpus.BuilderImpl> elasticGpuSet) {
            this.elasticGpuSet = ElasticGpuSetCopier.copyFromBuilder(elasticGpuSet);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeElasticGpusResponse build() {
            return new DescribeElasticGpusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
