/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options for a Connect attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTransitGatewayConnectRequestOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateTransitGatewayConnectRequestOptions.Builder, CreateTransitGatewayConnectRequestOptions> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Protocol")
            .getter(getter(CreateTransitGatewayConnectRequestOptions::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("Protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String protocol;

    private CreateTransitGatewayConnectRequestOptions(BuilderImpl builder) {
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * The tunnel protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The tunnel protocol.
     * @see ProtocolValue
     */
    public final ProtocolValue protocol() {
        return ProtocolValue.fromValue(protocol);
    }

    /**
     * <p>
     * The tunnel protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The tunnel protocol.
     * @see ProtocolValue
     */
    public final String protocolAsString() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayConnectRequestOptions)) {
            return false;
        }
        CreateTransitGatewayConnectRequestOptions other = (CreateTransitGatewayConnectRequestOptions) obj;
        return Objects.equals(protocolAsString(), other.protocolAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTransitGatewayConnectRequestOptions").add("Protocol", protocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayConnectRequestOptions, T> g) {
        return obj -> g.apply((CreateTransitGatewayConnectRequestOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateTransitGatewayConnectRequestOptions> {
        /**
         * <p>
         * The tunnel protocol.
         * </p>
         * 
         * @param protocol
         *        The tunnel protocol.
         * @see ProtocolValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolValue
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The tunnel protocol.
         * </p>
         * 
         * @param protocol
         *        The tunnel protocol.
         * @see ProtocolValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolValue
         */
        Builder protocol(ProtocolValue protocol);
    }

    static final class BuilderImpl implements Builder {
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayConnectRequestOptions model) {
            protocol(model.protocol);
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolValue protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public CreateTransitGatewayConnectRequestOptions build() {
            return new CreateTransitGatewayConnectRequestOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
