/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSubnetCidrReservationResponse extends Ec2Response implements
        ToCopyableBuilder<CreateSubnetCidrReservationResponse.Builder, CreateSubnetCidrReservationResponse> {
    private static final SdkField<SubnetCidrReservation> SUBNET_CIDR_RESERVATION_FIELD = SdkField
            .<SubnetCidrReservation> builder(MarshallingType.SDK_POJO)
            .memberName("SubnetCidrReservation")
            .getter(getter(CreateSubnetCidrReservationResponse::subnetCidrReservation))
            .setter(setter(Builder::subnetCidrReservation))
            .constructor(SubnetCidrReservation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetCidrReservation")
                    .unmarshallLocationName("subnetCidrReservation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SUBNET_CIDR_RESERVATION_FIELD));

    private final SubnetCidrReservation subnetCidrReservation;

    private CreateSubnetCidrReservationResponse(BuilderImpl builder) {
        super(builder);
        this.subnetCidrReservation = builder.subnetCidrReservation;
    }

    /**
     * <p>
     * Information about the created subnet CIDR reservation.
     * </p>
     * 
     * @return Information about the created subnet CIDR reservation.
     */
    public final SubnetCidrReservation subnetCidrReservation() {
        return subnetCidrReservation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subnetCidrReservation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubnetCidrReservationResponse)) {
            return false;
        }
        CreateSubnetCidrReservationResponse other = (CreateSubnetCidrReservationResponse) obj;
        return Objects.equals(subnetCidrReservation(), other.subnetCidrReservation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSubnetCidrReservationResponse").add("SubnetCidrReservation", subnetCidrReservation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetCidrReservation":
            return Optional.ofNullable(clazz.cast(subnetCidrReservation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubnetCidrReservationResponse, T> g) {
        return obj -> g.apply((CreateSubnetCidrReservationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateSubnetCidrReservationResponse> {
        /**
         * <p>
         * Information about the created subnet CIDR reservation.
         * </p>
         * 
         * @param subnetCidrReservation
         *        Information about the created subnet CIDR reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetCidrReservation(SubnetCidrReservation subnetCidrReservation);

        /**
         * <p>
         * Information about the created subnet CIDR reservation.
         * </p>
         * This is a convenience that creates an instance of the {@link SubnetCidrReservation.Builder} avoiding the need
         * to create one manually via {@link SubnetCidrReservation#builder()}.
         *
         * When the {@link Consumer} completes, {@link SubnetCidrReservation.Builder#build()} is called immediately and
         * its result is passed to {@link #subnetCidrReservation(SubnetCidrReservation)}.
         * 
         * @param subnetCidrReservation
         *        a consumer that will call methods on {@link SubnetCidrReservation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnetCidrReservation(SubnetCidrReservation)
         */
        default Builder subnetCidrReservation(Consumer<SubnetCidrReservation.Builder> subnetCidrReservation) {
            return subnetCidrReservation(SubnetCidrReservation.builder().applyMutation(subnetCidrReservation).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private SubnetCidrReservation subnetCidrReservation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubnetCidrReservationResponse model) {
            super(model);
            subnetCidrReservation(model.subnetCidrReservation);
        }

        public final SubnetCidrReservation.Builder getSubnetCidrReservation() {
            return subnetCidrReservation != null ? subnetCidrReservation.toBuilder() : null;
        }

        @Override
        public final Builder subnetCidrReservation(SubnetCidrReservation subnetCidrReservation) {
            this.subnetCidrReservation = subnetCidrReservation;
            return this;
        }

        public final void setSubnetCidrReservation(SubnetCidrReservation.BuilderImpl subnetCidrReservation) {
            this.subnetCidrReservation = subnetCidrReservation != null ? subnetCidrReservation.build() : null;
        }

        @Override
        public CreateSubnetCidrReservationResponse build() {
            return new CreateSubnetCidrReservationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
