/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateNetworkInterfacePermission.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNetworkInterfacePermissionRequest extends Ec2Request implements
        ToCopyableBuilder<CreateNetworkInterfacePermissionRequest.Builder, CreateNetworkInterfacePermissionRequest> {
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(CreateNetworkInterfacePermissionRequest::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("NetworkInterfaceId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId")
            .getter(getter(CreateNetworkInterfacePermissionRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId")
                    .unmarshallLocationName("AwsAccountId").build()).build();

    private static final SdkField<String> AWS_SERVICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AwsService")
            .getter(getter(CreateNetworkInterfacePermissionRequest::awsService))
            .setter(setter(Builder::awsService))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsService")
                    .unmarshallLocationName("AwsService").build()).build();

    private static final SdkField<String> PERMISSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Permission")
            .getter(getter(CreateNetworkInterfacePermissionRequest::permissionAsString))
            .setter(setter(Builder::permission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permission")
                    .unmarshallLocationName("Permission").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ID_FIELD,
            AWS_ACCOUNT_ID_FIELD, AWS_SERVICE_FIELD, PERMISSION_FIELD));

    private final String networkInterfaceId;

    private final String awsAccountId;

    private final String awsService;

    private final String permission;

    private CreateNetworkInterfacePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.networkInterfaceId = builder.networkInterfaceId;
        this.awsAccountId = builder.awsAccountId;
        this.awsService = builder.awsService;
        this.permission = builder.permission;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The Amazon Web Service. Currently not supported.
     * </p>
     * 
     * @return The Amazon Web Service. Currently not supported.
     */
    public final String awsService() {
        return awsService;
    }

    /**
     * <p>
     * The type of permission to grant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link InterfacePermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionAsString}.
     * </p>
     * 
     * @return The type of permission to grant.
     * @see InterfacePermissionType
     */
    public final InterfacePermissionType permission() {
        return InterfacePermissionType.fromValue(permission);
    }

    /**
     * <p>
     * The type of permission to grant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link InterfacePermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionAsString}.
     * </p>
     * 
     * @return The type of permission to grant.
     * @see InterfacePermissionType
     */
    public final String permissionAsString() {
        return permission;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsService());
        hashCode = 31 * hashCode + Objects.hashCode(permissionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkInterfacePermissionRequest)) {
            return false;
        }
        CreateNetworkInterfacePermissionRequest other = (CreateNetworkInterfacePermissionRequest) obj;
        return Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(awsService(), other.awsService())
                && Objects.equals(permissionAsString(), other.permissionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNetworkInterfacePermissionRequest").add("NetworkInterfaceId", networkInterfaceId())
                .add("AwsAccountId", awsAccountId()).add("AwsService", awsService()).add("Permission", permissionAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "AwsService":
            return Optional.ofNullable(clazz.cast(awsService()));
        case "Permission":
            return Optional.ofNullable(clazz.cast(permissionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkInterfacePermissionRequest, T> g) {
        return obj -> g.apply((CreateNetworkInterfacePermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateNetworkInterfacePermissionRequest> {
        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The Amazon Web Services account ID.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The Amazon Web Service. Currently not supported.
         * </p>
         * 
         * @param awsService
         *        The Amazon Web Service. Currently not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsService(String awsService);

        /**
         * <p>
         * The type of permission to grant.
         * </p>
         * 
         * @param permission
         *        The type of permission to grant.
         * @see InterfacePermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterfacePermissionType
         */
        Builder permission(String permission);

        /**
         * <p>
         * The type of permission to grant.
         * </p>
         * 
         * @param permission
         *        The type of permission to grant.
         * @see InterfacePermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterfacePermissionType
         */
        Builder permission(InterfacePermissionType permission);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String networkInterfaceId;

        private String awsAccountId;

        private String awsService;

        private String permission;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkInterfacePermissionRequest model) {
            super(model);
            networkInterfaceId(model.networkInterfaceId);
            awsAccountId(model.awsAccountId);
            awsService(model.awsService);
            permission(model.permission);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getAwsService() {
            return awsService;
        }

        @Override
        public final Builder awsService(String awsService) {
            this.awsService = awsService;
            return this;
        }

        public final void setAwsService(String awsService) {
            this.awsService = awsService;
        }

        public final String getPermission() {
            return permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(InterfacePermissionType permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkInterfacePermissionRequest build() {
            return new CreateNetworkInterfacePermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
