/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The capacity information for instances that can be launched onto the Dedicated Host.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailableCapacity implements SdkPojo, Serializable,
        ToCopyableBuilder<AvailableCapacity.Builder, AvailableCapacity> {
    private static final SdkField<List<InstanceCapacity>> AVAILABLE_INSTANCE_CAPACITY_FIELD = SdkField
            .<List<InstanceCapacity>> builder(MarshallingType.LIST)
            .memberName("AvailableInstanceCapacity")
            .getter(getter(AvailableCapacity::availableInstanceCapacity))
            .setter(setter(Builder::availableInstanceCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCapacity")
                    .unmarshallLocationName("availableInstanceCapacity").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceCapacity> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceCapacity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> AVAILABLE_V_CPUS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailableVCpus")
            .getter(getter(AvailableCapacity::availableVCpus))
            .setter(setter(Builder::availableVCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableVCpus")
                    .unmarshallLocationName("availableVCpus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AVAILABLE_INSTANCE_CAPACITY_FIELD, AVAILABLE_V_CPUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<InstanceCapacity> availableInstanceCapacity;

    private final Integer availableVCpus;

    private AvailableCapacity(BuilderImpl builder) {
        this.availableInstanceCapacity = builder.availableInstanceCapacity;
        this.availableVCpus = builder.availableVCpus;
    }

    /**
     * Returns true if the AvailableInstanceCapacity property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAvailableInstanceCapacity() {
        return availableInstanceCapacity != null && !(availableInstanceCapacity instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The number of instances that can be launched onto the Dedicated Host depending on the host's available capacity.
     * For Dedicated Hosts that support multiple instance types, this parameter represents the number of instances for
     * each instance size that is supported on the host.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAvailableInstanceCapacity()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The number of instances that can be launched onto the Dedicated Host depending on the host's available
     *         capacity. For Dedicated Hosts that support multiple instance types, this parameter represents the number
     *         of instances for each instance size that is supported on the host.
     */
    public final List<InstanceCapacity> availableInstanceCapacity() {
        return availableInstanceCapacity;
    }

    /**
     * <p>
     * The number of vCPUs available for launching instances onto the Dedicated Host.
     * </p>
     * 
     * @return The number of vCPUs available for launching instances onto the Dedicated Host.
     */
    public final Integer availableVCpus() {
        return availableVCpus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailableInstanceCapacity() ? availableInstanceCapacity() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availableVCpus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailableCapacity)) {
            return false;
        }
        AvailableCapacity other = (AvailableCapacity) obj;
        return hasAvailableInstanceCapacity() == other.hasAvailableInstanceCapacity()
                && Objects.equals(availableInstanceCapacity(), other.availableInstanceCapacity())
                && Objects.equals(availableVCpus(), other.availableVCpus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AvailableCapacity")
                .add("AvailableInstanceCapacity", hasAvailableInstanceCapacity() ? availableInstanceCapacity() : null)
                .add("AvailableVCpus", availableVCpus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailableInstanceCapacity":
            return Optional.ofNullable(clazz.cast(availableInstanceCapacity()));
        case "AvailableVCpus":
            return Optional.ofNullable(clazz.cast(availableVCpus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailableCapacity, T> g) {
        return obj -> g.apply((AvailableCapacity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailableCapacity> {
        /**
         * <p>
         * The number of instances that can be launched onto the Dedicated Host depending on the host's available
         * capacity. For Dedicated Hosts that support multiple instance types, this parameter represents the number of
         * instances for each instance size that is supported on the host.
         * </p>
         * 
         * @param availableInstanceCapacity
         *        The number of instances that can be launched onto the Dedicated Host depending on the host's available
         *        capacity. For Dedicated Hosts that support multiple instance types, this parameter represents the
         *        number of instances for each instance size that is supported on the host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableInstanceCapacity(Collection<InstanceCapacity> availableInstanceCapacity);

        /**
         * <p>
         * The number of instances that can be launched onto the Dedicated Host depending on the host's available
         * capacity. For Dedicated Hosts that support multiple instance types, this parameter represents the number of
         * instances for each instance size that is supported on the host.
         * </p>
         * 
         * @param availableInstanceCapacity
         *        The number of instances that can be launched onto the Dedicated Host depending on the host's available
         *        capacity. For Dedicated Hosts that support multiple instance types, this parameter represents the
         *        number of instances for each instance size that is supported on the host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableInstanceCapacity(InstanceCapacity... availableInstanceCapacity);

        /**
         * <p>
         * The number of instances that can be launched onto the Dedicated Host depending on the host's available
         * capacity. For Dedicated Hosts that support multiple instance types, this parameter represents the number of
         * instances for each instance size that is supported on the host.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceCapacity>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceCapacity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceCapacity>.Builder#build()} is called immediately and
         * its result is passed to {@link #availableInstanceCapacity(List<InstanceCapacity>)}.
         * 
         * @param availableInstanceCapacity
         *        a consumer that will call methods on {@link List<InstanceCapacity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availableInstanceCapacity(List<InstanceCapacity>)
         */
        Builder availableInstanceCapacity(Consumer<InstanceCapacity.Builder>... availableInstanceCapacity);

        /**
         * <p>
         * The number of vCPUs available for launching instances onto the Dedicated Host.
         * </p>
         * 
         * @param availableVCpus
         *        The number of vCPUs available for launching instances onto the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableVCpus(Integer availableVCpus);
    }

    static final class BuilderImpl implements Builder {
        private List<InstanceCapacity> availableInstanceCapacity = DefaultSdkAutoConstructList.getInstance();

        private Integer availableVCpus;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailableCapacity model) {
            availableInstanceCapacity(model.availableInstanceCapacity);
            availableVCpus(model.availableVCpus);
        }

        public final List<InstanceCapacity.Builder> getAvailableInstanceCapacity() {
            List<InstanceCapacity.Builder> result = AvailableInstanceCapacityListCopier
                    .copyToBuilder(this.availableInstanceCapacity);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder availableInstanceCapacity(Collection<InstanceCapacity> availableInstanceCapacity) {
            this.availableInstanceCapacity = AvailableInstanceCapacityListCopier.copy(availableInstanceCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableInstanceCapacity(InstanceCapacity... availableInstanceCapacity) {
            availableInstanceCapacity(Arrays.asList(availableInstanceCapacity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableInstanceCapacity(Consumer<InstanceCapacity.Builder>... availableInstanceCapacity) {
            availableInstanceCapacity(Stream.of(availableInstanceCapacity)
                    .map(c -> InstanceCapacity.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAvailableInstanceCapacity(Collection<InstanceCapacity.BuilderImpl> availableInstanceCapacity) {
            this.availableInstanceCapacity = AvailableInstanceCapacityListCopier.copyFromBuilder(availableInstanceCapacity);
        }

        public final Integer getAvailableVCpus() {
            return availableVCpus;
        }

        @Override
        public final Builder availableVCpus(Integer availableVCpus) {
            this.availableVCpus = availableVCpus;
            return this;
        }

        public final void setAvailableVCpus(Integer availableVCpus) {
            this.availableVCpus = availableVCpus;
        }

        @Override
        public AvailableCapacity build() {
            return new AvailableCapacity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
