/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.LocalGatewayRoute;
import software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesResponse;

public class SearchLocalGatewayRoutesPublisher
implements SdkPublisher<SearchLocalGatewayRoutesResponse> {
    private final Ec2AsyncClient client;
    private final SearchLocalGatewayRoutesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchLocalGatewayRoutesPublisher(Ec2AsyncClient client, SearchLocalGatewayRoutesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchLocalGatewayRoutesPublisher(Ec2AsyncClient client, SearchLocalGatewayRoutesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchLocalGatewayRoutesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchLocalGatewayRoutesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LocalGatewayRoute> routes() {
        Function<SearchLocalGatewayRoutesResponse, Iterator> getIterator = response -> {
            if (response != null && response.routes() != null) {
                return response.routes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchLocalGatewayRoutesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchLocalGatewayRoutesResponseFetcher
    implements AsyncPageFetcher<SearchLocalGatewayRoutesResponse> {
        private SearchLocalGatewayRoutesResponseFetcher() {
        }

        public boolean hasNextPage(SearchLocalGatewayRoutesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchLocalGatewayRoutesResponse> nextPage(SearchLocalGatewayRoutesResponse previousPage) {
            if (previousPage == null) {
                return SearchLocalGatewayRoutesPublisher.this.client.searchLocalGatewayRoutes(SearchLocalGatewayRoutesPublisher.this.firstRequest);
            }
            return SearchLocalGatewayRoutesPublisher.this.client.searchLocalGatewayRoutes((SearchLocalGatewayRoutesRequest)((Object)SearchLocalGatewayRoutesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

