/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectsResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayConnect;

public class DescribeTransitGatewayConnectsPublisher
implements SdkPublisher<DescribeTransitGatewayConnectsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeTransitGatewayConnectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTransitGatewayConnectsPublisher(Ec2AsyncClient client, DescribeTransitGatewayConnectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTransitGatewayConnectsPublisher(Ec2AsyncClient client, DescribeTransitGatewayConnectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTransitGatewayConnectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTransitGatewayConnectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransitGatewayConnect> transitGatewayConnects() {
        Function<DescribeTransitGatewayConnectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayConnects() != null) {
                return response.transitGatewayConnects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeTransitGatewayConnectsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeTransitGatewayConnectsResponseFetcher
    implements AsyncPageFetcher<DescribeTransitGatewayConnectsResponse> {
        private DescribeTransitGatewayConnectsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTransitGatewayConnectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeTransitGatewayConnectsResponse> nextPage(DescribeTransitGatewayConnectsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTransitGatewayConnectsPublisher.this.client.describeTransitGatewayConnects(DescribeTransitGatewayConnectsPublisher.this.firstRequest);
            }
            return DescribeTransitGatewayConnectsPublisher.this.client.describeTransitGatewayConnects((DescribeTransitGatewayConnectsRequest)((Object)DescribeTransitGatewayConnectsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

