/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.LocalGateway;

public class DescribeLocalGatewaysPublisher
implements SdkPublisher<DescribeLocalGatewaysResponse> {
    private final Ec2AsyncClient client;
    private final DescribeLocalGatewaysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeLocalGatewaysPublisher(Ec2AsyncClient client, DescribeLocalGatewaysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeLocalGatewaysPublisher(Ec2AsyncClient client, DescribeLocalGatewaysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeLocalGatewaysResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeLocalGatewaysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LocalGateway> localGateways() {
        Function<DescribeLocalGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.localGateways() != null) {
                return response.localGateways().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeLocalGatewaysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeLocalGatewaysResponseFetcher
    implements AsyncPageFetcher<DescribeLocalGatewaysResponse> {
        private DescribeLocalGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLocalGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeLocalGatewaysResponse> nextPage(DescribeLocalGatewaysResponse previousPage) {
            if (previousPage == null) {
                return DescribeLocalGatewaysPublisher.this.client.describeLocalGateways(DescribeLocalGatewaysPublisher.this.firstRequest);
            }
            return DescribeLocalGatewaysPublisher.this.client.describeLocalGateways((DescribeLocalGatewaysRequest)((Object)DescribeLocalGatewaysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

