/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DnsNameState;
import software.amazon.awssdk.services.ec2.model.PrivateDnsDetails;
import software.amazon.awssdk.services.ec2.model.PrivateDnsDetailsSetCopier;
import software.amazon.awssdk.services.ec2.model.ServiceTypeDetail;
import software.amazon.awssdk.services.ec2.model.ServiceTypeDetailSetCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceDetail> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(ServiceDetail.getter(ServiceDetail::serviceName)).setter(ServiceDetail.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").unmarshallLocationName("serviceName").build()}).build();
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceId").getter(ServiceDetail.getter(ServiceDetail::serviceId)).setter(ServiceDetail.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").unmarshallLocationName("serviceId").build()}).build();
    private static final SdkField<List<ServiceTypeDetail>> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceType").getter(ServiceDetail.getter(ServiceDetail::serviceType)).setter(ServiceDetail.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").unmarshallLocationName("serviceType").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceTypeDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(ServiceDetail.getter(ServiceDetail::availabilityZones)).setter(ServiceDetail.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneSet").unmarshallLocationName("availabilityZoneSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(ServiceDetail.getter(ServiceDetail::owner)).setter(ServiceDetail.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").unmarshallLocationName("owner").build()}).build();
    private static final SdkField<List<String>> BASE_ENDPOINT_DNS_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BaseEndpointDnsNames").getter(ServiceDetail.getter(ServiceDetail::baseEndpointDnsNames)).setter(ServiceDetail.setter(Builder::baseEndpointDnsNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpointDnsNameSet").unmarshallLocationName("baseEndpointDnsNameSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateDnsName").getter(ServiceDetail.getter(ServiceDetail::privateDnsName)).setter(ServiceDetail.setter(Builder::privateDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName").unmarshallLocationName("privateDnsName").build()}).build();
    private static final SdkField<List<PrivateDnsDetails>> PRIVATE_DNS_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrivateDnsNames").getter(ServiceDetail.getter(ServiceDetail::privateDnsNames)).setter(ServiceDetail.setter(Builder::privateDnsNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsNameSet").unmarshallLocationName("privateDnsNameSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrivateDnsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> VPC_ENDPOINT_POLICY_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("VpcEndpointPolicySupported").getter(ServiceDetail.getter(ServiceDetail::vpcEndpointPolicySupported)).setter(ServiceDetail.setter(Builder::vpcEndpointPolicySupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointPolicySupported").unmarshallLocationName("vpcEndpointPolicySupported").build()}).build();
    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AcceptanceRequired").getter(ServiceDetail.getter(ServiceDetail::acceptanceRequired)).setter(ServiceDetail.setter(Builder::acceptanceRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired").unmarshallLocationName("acceptanceRequired").build()}).build();
    private static final SdkField<Boolean> MANAGES_VPC_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ManagesVpcEndpoints").getter(ServiceDetail.getter(ServiceDetail::managesVpcEndpoints)).setter(ServiceDetail.setter(Builder::managesVpcEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagesVpcEndpoints").unmarshallLocationName("managesVpcEndpoints").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ServiceDetail.getter(ServiceDetail::tags)).setter(ServiceDetail.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> PRIVATE_DNS_NAME_VERIFICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateDnsNameVerificationState").getter(ServiceDetail.getter(ServiceDetail::privateDnsNameVerificationStateAsString)).setter(ServiceDetail.setter(Builder::privateDnsNameVerificationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsNameVerificationState").unmarshallLocationName("privateDnsNameVerificationState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD, SERVICE_ID_FIELD, SERVICE_TYPE_FIELD, AVAILABILITY_ZONES_FIELD, OWNER_FIELD, BASE_ENDPOINT_DNS_NAMES_FIELD, PRIVATE_DNS_NAME_FIELD, PRIVATE_DNS_NAMES_FIELD, VPC_ENDPOINT_POLICY_SUPPORTED_FIELD, ACCEPTANCE_REQUIRED_FIELD, MANAGES_VPC_ENDPOINTS_FIELD, TAGS_FIELD, PRIVATE_DNS_NAME_VERIFICATION_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceName;
    private final String serviceId;
    private final List<ServiceTypeDetail> serviceType;
    private final List<String> availabilityZones;
    private final String owner;
    private final List<String> baseEndpointDnsNames;
    private final String privateDnsName;
    private final List<PrivateDnsDetails> privateDnsNames;
    private final Boolean vpcEndpointPolicySupported;
    private final Boolean acceptanceRequired;
    private final Boolean managesVpcEndpoints;
    private final List<Tag> tags;
    private final String privateDnsNameVerificationState;

    private ServiceDetail(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.serviceId = builder.serviceId;
        this.serviceType = builder.serviceType;
        this.availabilityZones = builder.availabilityZones;
        this.owner = builder.owner;
        this.baseEndpointDnsNames = builder.baseEndpointDnsNames;
        this.privateDnsName = builder.privateDnsName;
        this.privateDnsNames = builder.privateDnsNames;
        this.vpcEndpointPolicySupported = builder.vpcEndpointPolicySupported;
        this.acceptanceRequired = builder.acceptanceRequired;
        this.managesVpcEndpoints = builder.managesVpcEndpoints;
        this.tags = builder.tags;
        this.privateDnsNameVerificationState = builder.privateDnsNameVerificationState;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String serviceId() {
        return this.serviceId;
    }

    public final boolean hasServiceType() {
        return this.serviceType != null && !(this.serviceType instanceof SdkAutoConstructList);
    }

    public final List<ServiceTypeDetail> serviceType() {
        return this.serviceType;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final String owner() {
        return this.owner;
    }

    public final boolean hasBaseEndpointDnsNames() {
        return this.baseEndpointDnsNames != null && !(this.baseEndpointDnsNames instanceof SdkAutoConstructList);
    }

    public final List<String> baseEndpointDnsNames() {
        return this.baseEndpointDnsNames;
    }

    public final String privateDnsName() {
        return this.privateDnsName;
    }

    public final boolean hasPrivateDnsNames() {
        return this.privateDnsNames != null && !(this.privateDnsNames instanceof SdkAutoConstructList);
    }

    public final List<PrivateDnsDetails> privateDnsNames() {
        return this.privateDnsNames;
    }

    public final Boolean vpcEndpointPolicySupported() {
        return this.vpcEndpointPolicySupported;
    }

    public final Boolean acceptanceRequired() {
        return this.acceptanceRequired;
    }

    public final Boolean managesVpcEndpoints() {
        return this.managesVpcEndpoints;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final DnsNameState privateDnsNameVerificationState() {
        return DnsNameState.fromValue(this.privateDnsNameVerificationState);
    }

    public final String privateDnsNameVerificationStateAsString() {
        return this.privateDnsNameVerificationState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceType() ? this.serviceType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBaseEndpointDnsNames() ? this.baseEndpointDnsNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivateDnsNames() ? this.privateDnsNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointPolicySupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.managesVpcEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsNameVerificationStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDetail)) {
            return false;
        }
        ServiceDetail other = (ServiceDetail)obj;
        return Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceId(), other.serviceId()) && this.hasServiceType() == other.hasServiceType() && Objects.equals(this.serviceType(), other.serviceType()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.owner(), other.owner()) && this.hasBaseEndpointDnsNames() == other.hasBaseEndpointDnsNames() && Objects.equals(this.baseEndpointDnsNames(), other.baseEndpointDnsNames()) && Objects.equals(this.privateDnsName(), other.privateDnsName()) && this.hasPrivateDnsNames() == other.hasPrivateDnsNames() && Objects.equals(this.privateDnsNames(), other.privateDnsNames()) && Objects.equals(this.vpcEndpointPolicySupported(), other.vpcEndpointPolicySupported()) && Objects.equals(this.acceptanceRequired(), other.acceptanceRequired()) && Objects.equals(this.managesVpcEndpoints(), other.managesVpcEndpoints()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.privateDnsNameVerificationStateAsString(), other.privateDnsNameVerificationStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceDetail").add("ServiceName", (Object)this.serviceName()).add("ServiceId", (Object)this.serviceId()).add("ServiceType", this.hasServiceType() ? this.serviceType() : null).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("Owner", (Object)this.owner()).add("BaseEndpointDnsNames", this.hasBaseEndpointDnsNames() ? this.baseEndpointDnsNames() : null).add("PrivateDnsName", (Object)this.privateDnsName()).add("PrivateDnsNames", this.hasPrivateDnsNames() ? this.privateDnsNames() : null).add("VpcEndpointPolicySupported", (Object)this.vpcEndpointPolicySupported()).add("AcceptanceRequired", (Object)this.acceptanceRequired()).add("ManagesVpcEndpoints", (Object)this.managesVpcEndpoints()).add("Tags", this.hasTags() ? this.tags() : null).add("PrivateDnsNameVerificationState", (Object)this.privateDnsNameVerificationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "ServiceType": {
                return Optional.ofNullable(clazz.cast(this.serviceType()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "BaseEndpointDnsNames": {
                return Optional.ofNullable(clazz.cast(this.baseEndpointDnsNames()));
            }
            case "PrivateDnsName": {
                return Optional.ofNullable(clazz.cast(this.privateDnsName()));
            }
            case "PrivateDnsNames": {
                return Optional.ofNullable(clazz.cast(this.privateDnsNames()));
            }
            case "VpcEndpointPolicySupported": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointPolicySupported()));
            }
            case "AcceptanceRequired": {
                return Optional.ofNullable(clazz.cast(this.acceptanceRequired()));
            }
            case "ManagesVpcEndpoints": {
                return Optional.ofNullable(clazz.cast(this.managesVpcEndpoints()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "PrivateDnsNameVerificationState": {
                return Optional.ofNullable(clazz.cast(this.privateDnsNameVerificationStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceDetail, T> g) {
        return obj -> g.apply((ServiceDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceName;
        private String serviceId;
        private List<ServiceTypeDetail> serviceType = DefaultSdkAutoConstructList.getInstance();
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private String owner;
        private List<String> baseEndpointDnsNames = DefaultSdkAutoConstructList.getInstance();
        private String privateDnsName;
        private List<PrivateDnsDetails> privateDnsNames = DefaultSdkAutoConstructList.getInstance();
        private Boolean vpcEndpointPolicySupported;
        private Boolean acceptanceRequired;
        private Boolean managesVpcEndpoints;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String privateDnsNameVerificationState;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceDetail model) {
            this.serviceName(model.serviceName);
            this.serviceId(model.serviceId);
            this.serviceType(model.serviceType);
            this.availabilityZones(model.availabilityZones);
            this.owner(model.owner);
            this.baseEndpointDnsNames(model.baseEndpointDnsNames);
            this.privateDnsName(model.privateDnsName);
            this.privateDnsNames(model.privateDnsNames);
            this.vpcEndpointPolicySupported(model.vpcEndpointPolicySupported);
            this.acceptanceRequired(model.acceptanceRequired);
            this.managesVpcEndpoints(model.managesVpcEndpoints);
            this.tags(model.tags);
            this.privateDnsNameVerificationState(model.privateDnsNameVerificationState);
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final List<ServiceTypeDetail.Builder> getServiceType() {
            List<ServiceTypeDetail.Builder> result = ServiceTypeDetailSetCopier.copyToBuilder(this.serviceType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder serviceType(Collection<ServiceTypeDetail> serviceType) {
            this.serviceType = ServiceTypeDetailSetCopier.copy(serviceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceType(ServiceTypeDetail ... serviceType) {
            this.serviceType(Arrays.asList(serviceType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceType(Consumer<ServiceTypeDetail.Builder> ... serviceType) {
            this.serviceType(Stream.of(serviceType).map(c -> (ServiceTypeDetail)((ServiceTypeDetail.Builder)ServiceTypeDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceType(Collection<ServiceTypeDetail.BuilderImpl> serviceType) {
            this.serviceType = ServiceTypeDetailSetCopier.copyFromBuilder(serviceType);
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Collection<String> getBaseEndpointDnsNames() {
            if (this.baseEndpointDnsNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.baseEndpointDnsNames;
        }

        @Override
        public final Builder baseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = ValueStringListCopier.copy(baseEndpointDnsNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseEndpointDnsNames(String ... baseEndpointDnsNames) {
            this.baseEndpointDnsNames(Arrays.asList(baseEndpointDnsNames));
            return this;
        }

        public final void setBaseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = ValueStringListCopier.copy(baseEndpointDnsNames);
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final List<PrivateDnsDetails.Builder> getPrivateDnsNames() {
            List<PrivateDnsDetails.Builder> result = PrivateDnsDetailsSetCopier.copyToBuilder(this.privateDnsNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder privateDnsNames(Collection<PrivateDnsDetails> privateDnsNames) {
            this.privateDnsNames = PrivateDnsDetailsSetCopier.copy(privateDnsNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateDnsNames(PrivateDnsDetails ... privateDnsNames) {
            this.privateDnsNames(Arrays.asList(privateDnsNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateDnsNames(Consumer<PrivateDnsDetails.Builder> ... privateDnsNames) {
            this.privateDnsNames(Stream.of(privateDnsNames).map(c -> (PrivateDnsDetails)((PrivateDnsDetails.Builder)PrivateDnsDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrivateDnsNames(Collection<PrivateDnsDetails.BuilderImpl> privateDnsNames) {
            this.privateDnsNames = PrivateDnsDetailsSetCopier.copyFromBuilder(privateDnsNames);
        }

        public final Boolean getVpcEndpointPolicySupported() {
            return this.vpcEndpointPolicySupported;
        }

        @Override
        public final Builder vpcEndpointPolicySupported(Boolean vpcEndpointPolicySupported) {
            this.vpcEndpointPolicySupported = vpcEndpointPolicySupported;
            return this;
        }

        public final void setVpcEndpointPolicySupported(Boolean vpcEndpointPolicySupported) {
            this.vpcEndpointPolicySupported = vpcEndpointPolicySupported;
        }

        public final Boolean getAcceptanceRequired() {
            return this.acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        public final Boolean getManagesVpcEndpoints() {
            return this.managesVpcEndpoints;
        }

        @Override
        public final Builder managesVpcEndpoints(Boolean managesVpcEndpoints) {
            this.managesVpcEndpoints = managesVpcEndpoints;
            return this;
        }

        public final void setManagesVpcEndpoints(Boolean managesVpcEndpoints) {
            this.managesVpcEndpoints = managesVpcEndpoints;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getPrivateDnsNameVerificationState() {
            return this.privateDnsNameVerificationState;
        }

        @Override
        public final Builder privateDnsNameVerificationState(String privateDnsNameVerificationState) {
            this.privateDnsNameVerificationState = privateDnsNameVerificationState;
            return this;
        }

        @Override
        public final Builder privateDnsNameVerificationState(DnsNameState privateDnsNameVerificationState) {
            this.privateDnsNameVerificationState(privateDnsNameVerificationState == null ? null : privateDnsNameVerificationState.toString());
            return this;
        }

        public final void setPrivateDnsNameVerificationState(String privateDnsNameVerificationState) {
            this.privateDnsNameVerificationState = privateDnsNameVerificationState;
        }

        public ServiceDetail build() {
            return new ServiceDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceDetail> {
        public Builder serviceName(String var1);

        public Builder serviceId(String var1);

        public Builder serviceType(Collection<ServiceTypeDetail> var1);

        public Builder serviceType(ServiceTypeDetail ... var1);

        public Builder serviceType(Consumer<ServiceTypeDetail.Builder> ... var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder owner(String var1);

        public Builder baseEndpointDnsNames(Collection<String> var1);

        public Builder baseEndpointDnsNames(String ... var1);

        public Builder privateDnsName(String var1);

        public Builder privateDnsNames(Collection<PrivateDnsDetails> var1);

        public Builder privateDnsNames(PrivateDnsDetails ... var1);

        public Builder privateDnsNames(Consumer<PrivateDnsDetails.Builder> ... var1);

        public Builder vpcEndpointPolicySupported(Boolean var1);

        public Builder acceptanceRequired(Boolean var1);

        public Builder managesVpcEndpoints(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder privateDnsNameVerificationState(String var1);

        public Builder privateDnsNameVerificationState(DnsNameState var1);
    }
}

