/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReference;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTransitGatewayPrefixListReferencesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetTransitGatewayPrefixListReferencesResponse> {
    private static final SdkField<List<TransitGatewayPrefixListReference>> TRANSIT_GATEWAY_PREFIX_LIST_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGatewayPrefixListReferences").getter(GetTransitGatewayPrefixListReferencesResponse.getter(GetTransitGatewayPrefixListReferencesResponse::transitGatewayPrefixListReferences)).setter(GetTransitGatewayPrefixListReferencesResponse.setter(Builder::transitGatewayPrefixListReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayPrefixListReferenceSet").unmarshallLocationName("transitGatewayPrefixListReferenceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayPrefixListReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTransitGatewayPrefixListReferencesResponse.getter(GetTransitGatewayPrefixListReferencesResponse::nextToken)).setter(GetTransitGatewayPrefixListReferencesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_PREFIX_LIST_REFERENCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<TransitGatewayPrefixListReference> transitGatewayPrefixListReferences;
    private final String nextToken;

    private GetTransitGatewayPrefixListReferencesResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayPrefixListReferences = builder.transitGatewayPrefixListReferences;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTransitGatewayPrefixListReferences() {
        return this.transitGatewayPrefixListReferences != null && !(this.transitGatewayPrefixListReferences instanceof SdkAutoConstructList);
    }

    public final List<TransitGatewayPrefixListReference> transitGatewayPrefixListReferences() {
        return this.transitGatewayPrefixListReferences;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitGatewayPrefixListReferences() ? this.transitGatewayPrefixListReferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransitGatewayPrefixListReferencesResponse)) {
            return false;
        }
        GetTransitGatewayPrefixListReferencesResponse other = (GetTransitGatewayPrefixListReferencesResponse)((Object)obj);
        return this.hasTransitGatewayPrefixListReferences() == other.hasTransitGatewayPrefixListReferences() && Objects.equals(this.transitGatewayPrefixListReferences(), other.transitGatewayPrefixListReferences()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetTransitGatewayPrefixListReferencesResponse").add("TransitGatewayPrefixListReferences", this.hasTransitGatewayPrefixListReferences() ? this.transitGatewayPrefixListReferences() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayPrefixListReferences": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayPrefixListReferences()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTransitGatewayPrefixListReferencesResponse, T> g) {
        return obj -> g.apply((GetTransitGatewayPrefixListReferencesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayPrefixListReference> transitGatewayPrefixListReferences = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransitGatewayPrefixListReferencesResponse model) {
            super(model);
            this.transitGatewayPrefixListReferences(model.transitGatewayPrefixListReferences);
            this.nextToken(model.nextToken);
        }

        public final List<TransitGatewayPrefixListReference.Builder> getTransitGatewayPrefixListReferences() {
            List<TransitGatewayPrefixListReference.Builder> result = TransitGatewayPrefixListReferenceSetCopier.copyToBuilder(this.transitGatewayPrefixListReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder transitGatewayPrefixListReferences(Collection<TransitGatewayPrefixListReference> transitGatewayPrefixListReferences) {
            this.transitGatewayPrefixListReferences = TransitGatewayPrefixListReferenceSetCopier.copy(transitGatewayPrefixListReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayPrefixListReferences(TransitGatewayPrefixListReference ... transitGatewayPrefixListReferences) {
            this.transitGatewayPrefixListReferences(Arrays.asList(transitGatewayPrefixListReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayPrefixListReferences(Consumer<TransitGatewayPrefixListReference.Builder> ... transitGatewayPrefixListReferences) {
            this.transitGatewayPrefixListReferences(Stream.of(transitGatewayPrefixListReferences).map(c -> (TransitGatewayPrefixListReference)((TransitGatewayPrefixListReference.Builder)TransitGatewayPrefixListReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTransitGatewayPrefixListReferences(Collection<TransitGatewayPrefixListReference.BuilderImpl> transitGatewayPrefixListReferences) {
            this.transitGatewayPrefixListReferences = TransitGatewayPrefixListReferenceSetCopier.copyFromBuilder(transitGatewayPrefixListReferences);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetTransitGatewayPrefixListReferencesResponse build() {
            return new GetTransitGatewayPrefixListReferencesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTransitGatewayPrefixListReferencesResponse> {
        public Builder transitGatewayPrefixListReferences(Collection<TransitGatewayPrefixListReference> var1);

        public Builder transitGatewayPrefixListReferences(TransitGatewayPrefixListReference ... var1);

        public Builder transitGatewayPrefixListReferences(Consumer<TransitGatewayPrefixListReference.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

