/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ConnectionNotification;
import software.amazon.awssdk.services.ec2.model.ConnectionNotificationSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcEndpointConnectionNotificationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcEndpointConnectionNotificationsResponse> {
    private static final SdkField<List<ConnectionNotification>> CONNECTION_NOTIFICATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectionNotificationSet").getter(DescribeVpcEndpointConnectionNotificationsResponse.getter(DescribeVpcEndpointConnectionNotificationsResponse::connectionNotificationSet)).setter(DescribeVpcEndpointConnectionNotificationsResponse.setter(Builder::connectionNotificationSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationSet").unmarshallLocationName("connectionNotificationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectionNotification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeVpcEndpointConnectionNotificationsResponse.getter(DescribeVpcEndpointConnectionNotificationsResponse::nextToken)).setter(DescribeVpcEndpointConnectionNotificationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NOTIFICATION_SET_FIELD, NEXT_TOKEN_FIELD));
    private final List<ConnectionNotification> connectionNotificationSet;
    private final String nextToken;

    private DescribeVpcEndpointConnectionNotificationsResponse(BuilderImpl builder) {
        super(builder);
        this.connectionNotificationSet = builder.connectionNotificationSet;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConnectionNotificationSet() {
        return this.connectionNotificationSet != null && !(this.connectionNotificationSet instanceof SdkAutoConstructList);
    }

    public final List<ConnectionNotification> connectionNotificationSet() {
        return this.connectionNotificationSet;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionNotificationSet() ? this.connectionNotificationSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointConnectionNotificationsResponse)) {
            return false;
        }
        DescribeVpcEndpointConnectionNotificationsResponse other = (DescribeVpcEndpointConnectionNotificationsResponse)((Object)obj);
        return this.hasConnectionNotificationSet() == other.hasConnectionNotificationSet() && Objects.equals(this.connectionNotificationSet(), other.connectionNotificationSet()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpcEndpointConnectionNotificationsResponse").add("ConnectionNotificationSet", this.hasConnectionNotificationSet() ? this.connectionNotificationSet() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionNotificationSet": {
                return Optional.ofNullable(clazz.cast(this.connectionNotificationSet()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcEndpointConnectionNotificationsResponse, T> g) {
        return obj -> g.apply((DescribeVpcEndpointConnectionNotificationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ConnectionNotification> connectionNotificationSet = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointConnectionNotificationsResponse model) {
            super(model);
            this.connectionNotificationSet(model.connectionNotificationSet);
            this.nextToken(model.nextToken);
        }

        public final List<ConnectionNotification.Builder> getConnectionNotificationSet() {
            List<ConnectionNotification.Builder> result = ConnectionNotificationSetCopier.copyToBuilder(this.connectionNotificationSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder connectionNotificationSet(Collection<ConnectionNotification> connectionNotificationSet) {
            this.connectionNotificationSet = ConnectionNotificationSetCopier.copy(connectionNotificationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionNotificationSet(ConnectionNotification ... connectionNotificationSet) {
            this.connectionNotificationSet(Arrays.asList(connectionNotificationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionNotificationSet(Consumer<ConnectionNotification.Builder> ... connectionNotificationSet) {
            this.connectionNotificationSet(Stream.of(connectionNotificationSet).map(c -> (ConnectionNotification)((ConnectionNotification.Builder)ConnectionNotification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConnectionNotificationSet(Collection<ConnectionNotification.BuilderImpl> connectionNotificationSet) {
            this.connectionNotificationSet = ConnectionNotificationSetCopier.copyFromBuilder(connectionNotificationSet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVpcEndpointConnectionNotificationsResponse build() {
            return new DescribeVpcEndpointConnectionNotificationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpcEndpointConnectionNotificationsResponse> {
        public Builder connectionNotificationSet(Collection<ConnectionNotification> var1);

        public Builder connectionNotificationSet(ConnectionNotification ... var1);

        public Builder connectionNotificationSet(Consumer<ConnectionNotification.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

