/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrafficMirrorFilterResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateTrafficMirrorFilterResponse> {
    private static final SdkField<TrafficMirrorFilter> TRAFFIC_MIRROR_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrafficMirrorFilter").getter(CreateTrafficMirrorFilterResponse.getter(CreateTrafficMirrorFilterResponse::trafficMirrorFilter)).setter(CreateTrafficMirrorFilterResponse.setter(Builder::trafficMirrorFilter)).constructor(TrafficMirrorFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilter").unmarshallLocationName("trafficMirrorFilter").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateTrafficMirrorFilterResponse.getter(CreateTrafficMirrorFilterResponse::clientToken)).setter(CreateTrafficMirrorFilterResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_FILTER_FIELD, CLIENT_TOKEN_FIELD));
    private final TrafficMirrorFilter trafficMirrorFilter;
    private final String clientToken;

    private CreateTrafficMirrorFilterResponse(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorFilter = builder.trafficMirrorFilter;
        this.clientToken = builder.clientToken;
    }

    public final TrafficMirrorFilter trafficMirrorFilter() {
        return this.trafficMirrorFilter;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficMirrorFilterResponse)) {
            return false;
        }
        CreateTrafficMirrorFilterResponse other = (CreateTrafficMirrorFilterResponse)((Object)obj);
        return Objects.equals(this.trafficMirrorFilter(), other.trafficMirrorFilter()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTrafficMirrorFilterResponse").add("TrafficMirrorFilter", (Object)this.trafficMirrorFilter()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficMirrorFilter": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorFilter()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficMirrorFilterResponse, T> g) {
        return obj -> g.apply((CreateTrafficMirrorFilterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private TrafficMirrorFilter trafficMirrorFilter;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficMirrorFilterResponse model) {
            super(model);
            this.trafficMirrorFilter(model.trafficMirrorFilter);
            this.clientToken(model.clientToken);
        }

        public final TrafficMirrorFilter.Builder getTrafficMirrorFilter() {
            return this.trafficMirrorFilter != null ? this.trafficMirrorFilter.toBuilder() : null;
        }

        @Override
        public final Builder trafficMirrorFilter(TrafficMirrorFilter trafficMirrorFilter) {
            this.trafficMirrorFilter = trafficMirrorFilter;
            return this;
        }

        public final void setTrafficMirrorFilter(TrafficMirrorFilter.BuilderImpl trafficMirrorFilter) {
            this.trafficMirrorFilter = trafficMirrorFilter != null ? trafficMirrorFilter.build() : null;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public CreateTrafficMirrorFilterResponse build() {
            return new CreateTrafficMirrorFilterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrafficMirrorFilterResponse> {
        public Builder trafficMirrorFilter(TrafficMirrorFilter var1);

        default public Builder trafficMirrorFilter(Consumer<TrafficMirrorFilter.Builder> trafficMirrorFilter) {
            return this.trafficMirrorFilter((TrafficMirrorFilter)((TrafficMirrorFilter.Builder)TrafficMirrorFilter.builder().applyMutation(trafficMirrorFilter)).build());
        }

        public Builder clientToken(String var1);
    }
}

