/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SubnetIpv6CidrBlockAssociation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateSubnetCidrBlockResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, AssociateSubnetCidrBlockResponse> {
    private static final SdkField<SubnetIpv6CidrBlockAssociation> IPV6_CIDR_BLOCK_ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ipv6CidrBlockAssociation").getter(AssociateSubnetCidrBlockResponse.getter(AssociateSubnetCidrBlockResponse::ipv6CidrBlockAssociation)).setter(AssociateSubnetCidrBlockResponse.setter(Builder::ipv6CidrBlockAssociation)).constructor(SubnetIpv6CidrBlockAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockAssociation").unmarshallLocationName("ipv6CidrBlockAssociation").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(AssociateSubnetCidrBlockResponse.getter(AssociateSubnetCidrBlockResponse::subnetId)).setter(AssociateSubnetCidrBlockResponse.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_CIDR_BLOCK_ASSOCIATION_FIELD, SUBNET_ID_FIELD));
    private final SubnetIpv6CidrBlockAssociation ipv6CidrBlockAssociation;
    private final String subnetId;

    private AssociateSubnetCidrBlockResponse(BuilderImpl builder) {
        super(builder);
        this.ipv6CidrBlockAssociation = builder.ipv6CidrBlockAssociation;
        this.subnetId = builder.subnetId;
    }

    public final SubnetIpv6CidrBlockAssociation ipv6CidrBlockAssociation() {
        return this.ipv6CidrBlockAssociation;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlockAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSubnetCidrBlockResponse)) {
            return false;
        }
        AssociateSubnetCidrBlockResponse other = (AssociateSubnetCidrBlockResponse)((Object)obj);
        return Objects.equals(this.ipv6CidrBlockAssociation(), other.ipv6CidrBlockAssociation()) && Objects.equals(this.subnetId(), other.subnetId());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateSubnetCidrBlockResponse").add("Ipv6CidrBlockAssociation", (Object)this.ipv6CidrBlockAssociation()).add("SubnetId", (Object)this.subnetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ipv6CidrBlockAssociation": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlockAssociation()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateSubnetCidrBlockResponse, T> g) {
        return obj -> g.apply((AssociateSubnetCidrBlockResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private SubnetIpv6CidrBlockAssociation ipv6CidrBlockAssociation;
        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSubnetCidrBlockResponse model) {
            super(model);
            this.ipv6CidrBlockAssociation(model.ipv6CidrBlockAssociation);
            this.subnetId(model.subnetId);
        }

        public final SubnetIpv6CidrBlockAssociation.Builder getIpv6CidrBlockAssociation() {
            return this.ipv6CidrBlockAssociation != null ? this.ipv6CidrBlockAssociation.toBuilder() : null;
        }

        @Override
        public final Builder ipv6CidrBlockAssociation(SubnetIpv6CidrBlockAssociation ipv6CidrBlockAssociation) {
            this.ipv6CidrBlockAssociation = ipv6CidrBlockAssociation;
            return this;
        }

        public final void setIpv6CidrBlockAssociation(SubnetIpv6CidrBlockAssociation.BuilderImpl ipv6CidrBlockAssociation) {
            this.ipv6CidrBlockAssociation = ipv6CidrBlockAssociation != null ? ipv6CidrBlockAssociation.build() : null;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public AssociateSubnetCidrBlockResponse build() {
            return new AssociateSubnetCidrBlockResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateSubnetCidrBlockResponse> {
        public Builder ipv6CidrBlockAssociation(SubnetIpv6CidrBlockAssociation var1);

        default public Builder ipv6CidrBlockAssociation(Consumer<SubnetIpv6CidrBlockAssociation.Builder> ipv6CidrBlockAssociation) {
            return this.ipv6CidrBlockAssociation((SubnetIpv6CidrBlockAssociation)((SubnetIpv6CidrBlockAssociation.Builder)SubnetIpv6CidrBlockAssociation.builder().applyMutation(ipv6CidrBlockAssociation)).build());
        }

        public Builder subnetId(String var1);
    }
}

