/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes VPN connection options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpnConnectionOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<VpnConnectionOptions.Builder, VpnConnectionOptions> {
    private static final SdkField<Boolean> ENABLE_ACCELERATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableAcceleration")
            .getter(getter(VpnConnectionOptions::enableAcceleration))
            .setter(setter(Builder::enableAcceleration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableAcceleration")
                    .unmarshallLocationName("enableAcceleration").build()).build();

    private static final SdkField<Boolean> STATIC_ROUTES_ONLY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StaticRoutesOnly")
            .getter(getter(VpnConnectionOptions::staticRoutesOnly))
            .setter(setter(Builder::staticRoutesOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticRoutesOnly")
                    .unmarshallLocationName("staticRoutesOnly").build()).build();

    private static final SdkField<String> LOCAL_IPV4_NETWORK_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalIpv4NetworkCidr")
            .getter(getter(VpnConnectionOptions::localIpv4NetworkCidr))
            .setter(setter(Builder::localIpv4NetworkCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalIpv4NetworkCidr")
                    .unmarshallLocationName("localIpv4NetworkCidr").build()).build();

    private static final SdkField<String> REMOTE_IPV4_NETWORK_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RemoteIpv4NetworkCidr")
            .getter(getter(VpnConnectionOptions::remoteIpv4NetworkCidr))
            .setter(setter(Builder::remoteIpv4NetworkCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteIpv4NetworkCidr")
                    .unmarshallLocationName("remoteIpv4NetworkCidr").build()).build();

    private static final SdkField<String> LOCAL_IPV6_NETWORK_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalIpv6NetworkCidr")
            .getter(getter(VpnConnectionOptions::localIpv6NetworkCidr))
            .setter(setter(Builder::localIpv6NetworkCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalIpv6NetworkCidr")
                    .unmarshallLocationName("localIpv6NetworkCidr").build()).build();

    private static final SdkField<String> REMOTE_IPV6_NETWORK_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RemoteIpv6NetworkCidr")
            .getter(getter(VpnConnectionOptions::remoteIpv6NetworkCidr))
            .setter(setter(Builder::remoteIpv6NetworkCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteIpv6NetworkCidr")
                    .unmarshallLocationName("remoteIpv6NetworkCidr").build()).build();

    private static final SdkField<String> TUNNEL_INSIDE_IP_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TunnelInsideIpVersion")
            .getter(getter(VpnConnectionOptions::tunnelInsideIpVersionAsString))
            .setter(setter(Builder::tunnelInsideIpVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelInsideIpVersion")
                    .unmarshallLocationName("tunnelInsideIpVersion").build()).build();

    private static final SdkField<List<TunnelOption>> TUNNEL_OPTIONS_FIELD = SdkField
            .<List<TunnelOption>> builder(MarshallingType.LIST)
            .memberName("TunnelOptions")
            .getter(getter(VpnConnectionOptions::tunnelOptions))
            .setter(setter(Builder::tunnelOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelOptionSet")
                    .unmarshallLocationName("tunnelOptionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TunnelOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(TunnelOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_ACCELERATION_FIELD,
            STATIC_ROUTES_ONLY_FIELD, LOCAL_IPV4_NETWORK_CIDR_FIELD, REMOTE_IPV4_NETWORK_CIDR_FIELD,
            LOCAL_IPV6_NETWORK_CIDR_FIELD, REMOTE_IPV6_NETWORK_CIDR_FIELD, TUNNEL_INSIDE_IP_VERSION_FIELD, TUNNEL_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enableAcceleration;

    private final Boolean staticRoutesOnly;

    private final String localIpv4NetworkCidr;

    private final String remoteIpv4NetworkCidr;

    private final String localIpv6NetworkCidr;

    private final String remoteIpv6NetworkCidr;

    private final String tunnelInsideIpVersion;

    private final List<TunnelOption> tunnelOptions;

    private VpnConnectionOptions(BuilderImpl builder) {
        this.enableAcceleration = builder.enableAcceleration;
        this.staticRoutesOnly = builder.staticRoutesOnly;
        this.localIpv4NetworkCidr = builder.localIpv4NetworkCidr;
        this.remoteIpv4NetworkCidr = builder.remoteIpv4NetworkCidr;
        this.localIpv6NetworkCidr = builder.localIpv6NetworkCidr;
        this.remoteIpv6NetworkCidr = builder.remoteIpv6NetworkCidr;
        this.tunnelInsideIpVersion = builder.tunnelInsideIpVersion;
        this.tunnelOptions = builder.tunnelOptions;
    }

    /**
     * <p>
     * Indicates whether acceleration is enabled for the VPN connection.
     * </p>
     * 
     * @return Indicates whether acceleration is enabled for the VPN connection.
     */
    public final Boolean enableAcceleration() {
        return enableAcceleration;
    }

    /**
     * <p>
     * Indicates whether the VPN connection uses static routes only. Static routes must be used for devices that don't
     * support BGP.
     * </p>
     * 
     * @return Indicates whether the VPN connection uses static routes only. Static routes must be used for devices that
     *         don't support BGP.
     */
    public final Boolean staticRoutesOnly() {
        return staticRoutesOnly;
    }

    /**
     * <p>
     * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * </p>
     * 
     * @return The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
     */
    public final String localIpv4NetworkCidr() {
        return localIpv4NetworkCidr;
    }

    /**
     * <p>
     * The IPv4 CIDR on the AWS side of the VPN connection.
     * </p>
     * 
     * @return The IPv4 CIDR on the AWS side of the VPN connection.
     */
    public final String remoteIpv4NetworkCidr() {
        return remoteIpv4NetworkCidr;
    }

    /**
     * <p>
     * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * </p>
     * 
     * @return The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     */
    public final String localIpv6NetworkCidr() {
        return localIpv6NetworkCidr;
    }

    /**
     * <p>
     * The IPv6 CIDR on the AWS side of the VPN connection.
     * </p>
     * 
     * @return The IPv6 CIDR on the AWS side of the VPN connection.
     */
    public final String remoteIpv6NetworkCidr() {
        return remoteIpv6NetworkCidr;
    }

    /**
     * <p>
     * Indicates whether the VPN tunnels process IPv4 or IPv6 traffic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tunnelInsideIpVersion} will return {@link TunnelInsideIpVersion#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #tunnelInsideIpVersionAsString}.
     * </p>
     * 
     * @return Indicates whether the VPN tunnels process IPv4 or IPv6 traffic.
     * @see TunnelInsideIpVersion
     */
    public final TunnelInsideIpVersion tunnelInsideIpVersion() {
        return TunnelInsideIpVersion.fromValue(tunnelInsideIpVersion);
    }

    /**
     * <p>
     * Indicates whether the VPN tunnels process IPv4 or IPv6 traffic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tunnelInsideIpVersion} will return {@link TunnelInsideIpVersion#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #tunnelInsideIpVersionAsString}.
     * </p>
     * 
     * @return Indicates whether the VPN tunnels process IPv4 or IPv6 traffic.
     * @see TunnelInsideIpVersion
     */
    public final String tunnelInsideIpVersionAsString() {
        return tunnelInsideIpVersion;
    }

    /**
     * Returns true if the TunnelOptions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTunnelOptions() {
        return tunnelOptions != null && !(tunnelOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the VPN tunnel options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTunnelOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Indicates the VPN tunnel options.
     */
    public final List<TunnelOption> tunnelOptions() {
        return tunnelOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableAcceleration());
        hashCode = 31 * hashCode + Objects.hashCode(staticRoutesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(localIpv4NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(remoteIpv4NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(localIpv6NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(remoteIpv6NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(tunnelInsideIpVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTunnelOptions() ? tunnelOptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnConnectionOptions)) {
            return false;
        }
        VpnConnectionOptions other = (VpnConnectionOptions) obj;
        return Objects.equals(enableAcceleration(), other.enableAcceleration())
                && Objects.equals(staticRoutesOnly(), other.staticRoutesOnly())
                && Objects.equals(localIpv4NetworkCidr(), other.localIpv4NetworkCidr())
                && Objects.equals(remoteIpv4NetworkCidr(), other.remoteIpv4NetworkCidr())
                && Objects.equals(localIpv6NetworkCidr(), other.localIpv6NetworkCidr())
                && Objects.equals(remoteIpv6NetworkCidr(), other.remoteIpv6NetworkCidr())
                && Objects.equals(tunnelInsideIpVersionAsString(), other.tunnelInsideIpVersionAsString())
                && hasTunnelOptions() == other.hasTunnelOptions() && Objects.equals(tunnelOptions(), other.tunnelOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpnConnectionOptions").add("EnableAcceleration", enableAcceleration())
                .add("StaticRoutesOnly", staticRoutesOnly()).add("LocalIpv4NetworkCidr", localIpv4NetworkCidr())
                .add("RemoteIpv4NetworkCidr", remoteIpv4NetworkCidr()).add("LocalIpv6NetworkCidr", localIpv6NetworkCidr())
                .add("RemoteIpv6NetworkCidr", remoteIpv6NetworkCidr())
                .add("TunnelInsideIpVersion", tunnelInsideIpVersionAsString())
                .add("TunnelOptions", hasTunnelOptions() ? tunnelOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableAcceleration":
            return Optional.ofNullable(clazz.cast(enableAcceleration()));
        case "StaticRoutesOnly":
            return Optional.ofNullable(clazz.cast(staticRoutesOnly()));
        case "LocalIpv4NetworkCidr":
            return Optional.ofNullable(clazz.cast(localIpv4NetworkCidr()));
        case "RemoteIpv4NetworkCidr":
            return Optional.ofNullable(clazz.cast(remoteIpv4NetworkCidr()));
        case "LocalIpv6NetworkCidr":
            return Optional.ofNullable(clazz.cast(localIpv6NetworkCidr()));
        case "RemoteIpv6NetworkCidr":
            return Optional.ofNullable(clazz.cast(remoteIpv6NetworkCidr()));
        case "TunnelInsideIpVersion":
            return Optional.ofNullable(clazz.cast(tunnelInsideIpVersionAsString()));
        case "TunnelOptions":
            return Optional.ofNullable(clazz.cast(tunnelOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpnConnectionOptions, T> g) {
        return obj -> g.apply((VpnConnectionOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpnConnectionOptions> {
        /**
         * <p>
         * Indicates whether acceleration is enabled for the VPN connection.
         * </p>
         * 
         * @param enableAcceleration
         *        Indicates whether acceleration is enabled for the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAcceleration(Boolean enableAcceleration);

        /**
         * <p>
         * Indicates whether the VPN connection uses static routes only. Static routes must be used for devices that
         * don't support BGP.
         * </p>
         * 
         * @param staticRoutesOnly
         *        Indicates whether the VPN connection uses static routes only. Static routes must be used for devices
         *        that don't support BGP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticRoutesOnly(Boolean staticRoutesOnly);

        /**
         * <p>
         * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * </p>
         * 
         * @param localIpv4NetworkCidr
         *        The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localIpv4NetworkCidr(String localIpv4NetworkCidr);

        /**
         * <p>
         * The IPv4 CIDR on the AWS side of the VPN connection.
         * </p>
         * 
         * @param remoteIpv4NetworkCidr
         *        The IPv4 CIDR on the AWS side of the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteIpv4NetworkCidr(String remoteIpv4NetworkCidr);

        /**
         * <p>
         * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * </p>
         * 
         * @param localIpv6NetworkCidr
         *        The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localIpv6NetworkCidr(String localIpv6NetworkCidr);

        /**
         * <p>
         * The IPv6 CIDR on the AWS side of the VPN connection.
         * </p>
         * 
         * @param remoteIpv6NetworkCidr
         *        The IPv6 CIDR on the AWS side of the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteIpv6NetworkCidr(String remoteIpv6NetworkCidr);

        /**
         * <p>
         * Indicates whether the VPN tunnels process IPv4 or IPv6 traffic.
         * </p>
         * 
         * @param tunnelInsideIpVersion
         *        Indicates whether the VPN tunnels process IPv4 or IPv6 traffic.
         * @see TunnelInsideIpVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TunnelInsideIpVersion
         */
        Builder tunnelInsideIpVersion(String tunnelInsideIpVersion);

        /**
         * <p>
         * Indicates whether the VPN tunnels process IPv4 or IPv6 traffic.
         * </p>
         * 
         * @param tunnelInsideIpVersion
         *        Indicates whether the VPN tunnels process IPv4 or IPv6 traffic.
         * @see TunnelInsideIpVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TunnelInsideIpVersion
         */
        Builder tunnelInsideIpVersion(TunnelInsideIpVersion tunnelInsideIpVersion);

        /**
         * <p>
         * Indicates the VPN tunnel options.
         * </p>
         * 
         * @param tunnelOptions
         *        Indicates the VPN tunnel options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelOptions(Collection<TunnelOption> tunnelOptions);

        /**
         * <p>
         * Indicates the VPN tunnel options.
         * </p>
         * 
         * @param tunnelOptions
         *        Indicates the VPN tunnel options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelOptions(TunnelOption... tunnelOptions);

        /**
         * <p>
         * Indicates the VPN tunnel options.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TunnelOption>.Builder} avoiding the need to
         * create one manually via {@link List<TunnelOption>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TunnelOption>.Builder#build()} is called immediately and its
         * result is passed to {@link #tunnelOptions(List<TunnelOption>)}.
         * 
         * @param tunnelOptions
         *        a consumer that will call methods on {@link List<TunnelOption>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tunnelOptions(List<TunnelOption>)
         */
        Builder tunnelOptions(Consumer<TunnelOption.Builder>... tunnelOptions);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableAcceleration;

        private Boolean staticRoutesOnly;

        private String localIpv4NetworkCidr;

        private String remoteIpv4NetworkCidr;

        private String localIpv6NetworkCidr;

        private String remoteIpv6NetworkCidr;

        private String tunnelInsideIpVersion;

        private List<TunnelOption> tunnelOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpnConnectionOptions model) {
            enableAcceleration(model.enableAcceleration);
            staticRoutesOnly(model.staticRoutesOnly);
            localIpv4NetworkCidr(model.localIpv4NetworkCidr);
            remoteIpv4NetworkCidr(model.remoteIpv4NetworkCidr);
            localIpv6NetworkCidr(model.localIpv6NetworkCidr);
            remoteIpv6NetworkCidr(model.remoteIpv6NetworkCidr);
            tunnelInsideIpVersion(model.tunnelInsideIpVersion);
            tunnelOptions(model.tunnelOptions);
        }

        public final Boolean getEnableAcceleration() {
            return enableAcceleration;
        }

        @Override
        public final Builder enableAcceleration(Boolean enableAcceleration) {
            this.enableAcceleration = enableAcceleration;
            return this;
        }

        public final void setEnableAcceleration(Boolean enableAcceleration) {
            this.enableAcceleration = enableAcceleration;
        }

        public final Boolean getStaticRoutesOnly() {
            return staticRoutesOnly;
        }

        @Override
        public final Builder staticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        public final void setStaticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
        }

        public final String getLocalIpv4NetworkCidr() {
            return localIpv4NetworkCidr;
        }

        @Override
        public final Builder localIpv4NetworkCidr(String localIpv4NetworkCidr) {
            this.localIpv4NetworkCidr = localIpv4NetworkCidr;
            return this;
        }

        public final void setLocalIpv4NetworkCidr(String localIpv4NetworkCidr) {
            this.localIpv4NetworkCidr = localIpv4NetworkCidr;
        }

        public final String getRemoteIpv4NetworkCidr() {
            return remoteIpv4NetworkCidr;
        }

        @Override
        public final Builder remoteIpv4NetworkCidr(String remoteIpv4NetworkCidr) {
            this.remoteIpv4NetworkCidr = remoteIpv4NetworkCidr;
            return this;
        }

        public final void setRemoteIpv4NetworkCidr(String remoteIpv4NetworkCidr) {
            this.remoteIpv4NetworkCidr = remoteIpv4NetworkCidr;
        }

        public final String getLocalIpv6NetworkCidr() {
            return localIpv6NetworkCidr;
        }

        @Override
        public final Builder localIpv6NetworkCidr(String localIpv6NetworkCidr) {
            this.localIpv6NetworkCidr = localIpv6NetworkCidr;
            return this;
        }

        public final void setLocalIpv6NetworkCidr(String localIpv6NetworkCidr) {
            this.localIpv6NetworkCidr = localIpv6NetworkCidr;
        }

        public final String getRemoteIpv6NetworkCidr() {
            return remoteIpv6NetworkCidr;
        }

        @Override
        public final Builder remoteIpv6NetworkCidr(String remoteIpv6NetworkCidr) {
            this.remoteIpv6NetworkCidr = remoteIpv6NetworkCidr;
            return this;
        }

        public final void setRemoteIpv6NetworkCidr(String remoteIpv6NetworkCidr) {
            this.remoteIpv6NetworkCidr = remoteIpv6NetworkCidr;
        }

        public final String getTunnelInsideIpVersion() {
            return tunnelInsideIpVersion;
        }

        @Override
        public final Builder tunnelInsideIpVersion(String tunnelInsideIpVersion) {
            this.tunnelInsideIpVersion = tunnelInsideIpVersion;
            return this;
        }

        @Override
        public final Builder tunnelInsideIpVersion(TunnelInsideIpVersion tunnelInsideIpVersion) {
            this.tunnelInsideIpVersion(tunnelInsideIpVersion == null ? null : tunnelInsideIpVersion.toString());
            return this;
        }

        public final void setTunnelInsideIpVersion(String tunnelInsideIpVersion) {
            this.tunnelInsideIpVersion = tunnelInsideIpVersion;
        }

        public final List<TunnelOption.Builder> getTunnelOptions() {
            List<TunnelOption.Builder> result = TunnelOptionsListCopier.copyToBuilder(this.tunnelOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tunnelOptions(Collection<TunnelOption> tunnelOptions) {
            this.tunnelOptions = TunnelOptionsListCopier.copy(tunnelOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(TunnelOption... tunnelOptions) {
            tunnelOptions(Arrays.asList(tunnelOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(Consumer<TunnelOption.Builder>... tunnelOptions) {
            tunnelOptions(Stream.of(tunnelOptions).map(c -> TunnelOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTunnelOptions(Collection<TunnelOption.BuilderImpl> tunnelOptions) {
            this.tunnelOptions = TunnelOptionsListCopier.copyFromBuilder(tunnelOptions);
        }

        @Override
        public VpnConnectionOptions build() {
            return new VpnConnectionOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
