/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a VPC endpoint service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceDetail implements SdkPojo, Serializable, ToCopyableBuilder<ServiceDetail.Builder, ServiceDetail> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceName")
            .getter(getter(ServiceDetail::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName")
                    .unmarshallLocationName("serviceName").build()).build();

    private static final SdkField<String> SERVICE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceId")
            .getter(getter(ServiceDetail::serviceId))
            .setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId")
                    .unmarshallLocationName("serviceId").build()).build();

    private static final SdkField<List<ServiceTypeDetail>> SERVICE_TYPE_FIELD = SdkField
            .<List<ServiceTypeDetail>> builder(MarshallingType.LIST)
            .memberName("ServiceType")
            .getter(getter(ServiceDetail::serviceType))
            .setter(setter(Builder::serviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType")
                    .unmarshallLocationName("serviceType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ServiceTypeDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceTypeDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(ServiceDetail::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneSet")
                    .unmarshallLocationName("availabilityZoneSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Owner")
            .getter(getter(ServiceDetail::owner))
            .setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner")
                    .unmarshallLocationName("owner").build()).build();

    private static final SdkField<List<String>> BASE_ENDPOINT_DNS_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BaseEndpointDnsNames")
            .getter(getter(ServiceDetail::baseEndpointDnsNames))
            .setter(setter(Builder::baseEndpointDnsNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpointDnsNameSet")
                    .unmarshallLocationName("baseEndpointDnsNameSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateDnsName")
            .getter(getter(ServiceDetail::privateDnsName))
            .setter(setter(Builder::privateDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName")
                    .unmarshallLocationName("privateDnsName").build()).build();

    private static final SdkField<List<PrivateDnsDetails>> PRIVATE_DNS_NAMES_FIELD = SdkField
            .<List<PrivateDnsDetails>> builder(MarshallingType.LIST)
            .memberName("PrivateDnsNames")
            .getter(getter(ServiceDetail::privateDnsNames))
            .setter(setter(Builder::privateDnsNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsNameSet")
                    .unmarshallLocationName("privateDnsNameSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PrivateDnsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrivateDnsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> VPC_ENDPOINT_POLICY_SUPPORTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("VpcEndpointPolicySupported")
            .getter(getter(ServiceDetail::vpcEndpointPolicySupported))
            .setter(setter(Builder::vpcEndpointPolicySupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointPolicySupported")
                    .unmarshallLocationName("vpcEndpointPolicySupported").build()).build();

    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AcceptanceRequired")
            .getter(getter(ServiceDetail::acceptanceRequired))
            .setter(setter(Builder::acceptanceRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired")
                    .unmarshallLocationName("acceptanceRequired").build()).build();

    private static final SdkField<Boolean> MANAGES_VPC_ENDPOINTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ManagesVpcEndpoints")
            .getter(getter(ServiceDetail::managesVpcEndpoints))
            .setter(setter(Builder::managesVpcEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagesVpcEndpoints")
                    .unmarshallLocationName("managesVpcEndpoints").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ServiceDetail::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> PRIVATE_DNS_NAME_VERIFICATION_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateDnsNameVerificationState")
            .getter(getter(ServiceDetail::privateDnsNameVerificationStateAsString))
            .setter(setter(Builder::privateDnsNameVerificationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsNameVerificationState")
                    .unmarshallLocationName("privateDnsNameVerificationState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD,
            SERVICE_ID_FIELD, SERVICE_TYPE_FIELD, AVAILABILITY_ZONES_FIELD, OWNER_FIELD, BASE_ENDPOINT_DNS_NAMES_FIELD,
            PRIVATE_DNS_NAME_FIELD, PRIVATE_DNS_NAMES_FIELD, VPC_ENDPOINT_POLICY_SUPPORTED_FIELD, ACCEPTANCE_REQUIRED_FIELD,
            MANAGES_VPC_ENDPOINTS_FIELD, TAGS_FIELD, PRIVATE_DNS_NAME_VERIFICATION_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceName;

    private final String serviceId;

    private final List<ServiceTypeDetail> serviceType;

    private final List<String> availabilityZones;

    private final String owner;

    private final List<String> baseEndpointDnsNames;

    private final String privateDnsName;

    private final List<PrivateDnsDetails> privateDnsNames;

    private final Boolean vpcEndpointPolicySupported;

    private final Boolean acceptanceRequired;

    private final Boolean managesVpcEndpoints;

    private final List<Tag> tags;

    private final String privateDnsNameVerificationState;

    private ServiceDetail(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.serviceId = builder.serviceId;
        this.serviceType = builder.serviceType;
        this.availabilityZones = builder.availabilityZones;
        this.owner = builder.owner;
        this.baseEndpointDnsNames = builder.baseEndpointDnsNames;
        this.privateDnsName = builder.privateDnsName;
        this.privateDnsNames = builder.privateDnsNames;
        this.vpcEndpointPolicySupported = builder.vpcEndpointPolicySupported;
        this.acceptanceRequired = builder.acceptanceRequired;
        this.managesVpcEndpoints = builder.managesVpcEndpoints;
        this.tags = builder.tags;
        this.privateDnsNameVerificationState = builder.privateDnsNameVerificationState;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The ID of the endpoint service.
     * </p>
     * 
     * @return The ID of the endpoint service.
     */
    public final String serviceId() {
        return serviceId;
    }

    /**
     * Returns true if the ServiceType property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasServiceType() {
        return serviceType != null && !(serviceType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServiceType()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The type of service.
     */
    public final List<ServiceTypeDetail> serviceType() {
        return serviceType;
    }

    /**
     * Returns true if the AvailabilityZones property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Availability Zones in which the service is available.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAvailabilityZones()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Availability Zones in which the service is available.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The AWS account ID of the service owner.
     * </p>
     * 
     * @return The AWS account ID of the service owner.
     */
    public final String owner() {
        return owner;
    }

    /**
     * Returns true if the BaseEndpointDnsNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasBaseEndpointDnsNames() {
        return baseEndpointDnsNames != null && !(baseEndpointDnsNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The DNS names for the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBaseEndpointDnsNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The DNS names for the service.
     */
    public final List<String> baseEndpointDnsNames() {
        return baseEndpointDnsNames;
    }

    /**
     * <p>
     * The private DNS name for the service.
     * </p>
     * 
     * @return The private DNS name for the service.
     */
    public final String privateDnsName() {
        return privateDnsName;
    }

    /**
     * Returns true if the PrivateDnsNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPrivateDnsNames() {
        return privateDnsNames != null && !(privateDnsNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The private DNS names assigned to the VPC endpoint service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPrivateDnsNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The private DNS names assigned to the VPC endpoint service.
     */
    public final List<PrivateDnsDetails> privateDnsNames() {
        return privateDnsNames;
    }

    /**
     * <p>
     * Indicates whether the service supports endpoint policies.
     * </p>
     * 
     * @return Indicates whether the service supports endpoint policies.
     */
    public final Boolean vpcEndpointPolicySupported() {
        return vpcEndpointPolicySupported;
    }

    /**
     * <p>
     * Indicates whether VPC endpoint connection requests to the service must be accepted by the service owner.
     * </p>
     * 
     * @return Indicates whether VPC endpoint connection requests to the service must be accepted by the service owner.
     */
    public final Boolean acceptanceRequired() {
        return acceptanceRequired;
    }

    /**
     * <p>
     * Indicates whether the service manages its VPC endpoints. Management of the service VPC endpoints using the VPC
     * endpoint API is restricted.
     * </p>
     * 
     * @return Indicates whether the service manages its VPC endpoints. Management of the service VPC endpoints using
     *         the VPC endpoint API is restricted.
     */
    public final Boolean managesVpcEndpoints() {
        return managesVpcEndpoints;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags assigned to the service.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The verification state of the VPC endpoint service.
     * </p>
     * <p>
     * Consumers of the endpoint service cannot use the private name when the state is not <code>verified</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #privateDnsNameVerificationState} will return {@link DnsNameState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #privateDnsNameVerificationStateAsString}.
     * </p>
     * 
     * @return The verification state of the VPC endpoint service.</p>
     *         <p>
     *         Consumers of the endpoint service cannot use the private name when the state is not <code>verified</code>.
     * @see DnsNameState
     */
    public final DnsNameState privateDnsNameVerificationState() {
        return DnsNameState.fromValue(privateDnsNameVerificationState);
    }

    /**
     * <p>
     * The verification state of the VPC endpoint service.
     * </p>
     * <p>
     * Consumers of the endpoint service cannot use the private name when the state is not <code>verified</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #privateDnsNameVerificationState} will return {@link DnsNameState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #privateDnsNameVerificationStateAsString}.
     * </p>
     * 
     * @return The verification state of the VPC endpoint service.</p>
     *         <p>
     *         Consumers of the endpoint service cannot use the private name when the state is not <code>verified</code>.
     * @see DnsNameState
     */
    public final String privateDnsNameVerificationStateAsString() {
        return privateDnsNameVerificationState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceType() ? serviceType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(hasBaseEndpointDnsNames() ? baseEndpointDnsNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateDnsNames() ? privateDnsNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointPolicySupported());
        hashCode = 31 * hashCode + Objects.hashCode(acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(managesVpcEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsNameVerificationStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDetail)) {
            return false;
        }
        ServiceDetail other = (ServiceDetail) obj;
        return Objects.equals(serviceName(), other.serviceName()) && Objects.equals(serviceId(), other.serviceId())
                && hasServiceType() == other.hasServiceType() && Objects.equals(serviceType(), other.serviceType())
                && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones()) && Objects.equals(owner(), other.owner())
                && hasBaseEndpointDnsNames() == other.hasBaseEndpointDnsNames()
                && Objects.equals(baseEndpointDnsNames(), other.baseEndpointDnsNames())
                && Objects.equals(privateDnsName(), other.privateDnsName()) && hasPrivateDnsNames() == other.hasPrivateDnsNames()
                && Objects.equals(privateDnsNames(), other.privateDnsNames())
                && Objects.equals(vpcEndpointPolicySupported(), other.vpcEndpointPolicySupported())
                && Objects.equals(acceptanceRequired(), other.acceptanceRequired())
                && Objects.equals(managesVpcEndpoints(), other.managesVpcEndpoints()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(privateDnsNameVerificationStateAsString(), other.privateDnsNameVerificationStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceDetail").add("ServiceName", serviceName()).add("ServiceId", serviceId())
                .add("ServiceType", hasServiceType() ? serviceType() : null)
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null).add("Owner", owner())
                .add("BaseEndpointDnsNames", hasBaseEndpointDnsNames() ? baseEndpointDnsNames() : null)
                .add("PrivateDnsName", privateDnsName()).add("PrivateDnsNames", hasPrivateDnsNames() ? privateDnsNames() : null)
                .add("VpcEndpointPolicySupported", vpcEndpointPolicySupported()).add("AcceptanceRequired", acceptanceRequired())
                .add("ManagesVpcEndpoints", managesVpcEndpoints()).add("Tags", hasTags() ? tags() : null)
                .add("PrivateDnsNameVerificationState", privateDnsNameVerificationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "ServiceType":
            return Optional.ofNullable(clazz.cast(serviceType()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "BaseEndpointDnsNames":
            return Optional.ofNullable(clazz.cast(baseEndpointDnsNames()));
        case "PrivateDnsName":
            return Optional.ofNullable(clazz.cast(privateDnsName()));
        case "PrivateDnsNames":
            return Optional.ofNullable(clazz.cast(privateDnsNames()));
        case "VpcEndpointPolicySupported":
            return Optional.ofNullable(clazz.cast(vpcEndpointPolicySupported()));
        case "AcceptanceRequired":
            return Optional.ofNullable(clazz.cast(acceptanceRequired()));
        case "ManagesVpcEndpoints":
            return Optional.ofNullable(clazz.cast(managesVpcEndpoints()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "PrivateDnsNameVerificationState":
            return Optional.ofNullable(clazz.cast(privateDnsNameVerificationStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceDetail, T> g) {
        return obj -> g.apply((ServiceDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceDetail> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service.
         * </p>
         * 
         * @param serviceName
         *        The Amazon Resource Name (ARN) of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The ID of the endpoint service.
         * </p>
         * 
         * @param serviceId
         *        The ID of the endpoint service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * The type of service.
         * </p>
         * 
         * @param serviceType
         *        The type of service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceType(Collection<ServiceTypeDetail> serviceType);

        /**
         * <p>
         * The type of service.
         * </p>
         * 
         * @param serviceType
         *        The type of service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceType(ServiceTypeDetail... serviceType);

        /**
         * <p>
         * The type of service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceTypeDetail>.Builder} avoiding the
         * need to create one manually via {@link List<ServiceTypeDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceTypeDetail>.Builder#build()} is called immediately
         * and its result is passed to {@link #serviceType(List<ServiceTypeDetail>)}.
         * 
         * @param serviceType
         *        a consumer that will call methods on {@link List<ServiceTypeDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceType(List<ServiceTypeDetail>)
         */
        Builder serviceType(Consumer<ServiceTypeDetail.Builder>... serviceType);

        /**
         * <p>
         * The Availability Zones in which the service is available.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones in which the service is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * The Availability Zones in which the service is available.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones in which the service is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The AWS account ID of the service owner.
         * </p>
         * 
         * @param owner
         *        The AWS account ID of the service owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The DNS names for the service.
         * </p>
         * 
         * @param baseEndpointDnsNames
         *        The DNS names for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseEndpointDnsNames(Collection<String> baseEndpointDnsNames);

        /**
         * <p>
         * The DNS names for the service.
         * </p>
         * 
         * @param baseEndpointDnsNames
         *        The DNS names for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseEndpointDnsNames(String... baseEndpointDnsNames);

        /**
         * <p>
         * The private DNS name for the service.
         * </p>
         * 
         * @param privateDnsName
         *        The private DNS name for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * The private DNS names assigned to the VPC endpoint service.
         * </p>
         * 
         * @param privateDnsNames
         *        The private DNS names assigned to the VPC endpoint service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsNames(Collection<PrivateDnsDetails> privateDnsNames);

        /**
         * <p>
         * The private DNS names assigned to the VPC endpoint service.
         * </p>
         * 
         * @param privateDnsNames
         *        The private DNS names assigned to the VPC endpoint service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsNames(PrivateDnsDetails... privateDnsNames);

        /**
         * <p>
         * The private DNS names assigned to the VPC endpoint service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PrivateDnsDetails>.Builder} avoiding the
         * need to create one manually via {@link List<PrivateDnsDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PrivateDnsDetails>.Builder#build()} is called immediately
         * and its result is passed to {@link #privateDnsNames(List<PrivateDnsDetails>)}.
         * 
         * @param privateDnsNames
         *        a consumer that will call methods on {@link List<PrivateDnsDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateDnsNames(List<PrivateDnsDetails>)
         */
        Builder privateDnsNames(Consumer<PrivateDnsDetails.Builder>... privateDnsNames);

        /**
         * <p>
         * Indicates whether the service supports endpoint policies.
         * </p>
         * 
         * @param vpcEndpointPolicySupported
         *        Indicates whether the service supports endpoint policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointPolicySupported(Boolean vpcEndpointPolicySupported);

        /**
         * <p>
         * Indicates whether VPC endpoint connection requests to the service must be accepted by the service owner.
         * </p>
         * 
         * @param acceptanceRequired
         *        Indicates whether VPC endpoint connection requests to the service must be accepted by the service
         *        owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptanceRequired(Boolean acceptanceRequired);

        /**
         * <p>
         * Indicates whether the service manages its VPC endpoints. Management of the service VPC endpoints using the
         * VPC endpoint API is restricted.
         * </p>
         * 
         * @param managesVpcEndpoints
         *        Indicates whether the service manages its VPC endpoints. Management of the service VPC endpoints using
         *        the VPC endpoint API is restricted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managesVpcEndpoints(Boolean managesVpcEndpoints);

        /**
         * <p>
         * Any tags assigned to the service.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the service.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The verification state of the VPC endpoint service.
         * </p>
         * <p>
         * Consumers of the endpoint service cannot use the private name when the state is not <code>verified</code>.
         * </p>
         * 
         * @param privateDnsNameVerificationState
         *        The verification state of the VPC endpoint service.</p>
         *        <p>
         *        Consumers of the endpoint service cannot use the private name when the state is not
         *        <code>verified</code>.
         * @see DnsNameState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsNameState
         */
        Builder privateDnsNameVerificationState(String privateDnsNameVerificationState);

        /**
         * <p>
         * The verification state of the VPC endpoint service.
         * </p>
         * <p>
         * Consumers of the endpoint service cannot use the private name when the state is not <code>verified</code>.
         * </p>
         * 
         * @param privateDnsNameVerificationState
         *        The verification state of the VPC endpoint service.</p>
         *        <p>
         *        Consumers of the endpoint service cannot use the private name when the state is not
         *        <code>verified</code>.
         * @see DnsNameState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsNameState
         */
        Builder privateDnsNameVerificationState(DnsNameState privateDnsNameVerificationState);
    }

    static final class BuilderImpl implements Builder {
        private String serviceName;

        private String serviceId;

        private List<ServiceTypeDetail> serviceType = DefaultSdkAutoConstructList.getInstance();

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private String owner;

        private List<String> baseEndpointDnsNames = DefaultSdkAutoConstructList.getInstance();

        private String privateDnsName;

        private List<PrivateDnsDetails> privateDnsNames = DefaultSdkAutoConstructList.getInstance();

        private Boolean vpcEndpointPolicySupported;

        private Boolean acceptanceRequired;

        private Boolean managesVpcEndpoints;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String privateDnsNameVerificationState;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceDetail model) {
            serviceName(model.serviceName);
            serviceId(model.serviceId);
            serviceType(model.serviceType);
            availabilityZones(model.availabilityZones);
            owner(model.owner);
            baseEndpointDnsNames(model.baseEndpointDnsNames);
            privateDnsName(model.privateDnsName);
            privateDnsNames(model.privateDnsNames);
            vpcEndpointPolicySupported(model.vpcEndpointPolicySupported);
            acceptanceRequired(model.acceptanceRequired);
            managesVpcEndpoints(model.managesVpcEndpoints);
            tags(model.tags);
            privateDnsNameVerificationState(model.privateDnsNameVerificationState);
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getServiceId() {
            return serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final List<ServiceTypeDetail.Builder> getServiceType() {
            List<ServiceTypeDetail.Builder> result = ServiceTypeDetailSetCopier.copyToBuilder(this.serviceType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder serviceType(Collection<ServiceTypeDetail> serviceType) {
            this.serviceType = ServiceTypeDetailSetCopier.copy(serviceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceType(ServiceTypeDetail... serviceType) {
            serviceType(Arrays.asList(serviceType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceType(Consumer<ServiceTypeDetail.Builder>... serviceType) {
            serviceType(Stream.of(serviceType).map(c -> ServiceTypeDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setServiceType(Collection<ServiceTypeDetail.BuilderImpl> serviceType) {
            this.serviceType = ServiceTypeDetailSetCopier.copyFromBuilder(serviceType);
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Collection<String> getBaseEndpointDnsNames() {
            if (baseEndpointDnsNames instanceof SdkAutoConstructList) {
                return null;
            }
            return baseEndpointDnsNames;
        }

        @Override
        public final Builder baseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = ValueStringListCopier.copy(baseEndpointDnsNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseEndpointDnsNames(String... baseEndpointDnsNames) {
            baseEndpointDnsNames(Arrays.asList(baseEndpointDnsNames));
            return this;
        }

        public final void setBaseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = ValueStringListCopier.copy(baseEndpointDnsNames);
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final List<PrivateDnsDetails.Builder> getPrivateDnsNames() {
            List<PrivateDnsDetails.Builder> result = PrivateDnsDetailsSetCopier.copyToBuilder(this.privateDnsNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder privateDnsNames(Collection<PrivateDnsDetails> privateDnsNames) {
            this.privateDnsNames = PrivateDnsDetailsSetCopier.copy(privateDnsNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateDnsNames(PrivateDnsDetails... privateDnsNames) {
            privateDnsNames(Arrays.asList(privateDnsNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateDnsNames(Consumer<PrivateDnsDetails.Builder>... privateDnsNames) {
            privateDnsNames(Stream.of(privateDnsNames).map(c -> PrivateDnsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPrivateDnsNames(Collection<PrivateDnsDetails.BuilderImpl> privateDnsNames) {
            this.privateDnsNames = PrivateDnsDetailsSetCopier.copyFromBuilder(privateDnsNames);
        }

        public final Boolean getVpcEndpointPolicySupported() {
            return vpcEndpointPolicySupported;
        }

        @Override
        public final Builder vpcEndpointPolicySupported(Boolean vpcEndpointPolicySupported) {
            this.vpcEndpointPolicySupported = vpcEndpointPolicySupported;
            return this;
        }

        public final void setVpcEndpointPolicySupported(Boolean vpcEndpointPolicySupported) {
            this.vpcEndpointPolicySupported = vpcEndpointPolicySupported;
        }

        public final Boolean getAcceptanceRequired() {
            return acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        public final Boolean getManagesVpcEndpoints() {
            return managesVpcEndpoints;
        }

        @Override
        public final Builder managesVpcEndpoints(Boolean managesVpcEndpoints) {
            this.managesVpcEndpoints = managesVpcEndpoints;
            return this;
        }

        public final void setManagesVpcEndpoints(Boolean managesVpcEndpoints) {
            this.managesVpcEndpoints = managesVpcEndpoints;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getPrivateDnsNameVerificationState() {
            return privateDnsNameVerificationState;
        }

        @Override
        public final Builder privateDnsNameVerificationState(String privateDnsNameVerificationState) {
            this.privateDnsNameVerificationState = privateDnsNameVerificationState;
            return this;
        }

        @Override
        public final Builder privateDnsNameVerificationState(DnsNameState privateDnsNameVerificationState) {
            this.privateDnsNameVerificationState(privateDnsNameVerificationState == null ? null : privateDnsNameVerificationState
                    .toString());
            return this;
        }

        public final void setPrivateDnsNameVerificationState(String privateDnsNameVerificationState) {
            this.privateDnsNameVerificationState = privateDnsNameVerificationState;
        }

        @Override
        public ServiceDetail build() {
            return new ServiceDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
