/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the placement group support of the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlacementGroupInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<PlacementGroupInfo.Builder, PlacementGroupInfo> {
    private static final SdkField<List<String>> SUPPORTED_STRATEGIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedStrategies")
            .getter(getter(PlacementGroupInfo::supportedStrategiesAsStrings))
            .setter(setter(Builder::supportedStrategiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedStrategies")
                    .unmarshallLocationName("supportedStrategies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTED_STRATEGIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> supportedStrategies;

    private PlacementGroupInfo(BuilderImpl builder) {
        this.supportedStrategies = builder.supportedStrategies;
    }

    /**
     * <p>
     * The supported placement group types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedStrategies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The supported placement group types.
     */
    public final List<PlacementGroupStrategy> supportedStrategies() {
        return PlacementGroupStrategyListCopier.copyStringToEnum(supportedStrategies);
    }

    /**
     * Returns true if the SupportedStrategies property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSupportedStrategies() {
        return supportedStrategies != null && !(supportedStrategies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported placement group types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedStrategies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The supported placement group types.
     */
    public final List<String> supportedStrategiesAsStrings() {
        return supportedStrategies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedStrategies() ? supportedStrategiesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementGroupInfo)) {
            return false;
        }
        PlacementGroupInfo other = (PlacementGroupInfo) obj;
        return hasSupportedStrategies() == other.hasSupportedStrategies()
                && Objects.equals(supportedStrategiesAsStrings(), other.supportedStrategiesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PlacementGroupInfo")
                .add("SupportedStrategies", hasSupportedStrategies() ? supportedStrategiesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SupportedStrategies":
            return Optional.ofNullable(clazz.cast(supportedStrategiesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlacementGroupInfo, T> g) {
        return obj -> g.apply((PlacementGroupInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlacementGroupInfo> {
        /**
         * <p>
         * The supported placement group types.
         * </p>
         * 
         * @param supportedStrategies
         *        The supported placement group types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedStrategiesWithStrings(Collection<String> supportedStrategies);

        /**
         * <p>
         * The supported placement group types.
         * </p>
         * 
         * @param supportedStrategies
         *        The supported placement group types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedStrategiesWithStrings(String... supportedStrategies);

        /**
         * <p>
         * The supported placement group types.
         * </p>
         * 
         * @param supportedStrategies
         *        The supported placement group types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedStrategies(Collection<PlacementGroupStrategy> supportedStrategies);

        /**
         * <p>
         * The supported placement group types.
         * </p>
         * 
         * @param supportedStrategies
         *        The supported placement group types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedStrategies(PlacementGroupStrategy... supportedStrategies);
    }

    static final class BuilderImpl implements Builder {
        private List<String> supportedStrategies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementGroupInfo model) {
            supportedStrategiesWithStrings(model.supportedStrategies);
        }

        public final Collection<String> getSupportedStrategies() {
            if (supportedStrategies instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedStrategies;
        }

        @Override
        public final Builder supportedStrategiesWithStrings(Collection<String> supportedStrategies) {
            this.supportedStrategies = PlacementGroupStrategyListCopier.copy(supportedStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedStrategiesWithStrings(String... supportedStrategies) {
            supportedStrategiesWithStrings(Arrays.asList(supportedStrategies));
            return this;
        }

        @Override
        public final Builder supportedStrategies(Collection<PlacementGroupStrategy> supportedStrategies) {
            this.supportedStrategies = PlacementGroupStrategyListCopier.copyEnumToString(supportedStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedStrategies(PlacementGroupStrategy... supportedStrategies) {
            supportedStrategies(Arrays.asList(supportedStrategies));
            return this;
        }

        public final void setSupportedStrategies(Collection<String> supportedStrategies) {
            this.supportedStrategies = PlacementGroupStrategyListCopier.copy(supportedStrategies);
        }

        @Override
        public PlacementGroupInfo build() {
            return new PlacementGroupInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
