/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpcAttributeRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVpcAttributeRequest.Builder, ModifyVpcAttributeRequest> {
    private static final SdkField<AttributeBooleanValue> ENABLE_DNS_HOSTNAMES_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("EnableDnsHostnames")
            .getter(getter(ModifyVpcAttributeRequest::enableDnsHostnames))
            .setter(setter(Builder::enableDnsHostnames))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDnsHostnames")
                    .unmarshallLocationName("EnableDnsHostnames").build()).build();

    private static final SdkField<AttributeBooleanValue> ENABLE_DNS_SUPPORT_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("EnableDnsSupport")
            .getter(getter(ModifyVpcAttributeRequest::enableDnsSupport))
            .setter(setter(Builder::enableDnsSupport))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDnsSupport")
                    .unmarshallLocationName("EnableDnsSupport").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(ModifyVpcAttributeRequest::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_DNS_HOSTNAMES_FIELD,
            ENABLE_DNS_SUPPORT_FIELD, VPC_ID_FIELD));

    private final AttributeBooleanValue enableDnsHostnames;

    private final AttributeBooleanValue enableDnsSupport;

    private final String vpcId;

    private ModifyVpcAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.enableDnsHostnames = builder.enableDnsHostnames;
        this.enableDnsSupport = builder.enableDnsSupport;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * Indicates whether the instances launched in the VPC get DNS hostnames. If enabled, instances in the VPC get DNS
     * hostnames; otherwise, they do not.
     * </p>
     * <p>
     * You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for
     * each attribute. You can only enable DNS hostnames if you've enabled DNS support.
     * </p>
     * 
     * @return Indicates whether the instances launched in the VPC get DNS hostnames. If enabled, instances in the VPC
     *         get DNS hostnames; otherwise, they do not.</p>
     *         <p>
     *         You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate
     *         requests for each attribute. You can only enable DNS hostnames if you've enabled DNS support.
     */
    public final AttributeBooleanValue enableDnsHostnames() {
        return enableDnsHostnames;
    }

    /**
     * <p>
     * Indicates whether the DNS resolution is supported for the VPC. If enabled, queries to the Amazon provided DNS
     * server at the 169.254.169.253 IP address, or the reserved IP address at the base of the VPC network range
     * "plus two" succeed. If disabled, the Amazon provided DNS service in the VPC that resolves public DNS hostnames to
     * IP addresses is not enabled.
     * </p>
     * <p>
     * You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for
     * each attribute.
     * </p>
     * 
     * @return Indicates whether the DNS resolution is supported for the VPC. If enabled, queries to the Amazon provided
     *         DNS server at the 169.254.169.253 IP address, or the reserved IP address at the base of the VPC network
     *         range "plus two" succeed. If disabled, the Amazon provided DNS service in the VPC that resolves public
     *         DNS hostnames to IP addresses is not enabled.</p>
     *         <p>
     *         You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate
     *         requests for each attribute.
     */
    public final AttributeBooleanValue enableDnsSupport() {
        return enableDnsSupport;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(enableDnsHostnames());
        hashCode = 31 * hashCode + Objects.hashCode(enableDnsSupport());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcAttributeRequest)) {
            return false;
        }
        ModifyVpcAttributeRequest other = (ModifyVpcAttributeRequest) obj;
        return Objects.equals(enableDnsHostnames(), other.enableDnsHostnames())
                && Objects.equals(enableDnsSupport(), other.enableDnsSupport()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVpcAttributeRequest").add("EnableDnsHostnames", enableDnsHostnames())
                .add("EnableDnsSupport", enableDnsSupport()).add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableDnsHostnames":
            return Optional.ofNullable(clazz.cast(enableDnsHostnames()));
        case "EnableDnsSupport":
            return Optional.ofNullable(clazz.cast(enableDnsSupport()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcAttributeRequest, T> g) {
        return obj -> g.apply((ModifyVpcAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyVpcAttributeRequest> {
        /**
         * <p>
         * Indicates whether the instances launched in the VPC get DNS hostnames. If enabled, instances in the VPC get
         * DNS hostnames; otherwise, they do not.
         * </p>
         * <p>
         * You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests
         * for each attribute. You can only enable DNS hostnames if you've enabled DNS support.
         * </p>
         * 
         * @param enableDnsHostnames
         *        Indicates whether the instances launched in the VPC get DNS hostnames. If enabled, instances in the
         *        VPC get DNS hostnames; otherwise, they do not.</p>
         *        <p>
         *        You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate
         *        requests for each attribute. You can only enable DNS hostnames if you've enabled DNS support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDnsHostnames(AttributeBooleanValue enableDnsHostnames);

        /**
         * <p>
         * Indicates whether the instances launched in the VPC get DNS hostnames. If enabled, instances in the VPC get
         * DNS hostnames; otherwise, they do not.
         * </p>
         * <p>
         * You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests
         * for each attribute. You can only enable DNS hostnames if you've enabled DNS support.
         * </p>
         * This is a convenience that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding the need
         * to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #enableDnsHostnames(AttributeBooleanValue)}.
         * 
         * @param enableDnsHostnames
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enableDnsHostnames(AttributeBooleanValue)
         */
        default Builder enableDnsHostnames(Consumer<AttributeBooleanValue.Builder> enableDnsHostnames) {
            return enableDnsHostnames(AttributeBooleanValue.builder().applyMutation(enableDnsHostnames).build());
        }

        /**
         * <p>
         * Indicates whether the DNS resolution is supported for the VPC. If enabled, queries to the Amazon provided DNS
         * server at the 169.254.169.253 IP address, or the reserved IP address at the base of the VPC network range
         * "plus two" succeed. If disabled, the Amazon provided DNS service in the VPC that resolves public DNS
         * hostnames to IP addresses is not enabled.
         * </p>
         * <p>
         * You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests
         * for each attribute.
         * </p>
         * 
         * @param enableDnsSupport
         *        Indicates whether the DNS resolution is supported for the VPC. If enabled, queries to the Amazon
         *        provided DNS server at the 169.254.169.253 IP address, or the reserved IP address at the base of the
         *        VPC network range "plus two" succeed. If disabled, the Amazon provided DNS service in the VPC that
         *        resolves public DNS hostnames to IP addresses is not enabled.</p>
         *        <p>
         *        You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate
         *        requests for each attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDnsSupport(AttributeBooleanValue enableDnsSupport);

        /**
         * <p>
         * Indicates whether the DNS resolution is supported for the VPC. If enabled, queries to the Amazon provided DNS
         * server at the 169.254.169.253 IP address, or the reserved IP address at the base of the VPC network range
         * "plus two" succeed. If disabled, the Amazon provided DNS service in the VPC that resolves public DNS
         * hostnames to IP addresses is not enabled.
         * </p>
         * <p>
         * You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests
         * for each attribute.
         * </p>
         * This is a convenience that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding the need
         * to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #enableDnsSupport(AttributeBooleanValue)}.
         * 
         * @param enableDnsSupport
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enableDnsSupport(AttributeBooleanValue)
         */
        default Builder enableDnsSupport(Consumer<AttributeBooleanValue.Builder> enableDnsSupport) {
            return enableDnsSupport(AttributeBooleanValue.builder().applyMutation(enableDnsSupport).build());
        }

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private AttributeBooleanValue enableDnsHostnames;

        private AttributeBooleanValue enableDnsSupport;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcAttributeRequest model) {
            super(model);
            enableDnsHostnames(model.enableDnsHostnames);
            enableDnsSupport(model.enableDnsSupport);
            vpcId(model.vpcId);
        }

        public final AttributeBooleanValue.Builder getEnableDnsHostnames() {
            return enableDnsHostnames != null ? enableDnsHostnames.toBuilder() : null;
        }

        @Override
        public final Builder enableDnsHostnames(AttributeBooleanValue enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames;
            return this;
        }

        public final void setEnableDnsHostnames(AttributeBooleanValue.BuilderImpl enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames != null ? enableDnsHostnames.build() : null;
        }

        public final AttributeBooleanValue.Builder getEnableDnsSupport() {
            return enableDnsSupport != null ? enableDnsSupport.toBuilder() : null;
        }

        @Override
        public final Builder enableDnsSupport(AttributeBooleanValue enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport;
            return this;
        }

        public final void setEnableDnsSupport(AttributeBooleanValue.BuilderImpl enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport != null ? enableDnsSupport.build() : null;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcAttributeRequest build() {
            return new ModifyVpcAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
