/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetSpotMaintenanceStrategiesRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<FleetSpotMaintenanceStrategiesRequest.Builder, FleetSpotMaintenanceStrategiesRequest> {
    private static final SdkField<FleetSpotCapacityRebalanceRequest> CAPACITY_REBALANCE_FIELD = SdkField
            .<FleetSpotCapacityRebalanceRequest> builder(MarshallingType.SDK_POJO)
            .memberName("CapacityRebalance")
            .getter(getter(FleetSpotMaintenanceStrategiesRequest::capacityRebalance))
            .setter(setter(Builder::capacityRebalance))
            .constructor(FleetSpotCapacityRebalanceRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityRebalance")
                    .unmarshallLocationName("CapacityRebalance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_REBALANCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final FleetSpotCapacityRebalanceRequest capacityRebalance;

    private FleetSpotMaintenanceStrategiesRequest(BuilderImpl builder) {
        this.capacityRebalance = builder.capacityRebalance;
    }

    /**
     * <p>
     * The strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an elevated risk of being
     * interrupted.
     * </p>
     * 
     * @return The strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an elevated risk of
     *         being interrupted.
     */
    public final FleetSpotCapacityRebalanceRequest capacityRebalance() {
        return capacityRebalance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityRebalance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetSpotMaintenanceStrategiesRequest)) {
            return false;
        }
        FleetSpotMaintenanceStrategiesRequest other = (FleetSpotMaintenanceStrategiesRequest) obj;
        return Objects.equals(capacityRebalance(), other.capacityRebalance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetSpotMaintenanceStrategiesRequest").add("CapacityRebalance", capacityRebalance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityRebalance":
            return Optional.ofNullable(clazz.cast(capacityRebalance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetSpotMaintenanceStrategiesRequest, T> g) {
        return obj -> g.apply((FleetSpotMaintenanceStrategiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetSpotMaintenanceStrategiesRequest> {
        /**
         * <p>
         * The strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an elevated risk of being
         * interrupted.
         * </p>
         * 
         * @param capacityRebalance
         *        The strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an elevated risk of
         *        being interrupted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityRebalance(FleetSpotCapacityRebalanceRequest capacityRebalance);

        /**
         * <p>
         * The strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an elevated risk of being
         * interrupted.
         * </p>
         * This is a convenience that creates an instance of the {@link FleetSpotCapacityRebalanceRequest.Builder}
         * avoiding the need to create one manually via {@link FleetSpotCapacityRebalanceRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link FleetSpotCapacityRebalanceRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #capacityRebalance(FleetSpotCapacityRebalanceRequest)}.
         * 
         * @param capacityRebalance
         *        a consumer that will call methods on {@link FleetSpotCapacityRebalanceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityRebalance(FleetSpotCapacityRebalanceRequest)
         */
        default Builder capacityRebalance(Consumer<FleetSpotCapacityRebalanceRequest.Builder> capacityRebalance) {
            return capacityRebalance(FleetSpotCapacityRebalanceRequest.builder().applyMutation(capacityRebalance).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FleetSpotCapacityRebalanceRequest capacityRebalance;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetSpotMaintenanceStrategiesRequest model) {
            capacityRebalance(model.capacityRebalance);
        }

        public final FleetSpotCapacityRebalanceRequest.Builder getCapacityRebalance() {
            return capacityRebalance != null ? capacityRebalance.toBuilder() : null;
        }

        @Override
        public final Builder capacityRebalance(FleetSpotCapacityRebalanceRequest capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
            return this;
        }

        public final void setCapacityRebalance(FleetSpotCapacityRebalanceRequest.BuilderImpl capacityRebalance) {
            this.capacityRebalance = capacityRebalance != null ? capacityRebalance.build() : null;
        }

        @Override
        public FleetSpotMaintenanceStrategiesRequest build() {
            return new FleetSpotMaintenanceStrategiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
