/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an elevated risk of being
 * interrupted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetSpotCapacityRebalance implements SdkPojo, Serializable,
        ToCopyableBuilder<FleetSpotCapacityRebalance.Builder, FleetSpotCapacityRebalance> {
    private static final SdkField<String> REPLACEMENT_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplacementStrategy")
            .getter(getter(FleetSpotCapacityRebalance::replacementStrategyAsString))
            .setter(setter(Builder::replacementStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementStrategy")
                    .unmarshallLocationName("replacementStrategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLACEMENT_STRATEGY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String replacementStrategy;

    private FleetSpotCapacityRebalance(BuilderImpl builder) {
        this.replacementStrategy = builder.replacementStrategy;
    }

    /**
     * <p>
     * To allow EC2 Fleet to launch a replacement Spot Instance when an instance rebalance notification is emitted for
     * an existing Spot Instance in the fleet, specify <code>launch</code>. Only available for fleets of type
     * <code>maintain</code>.
     * </p>
     * <note>
     * <p>
     * When a replacement instance is launched, the instance marked for rebalance is not automatically terminated. You
     * can terminate it, or you can leave it running. You are charged for both instances while they are running.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #replacementStrategy} will return {@link FleetReplacementStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #replacementStrategyAsString}.
     * </p>
     * 
     * @return To allow EC2 Fleet to launch a replacement Spot Instance when an instance rebalance notification is
     *         emitted for an existing Spot Instance in the fleet, specify <code>launch</code>. Only available for
     *         fleets of type <code>maintain</code>.</p> <note>
     *         <p>
     *         When a replacement instance is launched, the instance marked for rebalance is not automatically
     *         terminated. You can terminate it, or you can leave it running. You are charged for both instances while
     *         they are running.
     *         </p>
     * @see FleetReplacementStrategy
     */
    public final FleetReplacementStrategy replacementStrategy() {
        return FleetReplacementStrategy.fromValue(replacementStrategy);
    }

    /**
     * <p>
     * To allow EC2 Fleet to launch a replacement Spot Instance when an instance rebalance notification is emitted for
     * an existing Spot Instance in the fleet, specify <code>launch</code>. Only available for fleets of type
     * <code>maintain</code>.
     * </p>
     * <note>
     * <p>
     * When a replacement instance is launched, the instance marked for rebalance is not automatically terminated. You
     * can terminate it, or you can leave it running. You are charged for both instances while they are running.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #replacementStrategy} will return {@link FleetReplacementStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #replacementStrategyAsString}.
     * </p>
     * 
     * @return To allow EC2 Fleet to launch a replacement Spot Instance when an instance rebalance notification is
     *         emitted for an existing Spot Instance in the fleet, specify <code>launch</code>. Only available for
     *         fleets of type <code>maintain</code>.</p> <note>
     *         <p>
     *         When a replacement instance is launched, the instance marked for rebalance is not automatically
     *         terminated. You can terminate it, or you can leave it running. You are charged for both instances while
     *         they are running.
     *         </p>
     * @see FleetReplacementStrategy
     */
    public final String replacementStrategyAsString() {
        return replacementStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replacementStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetSpotCapacityRebalance)) {
            return false;
        }
        FleetSpotCapacityRebalance other = (FleetSpotCapacityRebalance) obj;
        return Objects.equals(replacementStrategyAsString(), other.replacementStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetSpotCapacityRebalance").add("ReplacementStrategy", replacementStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplacementStrategy":
            return Optional.ofNullable(clazz.cast(replacementStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetSpotCapacityRebalance, T> g) {
        return obj -> g.apply((FleetSpotCapacityRebalance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetSpotCapacityRebalance> {
        /**
         * <p>
         * To allow EC2 Fleet to launch a replacement Spot Instance when an instance rebalance notification is emitted
         * for an existing Spot Instance in the fleet, specify <code>launch</code>. Only available for fleets of type
         * <code>maintain</code>.
         * </p>
         * <note>
         * <p>
         * When a replacement instance is launched, the instance marked for rebalance is not automatically terminated.
         * You can terminate it, or you can leave it running. You are charged for both instances while they are running.
         * </p>
         * </note>
         * 
         * @param replacementStrategy
         *        To allow EC2 Fleet to launch a replacement Spot Instance when an instance rebalance notification is
         *        emitted for an existing Spot Instance in the fleet, specify <code>launch</code>. Only available for
         *        fleets of type <code>maintain</code>.</p> <note>
         *        <p>
         *        When a replacement instance is launched, the instance marked for rebalance is not automatically
         *        terminated. You can terminate it, or you can leave it running. You are charged for both instances
         *        while they are running.
         *        </p>
         * @see FleetReplacementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetReplacementStrategy
         */
        Builder replacementStrategy(String replacementStrategy);

        /**
         * <p>
         * To allow EC2 Fleet to launch a replacement Spot Instance when an instance rebalance notification is emitted
         * for an existing Spot Instance in the fleet, specify <code>launch</code>. Only available for fleets of type
         * <code>maintain</code>.
         * </p>
         * <note>
         * <p>
         * When a replacement instance is launched, the instance marked for rebalance is not automatically terminated.
         * You can terminate it, or you can leave it running. You are charged for both instances while they are running.
         * </p>
         * </note>
         * 
         * @param replacementStrategy
         *        To allow EC2 Fleet to launch a replacement Spot Instance when an instance rebalance notification is
         *        emitted for an existing Spot Instance in the fleet, specify <code>launch</code>. Only available for
         *        fleets of type <code>maintain</code>.</p> <note>
         *        <p>
         *        When a replacement instance is launched, the instance marked for rebalance is not automatically
         *        terminated. You can terminate it, or you can leave it running. You are charged for both instances
         *        while they are running.
         *        </p>
         * @see FleetReplacementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetReplacementStrategy
         */
        Builder replacementStrategy(FleetReplacementStrategy replacementStrategy);
    }

    static final class BuilderImpl implements Builder {
        private String replacementStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetSpotCapacityRebalance model) {
            replacementStrategy(model.replacementStrategy);
        }

        public final String getReplacementStrategy() {
            return replacementStrategy;
        }

        @Override
        public final Builder replacementStrategy(String replacementStrategy) {
            this.replacementStrategy = replacementStrategy;
            return this;
        }

        @Override
        public final Builder replacementStrategy(FleetReplacementStrategy replacementStrategy) {
            this.replacementStrategy(replacementStrategy == null ? null : replacementStrategy.toString());
            return this;
        }

        public final void setReplacementStrategy(String replacementStrategy) {
            this.replacementStrategy = replacementStrategy;
        }

        @Override
        public FleetSpotCapacityRebalance build() {
            return new FleetSpotCapacityRebalance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
