/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeSpotFleetRequestHistory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSpotFleetRequestHistoryResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeSpotFleetRequestHistoryResponse.Builder, DescribeSpotFleetRequestHistoryResponse> {
    private static final SdkField<List<HistoryRecord>> HISTORY_RECORDS_FIELD = SdkField
            .<List<HistoryRecord>> builder(MarshallingType.LIST)
            .memberName("HistoryRecords")
            .getter(getter(DescribeSpotFleetRequestHistoryResponse::historyRecords))
            .setter(setter(Builder::historyRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoryRecordSet")
                    .unmarshallLocationName("historyRecordSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<HistoryRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(HistoryRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Instant> LAST_EVALUATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastEvaluatedTime")
            .getter(getter(DescribeSpotFleetRequestHistoryResponse::lastEvaluatedTime))
            .setter(setter(Builder::lastEvaluatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedTime")
                    .unmarshallLocationName("lastEvaluatedTime").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeSpotFleetRequestHistoryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<String> SPOT_FLEET_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpotFleetRequestId")
            .getter(getter(DescribeSpotFleetRequestHistoryResponse::spotFleetRequestId))
            .setter(setter(Builder::spotFleetRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId")
                    .unmarshallLocationName("spotFleetRequestId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(DescribeSpotFleetRequestHistoryResponse::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime")
                    .unmarshallLocationName("startTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HISTORY_RECORDS_FIELD,
            LAST_EVALUATED_TIME_FIELD, NEXT_TOKEN_FIELD, SPOT_FLEET_REQUEST_ID_FIELD, START_TIME_FIELD));

    private final List<HistoryRecord> historyRecords;

    private final Instant lastEvaluatedTime;

    private final String nextToken;

    private final String spotFleetRequestId;

    private final Instant startTime;

    private DescribeSpotFleetRequestHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.historyRecords = builder.historyRecords;
        this.lastEvaluatedTime = builder.lastEvaluatedTime;
        this.nextToken = builder.nextToken;
        this.spotFleetRequestId = builder.spotFleetRequestId;
        this.startTime = builder.startTime;
    }

    /**
     * Returns true if the HistoryRecords property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasHistoryRecords() {
        return historyRecords != null && !(historyRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the events in the history of the Spot Fleet request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHistoryRecords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the events in the history of the Spot Fleet request.
     */
    public final List<HistoryRecord> historyRecords() {
        return historyRecords;
    }

    /**
     * <p>
     * The last date and time for the events, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). All records up to this time were retrieved.
     * </p>
     * <p>
     * If <code>nextToken</code> indicates that there are more results, this value is not present.
     * </p>
     * 
     * @return The last date and time for the events, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). All records up to this time were
     *         retrieved.</p>
     *         <p>
     *         If <code>nextToken</code> indicates that there are more results, this value is not present.
     */
    public final Instant lastEvaluatedTime() {
        return lastEvaluatedTime;
    }

    /**
     * <p>
     * The token required to retrieve the next set of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token required to retrieve the next set of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the Spot Fleet request.
     * </p>
     * 
     * @return The ID of the Spot Fleet request.
     */
    public final String spotFleetRequestId() {
        return spotFleetRequestId;
    }

    /**
     * <p>
     * The starting date and time for the events, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     * </p>
     * 
     * @return The starting date and time for the events, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     */
    public final Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHistoryRecords() ? historyRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastEvaluatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetRequestHistoryResponse)) {
            return false;
        }
        DescribeSpotFleetRequestHistoryResponse other = (DescribeSpotFleetRequestHistoryResponse) obj;
        return hasHistoryRecords() == other.hasHistoryRecords() && Objects.equals(historyRecords(), other.historyRecords())
                && Objects.equals(lastEvaluatedTime(), other.lastEvaluatedTime())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(spotFleetRequestId(), other.spotFleetRequestId())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSpotFleetRequestHistoryResponse")
                .add("HistoryRecords", hasHistoryRecords() ? historyRecords() : null)
                .add("LastEvaluatedTime", lastEvaluatedTime()).add("NextToken", nextToken())
                .add("SpotFleetRequestId", spotFleetRequestId()).add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HistoryRecords":
            return Optional.ofNullable(clazz.cast(historyRecords()));
        case "LastEvaluatedTime":
            return Optional.ofNullable(clazz.cast(lastEvaluatedTime()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SpotFleetRequestId":
            return Optional.ofNullable(clazz.cast(spotFleetRequestId()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpotFleetRequestHistoryResponse, T> g) {
        return obj -> g.apply((DescribeSpotFleetRequestHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSpotFleetRequestHistoryResponse> {
        /**
         * <p>
         * Information about the events in the history of the Spot Fleet request.
         * </p>
         * 
         * @param historyRecords
         *        Information about the events in the history of the Spot Fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historyRecords(Collection<HistoryRecord> historyRecords);

        /**
         * <p>
         * Information about the events in the history of the Spot Fleet request.
         * </p>
         * 
         * @param historyRecords
         *        Information about the events in the history of the Spot Fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historyRecords(HistoryRecord... historyRecords);

        /**
         * <p>
         * Information about the events in the history of the Spot Fleet request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HistoryRecord>.Builder} avoiding the need
         * to create one manually via {@link List<HistoryRecord>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HistoryRecord>.Builder#build()} is called immediately and
         * its result is passed to {@link #historyRecords(List<HistoryRecord>)}.
         * 
         * @param historyRecords
         *        a consumer that will call methods on {@link List<HistoryRecord>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #historyRecords(List<HistoryRecord>)
         */
        Builder historyRecords(Consumer<HistoryRecord.Builder>... historyRecords);

        /**
         * <p>
         * The last date and time for the events, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). All records up to this time were retrieved.
         * </p>
         * <p>
         * If <code>nextToken</code> indicates that there are more results, this value is not present.
         * </p>
         * 
         * @param lastEvaluatedTime
         *        The last date and time for the events, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). All records up to this time were
         *        retrieved.</p>
         *        <p>
         *        If <code>nextToken</code> indicates that there are more results, this value is not present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluatedTime(Instant lastEvaluatedTime);

        /**
         * <p>
         * The token required to retrieve the next set of results. This value is <code>null</code> when there are no
         * more results to return.
         * </p>
         * 
         * @param nextToken
         *        The token required to retrieve the next set of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the Spot Fleet request.
         * </p>
         * 
         * @param spotFleetRequestId
         *        The ID of the Spot Fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestId(String spotFleetRequestId);

        /**
         * <p>
         * The starting date and time for the events, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * </p>
         * 
         * @param startTime
         *        The starting date and time for the events, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<HistoryRecord> historyRecords = DefaultSdkAutoConstructList.getInstance();

        private Instant lastEvaluatedTime;

        private String nextToken;

        private String spotFleetRequestId;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetRequestHistoryResponse model) {
            super(model);
            historyRecords(model.historyRecords);
            lastEvaluatedTime(model.lastEvaluatedTime);
            nextToken(model.nextToken);
            spotFleetRequestId(model.spotFleetRequestId);
            startTime(model.startTime);
        }

        public final List<HistoryRecord.Builder> getHistoryRecords() {
            List<HistoryRecord.Builder> result = HistoryRecordsCopier.copyToBuilder(this.historyRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder historyRecords(Collection<HistoryRecord> historyRecords) {
            this.historyRecords = HistoryRecordsCopier.copy(historyRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historyRecords(HistoryRecord... historyRecords) {
            historyRecords(Arrays.asList(historyRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historyRecords(Consumer<HistoryRecord.Builder>... historyRecords) {
            historyRecords(Stream.of(historyRecords).map(c -> HistoryRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setHistoryRecords(Collection<HistoryRecord.BuilderImpl> historyRecords) {
            this.historyRecords = HistoryRecordsCopier.copyFromBuilder(historyRecords);
        }

        public final Instant getLastEvaluatedTime() {
            return lastEvaluatedTime;
        }

        @Override
        public final Builder lastEvaluatedTime(Instant lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
            return this;
        }

        public final void setLastEvaluatedTime(Instant lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getSpotFleetRequestId() {
            return spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public DescribeSpotFleetRequestHistoryResponse build() {
            return new DescribeSpotFleetRequestHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
