/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrafficMirrorSessionResponse extends Ec2Response implements
        ToCopyableBuilder<CreateTrafficMirrorSessionResponse.Builder, CreateTrafficMirrorSessionResponse> {
    private static final SdkField<TrafficMirrorSession> TRAFFIC_MIRROR_SESSION_FIELD = SdkField
            .<TrafficMirrorSession> builder(MarshallingType.SDK_POJO)
            .memberName("TrafficMirrorSession")
            .getter(getter(CreateTrafficMirrorSessionResponse::trafficMirrorSession))
            .setter(setter(Builder::trafficMirrorSession))
            .constructor(TrafficMirrorSession::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorSession")
                    .unmarshallLocationName("trafficMirrorSession").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateTrafficMirrorSessionResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_SESSION_FIELD,
            CLIENT_TOKEN_FIELD));

    private final TrafficMirrorSession trafficMirrorSession;

    private final String clientToken;

    private CreateTrafficMirrorSessionResponse(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorSession = builder.trafficMirrorSession;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Information about the Traffic Mirror session.
     * </p>
     * 
     * @return Information about the Traffic Mirror session.
     */
    public final TrafficMirrorSession trafficMirrorSession() {
        return trafficMirrorSession;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorSession());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficMirrorSessionResponse)) {
            return false;
        }
        CreateTrafficMirrorSessionResponse other = (CreateTrafficMirrorSessionResponse) obj;
        return Objects.equals(trafficMirrorSession(), other.trafficMirrorSession())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrafficMirrorSessionResponse").add("TrafficMirrorSession", trafficMirrorSession())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorSession":
            return Optional.ofNullable(clazz.cast(trafficMirrorSession()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficMirrorSessionResponse, T> g) {
        return obj -> g.apply((CreateTrafficMirrorSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrafficMirrorSessionResponse> {
        /**
         * <p>
         * Information about the Traffic Mirror session.
         * </p>
         * 
         * @param trafficMirrorSession
         *        Information about the Traffic Mirror session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorSession(TrafficMirrorSession trafficMirrorSession);

        /**
         * <p>
         * Information about the Traffic Mirror session.
         * </p>
         * This is a convenience that creates an instance of the {@link TrafficMirrorSession.Builder} avoiding the need
         * to create one manually via {@link TrafficMirrorSession#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficMirrorSession.Builder#build()} is called immediately and
         * its result is passed to {@link #trafficMirrorSession(TrafficMirrorSession)}.
         * 
         * @param trafficMirrorSession
         *        a consumer that will call methods on {@link TrafficMirrorSession.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficMirrorSession(TrafficMirrorSession)
         */
        default Builder trafficMirrorSession(Consumer<TrafficMirrorSession.Builder> trafficMirrorSession) {
            return trafficMirrorSession(TrafficMirrorSession.builder().applyMutation(trafficMirrorSession).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to
         *        Ensure Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TrafficMirrorSession trafficMirrorSession;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficMirrorSessionResponse model) {
            super(model);
            trafficMirrorSession(model.trafficMirrorSession);
            clientToken(model.clientToken);
        }

        public final TrafficMirrorSession.Builder getTrafficMirrorSession() {
            return trafficMirrorSession != null ? trafficMirrorSession.toBuilder() : null;
        }

        @Override
        public final Builder trafficMirrorSession(TrafficMirrorSession trafficMirrorSession) {
            this.trafficMirrorSession = trafficMirrorSession;
            return this;
        }

        public final void setTrafficMirrorSession(TrafficMirrorSession.BuilderImpl trafficMirrorSession) {
            this.trafficMirrorSession = trafficMirrorSession != null ? trafficMirrorSession.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public CreateTrafficMirrorSessionResponse build() {
            return new CreateTrafficMirrorSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
