/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CancelSpotFleetRequests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelSpotFleetRequestsResponse extends Ec2Response implements
        ToCopyableBuilder<CancelSpotFleetRequestsResponse.Builder, CancelSpotFleetRequestsResponse> {
    private static final SdkField<List<CancelSpotFleetRequestsSuccessItem>> SUCCESSFUL_FLEET_REQUESTS_FIELD = SdkField
            .<List<CancelSpotFleetRequestsSuccessItem>> builder(MarshallingType.LIST)
            .memberName("SuccessfulFleetRequests")
            .getter(getter(CancelSpotFleetRequestsResponse::successfulFleetRequests))
            .setter(setter(Builder::successfulFleetRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulFleetRequestSet")
                    .unmarshallLocationName("successfulFleetRequestSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CancelSpotFleetRequestsSuccessItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CancelSpotFleetRequestsSuccessItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<CancelSpotFleetRequestsErrorItem>> UNSUCCESSFUL_FLEET_REQUESTS_FIELD = SdkField
            .<List<CancelSpotFleetRequestsErrorItem>> builder(MarshallingType.LIST)
            .memberName("UnsuccessfulFleetRequests")
            .getter(getter(CancelSpotFleetRequestsResponse::unsuccessfulFleetRequests))
            .setter(setter(Builder::unsuccessfulFleetRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsuccessfulFleetRequestSet")
                    .unmarshallLocationName("unsuccessfulFleetRequestSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CancelSpotFleetRequestsErrorItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CancelSpotFleetRequestsErrorItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUCCESSFUL_FLEET_REQUESTS_FIELD, UNSUCCESSFUL_FLEET_REQUESTS_FIELD));

    private final List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests;

    private final List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests;

    private CancelSpotFleetRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.successfulFleetRequests = builder.successfulFleetRequests;
        this.unsuccessfulFleetRequests = builder.unsuccessfulFleetRequests;
    }

    /**
     * Returns true if the SuccessfulFleetRequests property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSuccessfulFleetRequests() {
        return successfulFleetRequests != null && !(successfulFleetRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Spot Fleet requests that are successfully canceled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuccessfulFleetRequests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the Spot Fleet requests that are successfully canceled.
     */
    public final List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests() {
        return successfulFleetRequests;
    }

    /**
     * Returns true if the UnsuccessfulFleetRequests property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUnsuccessfulFleetRequests() {
        return unsuccessfulFleetRequests != null && !(unsuccessfulFleetRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Spot Fleet requests that are not successfully canceled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnsuccessfulFleetRequests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the Spot Fleet requests that are not successfully canceled.
     */
    public final List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests() {
        return unsuccessfulFleetRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessfulFleetRequests() ? successfulFleetRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnsuccessfulFleetRequests() ? unsuccessfulFleetRequests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsResponse)) {
            return false;
        }
        CancelSpotFleetRequestsResponse other = (CancelSpotFleetRequestsResponse) obj;
        return hasSuccessfulFleetRequests() == other.hasSuccessfulFleetRequests()
                && Objects.equals(successfulFleetRequests(), other.successfulFleetRequests())
                && hasUnsuccessfulFleetRequests() == other.hasUnsuccessfulFleetRequests()
                && Objects.equals(unsuccessfulFleetRequests(), other.unsuccessfulFleetRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelSpotFleetRequestsResponse")
                .add("SuccessfulFleetRequests", hasSuccessfulFleetRequests() ? successfulFleetRequests() : null)
                .add("UnsuccessfulFleetRequests", hasUnsuccessfulFleetRequests() ? unsuccessfulFleetRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessfulFleetRequests":
            return Optional.ofNullable(clazz.cast(successfulFleetRequests()));
        case "UnsuccessfulFleetRequests":
            return Optional.ofNullable(clazz.cast(unsuccessfulFleetRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelSpotFleetRequestsResponse, T> g) {
        return obj -> g.apply((CancelSpotFleetRequestsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CancelSpotFleetRequestsResponse> {
        /**
         * <p>
         * Information about the Spot Fleet requests that are successfully canceled.
         * </p>
         * 
         * @param successfulFleetRequests
         *        Information about the Spot Fleet requests that are successfully canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulFleetRequests(Collection<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests);

        /**
         * <p>
         * Information about the Spot Fleet requests that are successfully canceled.
         * </p>
         * 
         * @param successfulFleetRequests
         *        Information about the Spot Fleet requests that are successfully canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulFleetRequests(CancelSpotFleetRequestsSuccessItem... successfulFleetRequests);

        /**
         * <p>
         * Information about the Spot Fleet requests that are successfully canceled.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <CancelSpotFleetRequestsSuccessItem>.Builder} avoiding the need to create one manually via {@link List
         * <CancelSpotFleetRequestsSuccessItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CancelSpotFleetRequestsSuccessItem>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #successfulFleetRequests(List<CancelSpotFleetRequestsSuccessItem>)}.
         * 
         * @param successfulFleetRequests
         *        a consumer that will call methods on {@link List<CancelSpotFleetRequestsSuccessItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfulFleetRequests(List<CancelSpotFleetRequestsSuccessItem>)
         */
        Builder successfulFleetRequests(Consumer<CancelSpotFleetRequestsSuccessItem.Builder>... successfulFleetRequests);

        /**
         * <p>
         * Information about the Spot Fleet requests that are not successfully canceled.
         * </p>
         * 
         * @param unsuccessfulFleetRequests
         *        Information about the Spot Fleet requests that are not successfully canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulFleetRequests(Collection<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests);

        /**
         * <p>
         * Information about the Spot Fleet requests that are not successfully canceled.
         * </p>
         * 
         * @param unsuccessfulFleetRequests
         *        Information about the Spot Fleet requests that are not successfully canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulFleetRequests(CancelSpotFleetRequestsErrorItem... unsuccessfulFleetRequests);

        /**
         * <p>
         * Information about the Spot Fleet requests that are not successfully canceled.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CancelSpotFleetRequestsErrorItem>.Builder}
         * avoiding the need to create one manually via {@link List<CancelSpotFleetRequestsErrorItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CancelSpotFleetRequestsErrorItem>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #unsuccessfulFleetRequests(List<CancelSpotFleetRequestsErrorItem>)}.
         * 
         * @param unsuccessfulFleetRequests
         *        a consumer that will call methods on {@link List<CancelSpotFleetRequestsErrorItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsuccessfulFleetRequests(List<CancelSpotFleetRequestsErrorItem>)
         */
        Builder unsuccessfulFleetRequests(Consumer<CancelSpotFleetRequestsErrorItem.Builder>... unsuccessfulFleetRequests);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests = DefaultSdkAutoConstructList.getInstance();

        private List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsResponse model) {
            super(model);
            successfulFleetRequests(model.successfulFleetRequests);
            unsuccessfulFleetRequests(model.unsuccessfulFleetRequests);
        }

        public final List<CancelSpotFleetRequestsSuccessItem.Builder> getSuccessfulFleetRequests() {
            List<CancelSpotFleetRequestsSuccessItem.Builder> result = CancelSpotFleetRequestsSuccessSetCopier
                    .copyToBuilder(this.successfulFleetRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder successfulFleetRequests(Collection<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests) {
            this.successfulFleetRequests = CancelSpotFleetRequestsSuccessSetCopier.copy(successfulFleetRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulFleetRequests(CancelSpotFleetRequestsSuccessItem... successfulFleetRequests) {
            successfulFleetRequests(Arrays.asList(successfulFleetRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulFleetRequests(
                Consumer<CancelSpotFleetRequestsSuccessItem.Builder>... successfulFleetRequests) {
            successfulFleetRequests(Stream.of(successfulFleetRequests)
                    .map(c -> CancelSpotFleetRequestsSuccessItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessfulFleetRequests(
                Collection<CancelSpotFleetRequestsSuccessItem.BuilderImpl> successfulFleetRequests) {
            this.successfulFleetRequests = CancelSpotFleetRequestsSuccessSetCopier.copyFromBuilder(successfulFleetRequests);
        }

        public final List<CancelSpotFleetRequestsErrorItem.Builder> getUnsuccessfulFleetRequests() {
            List<CancelSpotFleetRequestsErrorItem.Builder> result = CancelSpotFleetRequestsErrorSetCopier
                    .copyToBuilder(this.unsuccessfulFleetRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder unsuccessfulFleetRequests(Collection<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests) {
            this.unsuccessfulFleetRequests = CancelSpotFleetRequestsErrorSetCopier.copy(unsuccessfulFleetRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFleetRequests(CancelSpotFleetRequestsErrorItem... unsuccessfulFleetRequests) {
            unsuccessfulFleetRequests(Arrays.asList(unsuccessfulFleetRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFleetRequests(
                Consumer<CancelSpotFleetRequestsErrorItem.Builder>... unsuccessfulFleetRequests) {
            unsuccessfulFleetRequests(Stream.of(unsuccessfulFleetRequests)
                    .map(c -> CancelSpotFleetRequestsErrorItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnsuccessfulFleetRequests(
                Collection<CancelSpotFleetRequestsErrorItem.BuilderImpl> unsuccessfulFleetRequests) {
            this.unsuccessfulFleetRequests = CancelSpotFleetRequestsErrorSetCopier.copyFromBuilder(unsuccessfulFleetRequests);
        }

        @Override
        public CancelSpotFleetRequestsResponse build() {
            return new CancelSpotFleetRequestsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
