/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.VpnGatewayIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpnGatewaysRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeVpnGatewaysRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeVpnGatewaysRequest.getter(DescribeVpnGatewaysRequest::filters)).setter(DescribeVpnGatewaysRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPN_GATEWAY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpnGatewayIds").getter(DescribeVpnGatewaysRequest.getter(DescribeVpnGatewaysRequest::vpnGatewayIds)).setter(DescribeVpnGatewaysRequest.setter(Builder::vpnGatewayIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGatewayId").unmarshallLocationName("VpnGatewayId").build(), ListTrait.builder().memberLocationName("VpnGatewayId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGatewayId").unmarshallLocationName("VpnGatewayId").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, VPN_GATEWAY_IDS_FIELD));
    private final List<Filter> filters;
    private final List<String> vpnGatewayIds;

    private DescribeVpnGatewaysRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.vpnGatewayIds = builder.vpnGatewayIds;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final boolean hasVpnGatewayIds() {
        return this.vpnGatewayIds != null && !(this.vpnGatewayIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpnGatewayIds() {
        return this.vpnGatewayIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpnGatewayIds() ? this.vpnGatewayIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnGatewaysRequest)) {
            return false;
        }
        DescribeVpnGatewaysRequest other = (DescribeVpnGatewaysRequest)((Object)obj);
        return this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && this.hasVpnGatewayIds() == other.hasVpnGatewayIds() && Objects.equals(this.vpnGatewayIds(), other.vpnGatewayIds());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpnGatewaysRequest").add("Filters", this.hasFilters() ? this.filters() : null).add("VpnGatewayIds", this.hasVpnGatewayIds() ? this.vpnGatewayIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "VpnGatewayIds": {
                return Optional.ofNullable(clazz.cast(this.vpnGatewayIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpnGatewaysRequest, T> g) {
        return obj -> g.apply((DescribeVpnGatewaysRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpnGatewayIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnGatewaysRequest model) {
            super(model);
            this.filters(model.filters);
            this.vpnGatewayIds(model.vpnGatewayIds);
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getVpnGatewayIds() {
            if (this.vpnGatewayIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpnGatewayIds;
        }

        @Override
        public final Builder vpnGatewayIds(Collection<String> vpnGatewayIds) {
            this.vpnGatewayIds = VpnGatewayIdStringListCopier.copy(vpnGatewayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnGatewayIds(String ... vpnGatewayIds) {
            this.vpnGatewayIds(Arrays.asList(vpnGatewayIds));
            return this;
        }

        public final void setVpnGatewayIds(Collection<String> vpnGatewayIds) {
            this.vpnGatewayIds = VpnGatewayIdStringListCopier.copy(vpnGatewayIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVpnGatewaysRequest build() {
            return new DescribeVpnGatewaysRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpnGatewaysRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder vpnGatewayIds(Collection<String> var1);

        public Builder vpnGatewayIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

