/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerminateClientVpnConnectionsResponse extends Ec2Response implements
        ToCopyableBuilder<TerminateClientVpnConnectionsResponse.Builder, TerminateClientVpnConnectionsResponse> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientVpnEndpointId")
            .getter(getter(TerminateClientVpnConnectionsResponse::clientVpnEndpointId))
            .setter(setter(Builder::clientVpnEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId")
                    .unmarshallLocationName("clientVpnEndpointId").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Username")
            .getter(getter(TerminateClientVpnConnectionsResponse::username))
            .setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username")
                    .unmarshallLocationName("username").build()).build();

    private static final SdkField<List<TerminateConnectionStatus>> CONNECTION_STATUSES_FIELD = SdkField
            .<List<TerminateConnectionStatus>> builder(MarshallingType.LIST)
            .memberName("ConnectionStatuses")
            .getter(getter(TerminateClientVpnConnectionsResponse::connectionStatuses))
            .setter(setter(Builder::connectionStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatuses")
                    .unmarshallLocationName("connectionStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TerminateConnectionStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(TerminateConnectionStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD,
            USERNAME_FIELD, CONNECTION_STATUSES_FIELD));

    private final String clientVpnEndpointId;

    private final String username;

    private final List<TerminateConnectionStatus> connectionStatuses;

    private TerminateClientVpnConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.username = builder.username;
        this.connectionStatuses = builder.connectionStatuses;
    }

    /**
     * <p>
     * The ID of the Client VPN endpoint.
     * </p>
     * 
     * @return The ID of the Client VPN endpoint.
     */
    public final String clientVpnEndpointId() {
        return clientVpnEndpointId;
    }

    /**
     * <p>
     * The user who established the terminated client connections.
     * </p>
     * 
     * @return The user who established the terminated client connections.
     */
    public final String username() {
        return username;
    }

    /**
     * Returns true if the ConnectionStatuses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasConnectionStatuses() {
        return connectionStatuses != null && !(connectionStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The current state of the client connections.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConnectionStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The current state of the client connections.
     */
    public final List<TerminateConnectionStatus> connectionStatuses() {
        return connectionStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectionStatuses() ? connectionStatuses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateClientVpnConnectionsResponse)) {
            return false;
        }
        TerminateClientVpnConnectionsResponse other = (TerminateClientVpnConnectionsResponse) obj;
        return Objects.equals(clientVpnEndpointId(), other.clientVpnEndpointId()) && Objects.equals(username(), other.username())
                && hasConnectionStatuses() == other.hasConnectionStatuses()
                && Objects.equals(connectionStatuses(), other.connectionStatuses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TerminateClientVpnConnectionsResponse").add("ClientVpnEndpointId", clientVpnEndpointId())
                .add("Username", username()).add("ConnectionStatuses", hasConnectionStatuses() ? connectionStatuses() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVpnEndpointId":
            return Optional.ofNullable(clazz.cast(clientVpnEndpointId()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "ConnectionStatuses":
            return Optional.ofNullable(clazz.cast(connectionStatuses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminateClientVpnConnectionsResponse, T> g) {
        return obj -> g.apply((TerminateClientVpnConnectionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, TerminateClientVpnConnectionsResponse> {
        /**
         * <p>
         * The ID of the Client VPN endpoint.
         * </p>
         * 
         * @param clientVpnEndpointId
         *        The ID of the Client VPN endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpnEndpointId(String clientVpnEndpointId);

        /**
         * <p>
         * The user who established the terminated client connections.
         * </p>
         * 
         * @param username
         *        The user who established the terminated client connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The current state of the client connections.
         * </p>
         * 
         * @param connectionStatuses
         *        The current state of the client connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionStatuses(Collection<TerminateConnectionStatus> connectionStatuses);

        /**
         * <p>
         * The current state of the client connections.
         * </p>
         * 
         * @param connectionStatuses
         *        The current state of the client connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionStatuses(TerminateConnectionStatus... connectionStatuses);

        /**
         * <p>
         * The current state of the client connections.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TerminateConnectionStatus>.Builder}
         * avoiding the need to create one manually via {@link List<TerminateConnectionStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TerminateConnectionStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link #connectionStatuses(List<TerminateConnectionStatus>)}.
         * 
         * @param connectionStatuses
         *        a consumer that will call methods on {@link List<TerminateConnectionStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionStatuses(List<TerminateConnectionStatus>)
         */
        Builder connectionStatuses(Consumer<TerminateConnectionStatus.Builder>... connectionStatuses);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String clientVpnEndpointId;

        private String username;

        private List<TerminateConnectionStatus> connectionStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateClientVpnConnectionsResponse model) {
            super(model);
            clientVpnEndpointId(model.clientVpnEndpointId);
            username(model.username);
            connectionStatuses(model.connectionStatuses);
        }

        public final String getClientVpnEndpointId() {
            return clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final List<TerminateConnectionStatus.Builder> getConnectionStatuses() {
            List<TerminateConnectionStatus.Builder> result = TerminateConnectionStatusSetCopier
                    .copyToBuilder(this.connectionStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder connectionStatuses(Collection<TerminateConnectionStatus> connectionStatuses) {
            this.connectionStatuses = TerminateConnectionStatusSetCopier.copy(connectionStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionStatuses(TerminateConnectionStatus... connectionStatuses) {
            connectionStatuses(Arrays.asList(connectionStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionStatuses(Consumer<TerminateConnectionStatus.Builder>... connectionStatuses) {
            connectionStatuses(Stream.of(connectionStatuses)
                    .map(c -> TerminateConnectionStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConnectionStatuses(Collection<TerminateConnectionStatus.BuilderImpl> connectionStatuses) {
            this.connectionStatuses = TerminateConnectionStatusSetCopier.copyFromBuilder(connectionStatuses);
        }

        @Override
        public TerminateClientVpnConnectionsResponse build() {
            return new TerminateClientVpnConnectionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
