/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the launch specification for a Scheduled Instance.
 * </p>
 * <p>
 * If you are launching the Scheduled Instance in EC2-VPC, you must specify the ID of the subnet. You can specify the
 * subnet using either <code>SubnetId</code> or <code>NetworkInterface</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledInstancesLaunchSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledInstancesLaunchSpecification.Builder, ScheduledInstancesLaunchSpecification> {
    private static final SdkField<List<ScheduledInstancesBlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<ScheduledInstancesBlockDeviceMapping>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(ScheduledInstancesLaunchSpecification::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping")
                    .unmarshallLocationName("BlockDeviceMapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("BlockDeviceMapping")
                            .memberFieldInfo(
                                    SdkField.<ScheduledInstancesBlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduledInstancesBlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("BlockDeviceMapping")
                                                    .unmarshallLocationName("BlockDeviceMapping").build()).build()).build())
            .build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized")
            .getter(getter(ScheduledInstancesLaunchSpecification::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized")
                    .unmarshallLocationName("EbsOptimized").build()).build();

    private static final SdkField<ScheduledInstancesIamInstanceProfile> IAM_INSTANCE_PROFILE_FIELD = SdkField
            .<ScheduledInstancesIamInstanceProfile> builder(MarshallingType.SDK_POJO)
            .memberName("IamInstanceProfile")
            .getter(getter(ScheduledInstancesLaunchSpecification::iamInstanceProfile))
            .setter(setter(Builder::iamInstanceProfile))
            .constructor(ScheduledInstancesIamInstanceProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile")
                    .unmarshallLocationName("IamInstanceProfile").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(ScheduledInstancesLaunchSpecification::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("ImageId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(ScheduledInstancesLaunchSpecification::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("InstanceType").build()).build();

    private static final SdkField<String> KERNEL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KernelId")
            .getter(getter(ScheduledInstancesLaunchSpecification::kernelId))
            .setter(setter(Builder::kernelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId")
                    .unmarshallLocationName("KernelId").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KeyName")
            .getter(getter(ScheduledInstancesLaunchSpecification::keyName))
            .setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName")
                    .unmarshallLocationName("KeyName").build()).build();

    private static final SdkField<ScheduledInstancesMonitoring> MONITORING_FIELD = SdkField
            .<ScheduledInstancesMonitoring> builder(MarshallingType.SDK_POJO)
            .memberName("Monitoring")
            .getter(getter(ScheduledInstancesLaunchSpecification::monitoring))
            .setter(setter(Builder::monitoring))
            .constructor(ScheduledInstancesMonitoring::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring")
                    .unmarshallLocationName("Monitoring").build()).build();

    private static final SdkField<List<ScheduledInstancesNetworkInterface>> NETWORK_INTERFACES_FIELD = SdkField
            .<List<ScheduledInstancesNetworkInterface>> builder(MarshallingType.LIST)
            .memberName("NetworkInterfaces")
            .getter(getter(ScheduledInstancesLaunchSpecification::networkInterfaces))
            .setter(setter(Builder::networkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterface")
                    .unmarshallLocationName("NetworkInterface").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("NetworkInterface")
                            .memberFieldInfo(
                                    SdkField.<ScheduledInstancesNetworkInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduledInstancesNetworkInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("NetworkInterface").unmarshallLocationName("NetworkInterface")
                                                    .build()).build()).build()).build();

    private static final SdkField<ScheduledInstancesPlacement> PLACEMENT_FIELD = SdkField
            .<ScheduledInstancesPlacement> builder(MarshallingType.SDK_POJO)
            .memberName("Placement")
            .getter(getter(ScheduledInstancesLaunchSpecification::placement))
            .setter(setter(Builder::placement))
            .constructor(ScheduledInstancesPlacement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement")
                    .unmarshallLocationName("Placement").build()).build();

    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RamdiskId")
            .getter(getter(ScheduledInstancesLaunchSpecification::ramdiskId))
            .setter(setter(Builder::ramdiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId")
                    .unmarshallLocationName("RamdiskId").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(ScheduledInstancesLaunchSpecification::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId")
                    .unmarshallLocationName("SecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId")
                                                    .build()).build()).build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(ScheduledInstancesLaunchSpecification::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("SubnetId").build()).build();

    private static final SdkField<String> USER_DATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UserData")
            .getter(getter(ScheduledInstancesLaunchSpecification::userData))
            .setter(setter(Builder::userData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData")
                    .unmarshallLocationName("UserData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_DEVICE_MAPPINGS_FIELD,
            EBS_OPTIMIZED_FIELD, IAM_INSTANCE_PROFILE_FIELD, IMAGE_ID_FIELD, INSTANCE_TYPE_FIELD, KERNEL_ID_FIELD,
            KEY_NAME_FIELD, MONITORING_FIELD, NETWORK_INTERFACES_FIELD, PLACEMENT_FIELD, RAMDISK_ID_FIELD,
            SECURITY_GROUP_IDS_FIELD, SUBNET_ID_FIELD, USER_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings;

    private final Boolean ebsOptimized;

    private final ScheduledInstancesIamInstanceProfile iamInstanceProfile;

    private final String imageId;

    private final String instanceType;

    private final String kernelId;

    private final String keyName;

    private final ScheduledInstancesMonitoring monitoring;

    private final List<ScheduledInstancesNetworkInterface> networkInterfaces;

    private final ScheduledInstancesPlacement placement;

    private final String ramdiskId;

    private final List<String> securityGroupIds;

    private final String subnetId;

    private final String userData;

    private ScheduledInstancesLaunchSpecification(BuilderImpl builder) {
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.networkInterfaces = builder.networkInterfaces;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
    }

    /**
     * Returns true if the BlockDeviceMappings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The block device mapping entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBlockDeviceMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The block device mapping entries.
     */
    public final List<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to
     * Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't
     * available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated
     *         throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance.
     *         This optimization isn't available with all instance types. Additional usage charges apply when using an
     *         EBS-optimized instance.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The IAM instance profile.
     * </p>
     * 
     * @return The IAM instance profile.
     */
    public final ScheduledInstancesIamInstanceProfile iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI).
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI).
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * 
     * @return The instance type.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the kernel.
     * </p>
     * 
     * @return The ID of the kernel.
     */
    public final String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The name of the key pair.
     * </p>
     * 
     * @return The name of the key pair.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * Enable or disable monitoring for the instances.
     * </p>
     * 
     * @return Enable or disable monitoring for the instances.
     */
    public final ScheduledInstancesMonitoring monitoring() {
        return monitoring;
    }

    /**
     * Returns true if the NetworkInterfaces property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasNetworkInterfaces() {
        return networkInterfaces != null && !(networkInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkInterfaces()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The network interfaces.
     */
    public final List<ScheduledInstancesNetworkInterface> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * The placement information.
     * </p>
     * 
     * @return The placement information.
     */
    public final ScheduledInstancesPlacement placement() {
        return placement;
    }

    /**
     * <p>
     * The ID of the RAM disk.
     * </p>
     * 
     * @return The ID of the RAM disk.
     */
    public final String ramdiskId() {
        return ramdiskId;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the security groups.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The ID of the subnet in which to launch the instances.
     * </p>
     * 
     * @return The ID of the subnet in which to launch the instances.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The base64-encoded MIME user data.
     * </p>
     * 
     * @return The base64-encoded MIME user data.
     */
    public final String userData() {
        return userData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfaces() ? networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstancesLaunchSpecification)) {
            return false;
        }
        ScheduledInstancesLaunchSpecification other = (ScheduledInstancesLaunchSpecification) obj;
        return hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(kernelId(), other.kernelId())
                && Objects.equals(keyName(), other.keyName()) && Objects.equals(monitoring(), other.monitoring())
                && hasNetworkInterfaces() == other.hasNetworkInterfaces()
                && Objects.equals(networkInterfaces(), other.networkInterfaces())
                && Objects.equals(placement(), other.placement()) && Objects.equals(ramdiskId(), other.ramdiskId())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(userData(), other.userData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledInstancesLaunchSpecification")
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null)
                .add("EbsOptimized", ebsOptimized()).add("IamInstanceProfile", iamInstanceProfile()).add("ImageId", imageId())
                .add("InstanceType", instanceType()).add("KernelId", kernelId()).add("KeyName", keyName())
                .add("Monitoring", monitoring()).add("NetworkInterfaces", hasNetworkInterfaces() ? networkInterfaces() : null)
                .add("Placement", placement()).add("RamdiskId", ramdiskId())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).add("SubnetId", subnetId())
                .add("UserData", userData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "IamInstanceProfile":
            return Optional.ofNullable(clazz.cast(iamInstanceProfile()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "Monitoring":
            return Optional.ofNullable(clazz.cast(monitoring()));
        case "NetworkInterfaces":
            return Optional.ofNullable(clazz.cast(networkInterfaces()));
        case "Placement":
            return Optional.ofNullable(clazz.cast(placement()));
        case "RamdiskId":
            return Optional.ofNullable(clazz.cast(ramdiskId()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "UserData":
            return Optional.ofNullable(clazz.cast(userData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledInstancesLaunchSpecification, T> g) {
        return obj -> g.apply((ScheduledInstancesLaunchSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledInstancesLaunchSpecification> {
        /**
         * <p>
         * The block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * The block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(ScheduledInstancesBlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The block device mapping entries.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ScheduledInstancesBlockDeviceMapping>.Builder} avoiding the need to create one manually via {@link List
         * <ScheduledInstancesBlockDeviceMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScheduledInstancesBlockDeviceMapping>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #blockDeviceMappings(List<ScheduledInstancesBlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on {@link List<ScheduledInstancesBlockDeviceMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(List<ScheduledInstancesBlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<ScheduledInstancesBlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to
         * Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization
         * isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated
         *        throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance.
         *        This optimization isn't available with all instance types. Additional usage charges apply when using
         *        an EBS-optimized instance.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The IAM instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(ScheduledInstancesIamInstanceProfile iamInstanceProfile);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduledInstancesIamInstanceProfile.Builder}
         * avoiding the need to create one manually via {@link ScheduledInstancesIamInstanceProfile#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduledInstancesIamInstanceProfile.Builder#build()} is called
         * immediately and its result is passed to {@link #iamInstanceProfile(ScheduledInstancesIamInstanceProfile)}.
         * 
         * @param iamInstanceProfile
         *        a consumer that will call methods on {@link ScheduledInstancesIamInstanceProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfile(ScheduledInstancesIamInstanceProfile)
         */
        default Builder iamInstanceProfile(Consumer<ScheduledInstancesIamInstanceProfile.Builder> iamInstanceProfile) {
            return iamInstanceProfile(ScheduledInstancesIamInstanceProfile.builder().applyMutation(iamInstanceProfile).build());
        }

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI).
         * </p>
         * 
         * @param imageId
         *        The ID of the Amazon Machine Image (AMI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ID of the kernel.
         * </p>
         * 
         * @param kernelId
         *        The ID of the kernel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The name of the key pair.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * Enable or disable monitoring for the instances.
         * </p>
         * 
         * @param monitoring
         *        Enable or disable monitoring for the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(ScheduledInstancesMonitoring monitoring);

        /**
         * <p>
         * Enable or disable monitoring for the instances.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduledInstancesMonitoring.Builder} avoiding
         * the need to create one manually via {@link ScheduledInstancesMonitoring#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduledInstancesMonitoring.Builder#build()} is called
         * immediately and its result is passed to {@link #monitoring(ScheduledInstancesMonitoring)}.
         * 
         * @param monitoring
         *        a consumer that will call methods on {@link ScheduledInstancesMonitoring.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoring(ScheduledInstancesMonitoring)
         */
        default Builder monitoring(Consumer<ScheduledInstancesMonitoring.Builder> monitoring) {
            return monitoring(ScheduledInstancesMonitoring.builder().applyMutation(monitoring).build());
        }

        /**
         * <p>
         * The network interfaces.
         * </p>
         * 
         * @param networkInterfaces
         *        The network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<ScheduledInstancesNetworkInterface> networkInterfaces);

        /**
         * <p>
         * The network interfaces.
         * </p>
         * 
         * @param networkInterfaces
         *        The network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(ScheduledInstancesNetworkInterface... networkInterfaces);

        /**
         * <p>
         * The network interfaces.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ScheduledInstancesNetworkInterface>.Builder} avoiding the need to create one manually via {@link List
         * <ScheduledInstancesNetworkInterface>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScheduledInstancesNetworkInterface>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #networkInterfaces(List<ScheduledInstancesNetworkInterface>)}.
         * 
         * @param networkInterfaces
         *        a consumer that will call methods on {@link List<ScheduledInstancesNetworkInterface>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfaces(List<ScheduledInstancesNetworkInterface>)
         */
        Builder networkInterfaces(Consumer<ScheduledInstancesNetworkInterface.Builder>... networkInterfaces);

        /**
         * <p>
         * The placement information.
         * </p>
         * 
         * @param placement
         *        The placement information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(ScheduledInstancesPlacement placement);

        /**
         * <p>
         * The placement information.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduledInstancesPlacement.Builder} avoiding
         * the need to create one manually via {@link ScheduledInstancesPlacement#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduledInstancesPlacement.Builder#build()} is called
         * immediately and its result is passed to {@link #placement(ScheduledInstancesPlacement)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link ScheduledInstancesPlacement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(ScheduledInstancesPlacement)
         */
        default Builder placement(Consumer<ScheduledInstancesPlacement.Builder> placement) {
            return placement(ScheduledInstancesPlacement.builder().applyMutation(placement).build());
        }

        /**
         * <p>
         * The ID of the RAM disk.
         * </p>
         * 
         * @param ramdiskId
         *        The ID of the RAM disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The IDs of the security groups.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The IDs of the security groups.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The ID of the subnet in which to launch the instances.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet in which to launch the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The base64-encoded MIME user data.
         * </p>
         * 
         * @param userData
         *        The base64-encoded MIME user data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);
    }

    static final class BuilderImpl implements Builder {
        private List<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private Boolean ebsOptimized;

        private ScheduledInstancesIamInstanceProfile iamInstanceProfile;

        private String imageId;

        private String instanceType;

        private String kernelId;

        private String keyName;

        private ScheduledInstancesMonitoring monitoring;

        private List<ScheduledInstancesNetworkInterface> networkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private ScheduledInstancesPlacement placement;

        private String ramdiskId;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String subnetId;

        private String userData;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstancesLaunchSpecification model) {
            blockDeviceMappings(model.blockDeviceMappings);
            ebsOptimized(model.ebsOptimized);
            iamInstanceProfile(model.iamInstanceProfile);
            imageId(model.imageId);
            instanceType(model.instanceType);
            kernelId(model.kernelId);
            keyName(model.keyName);
            monitoring(model.monitoring);
            networkInterfaces(model.networkInterfaces);
            placement(model.placement);
            ramdiskId(model.ramdiskId);
            securityGroupIds(model.securityGroupIds);
            subnetId(model.subnetId);
            userData(model.userData);
        }

        public final List<ScheduledInstancesBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<ScheduledInstancesBlockDeviceMapping.Builder> result = ScheduledInstancesBlockDeviceMappingSetCopier
                    .copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = ScheduledInstancesBlockDeviceMappingSetCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(ScheduledInstancesBlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<ScheduledInstancesBlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings)
                    .map(c -> ScheduledInstancesBlockDeviceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<ScheduledInstancesBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = ScheduledInstancesBlockDeviceMappingSetCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final ScheduledInstancesIamInstanceProfile.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(ScheduledInstancesIamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(ScheduledInstancesIamInstanceProfile.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final ScheduledInstancesMonitoring.Builder getMonitoring() {
            return monitoring != null ? monitoring.toBuilder() : null;
        }

        @Override
        public final Builder monitoring(ScheduledInstancesMonitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(ScheduledInstancesMonitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        public final List<ScheduledInstancesNetworkInterface.Builder> getNetworkInterfaces() {
            List<ScheduledInstancesNetworkInterface.Builder> result = ScheduledInstancesNetworkInterfaceSetCopier
                    .copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder networkInterfaces(Collection<ScheduledInstancesNetworkInterface> networkInterfaces) {
            this.networkInterfaces = ScheduledInstancesNetworkInterfaceSetCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(ScheduledInstancesNetworkInterface... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<ScheduledInstancesNetworkInterface.Builder>... networkInterfaces) {
            networkInterfaces(Stream.of(networkInterfaces)
                    .map(c -> ScheduledInstancesNetworkInterface.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInterfaces(Collection<ScheduledInstancesNetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = ScheduledInstancesNetworkInterfaceSetCopier.copyFromBuilder(networkInterfaces);
        }

        public final ScheduledInstancesPlacement.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(ScheduledInstancesPlacement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(ScheduledInstancesPlacement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ScheduledInstancesSecurityGroupIdSetCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ScheduledInstancesSecurityGroupIdSetCopier.copy(securityGroupIds);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public ScheduledInstancesLaunchSpecification build() {
            return new ScheduledInstancesLaunchSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
