/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The market (purchasing) option for the instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchTemplateInstanceMarketOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchTemplateInstanceMarketOptions.Builder, LaunchTemplateInstanceMarketOptions> {
    private static final SdkField<String> MARKET_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MarketType")
            .getter(getter(LaunchTemplateInstanceMarketOptions::marketTypeAsString))
            .setter(setter(Builder::marketType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarketType")
                    .unmarshallLocationName("marketType").build()).build();

    private static final SdkField<LaunchTemplateSpotMarketOptions> SPOT_OPTIONS_FIELD = SdkField
            .<LaunchTemplateSpotMarketOptions> builder(MarshallingType.SDK_POJO)
            .memberName("SpotOptions")
            .getter(getter(LaunchTemplateInstanceMarketOptions::spotOptions))
            .setter(setter(Builder::spotOptions))
            .constructor(LaunchTemplateSpotMarketOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotOptions")
                    .unmarshallLocationName("spotOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKET_TYPE_FIELD,
            SPOT_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String marketType;

    private final LaunchTemplateSpotMarketOptions spotOptions;

    private LaunchTemplateInstanceMarketOptions(BuilderImpl builder) {
        this.marketType = builder.marketType;
        this.spotOptions = builder.spotOptions;
    }

    /**
     * <p>
     * The market type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #marketType} will
     * return {@link MarketType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #marketTypeAsString}.
     * </p>
     * 
     * @return The market type.
     * @see MarketType
     */
    public final MarketType marketType() {
        return MarketType.fromValue(marketType);
    }

    /**
     * <p>
     * The market type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #marketType} will
     * return {@link MarketType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #marketTypeAsString}.
     * </p>
     * 
     * @return The market type.
     * @see MarketType
     */
    public final String marketTypeAsString() {
        return marketType;
    }

    /**
     * <p>
     * The options for Spot Instances.
     * </p>
     * 
     * @return The options for Spot Instances.
     */
    public final LaunchTemplateSpotMarketOptions spotOptions() {
        return spotOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marketTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spotOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateInstanceMarketOptions)) {
            return false;
        }
        LaunchTemplateInstanceMarketOptions other = (LaunchTemplateInstanceMarketOptions) obj;
        return Objects.equals(marketTypeAsString(), other.marketTypeAsString())
                && Objects.equals(spotOptions(), other.spotOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchTemplateInstanceMarketOptions").add("MarketType", marketTypeAsString())
                .add("SpotOptions", spotOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MarketType":
            return Optional.ofNullable(clazz.cast(marketTypeAsString()));
        case "SpotOptions":
            return Optional.ofNullable(clazz.cast(spotOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateInstanceMarketOptions, T> g) {
        return obj -> g.apply((LaunchTemplateInstanceMarketOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchTemplateInstanceMarketOptions> {
        /**
         * <p>
         * The market type.
         * </p>
         * 
         * @param marketType
         *        The market type.
         * @see MarketType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MarketType
         */
        Builder marketType(String marketType);

        /**
         * <p>
         * The market type.
         * </p>
         * 
         * @param marketType
         *        The market type.
         * @see MarketType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MarketType
         */
        Builder marketType(MarketType marketType);

        /**
         * <p>
         * The options for Spot Instances.
         * </p>
         * 
         * @param spotOptions
         *        The options for Spot Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotOptions(LaunchTemplateSpotMarketOptions spotOptions);

        /**
         * <p>
         * The options for Spot Instances.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplateSpotMarketOptions.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplateSpotMarketOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateSpotMarketOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #spotOptions(LaunchTemplateSpotMarketOptions)}.
         * 
         * @param spotOptions
         *        a consumer that will call methods on {@link LaunchTemplateSpotMarketOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotOptions(LaunchTemplateSpotMarketOptions)
         */
        default Builder spotOptions(Consumer<LaunchTemplateSpotMarketOptions.Builder> spotOptions) {
            return spotOptions(LaunchTemplateSpotMarketOptions.builder().applyMutation(spotOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String marketType;

        private LaunchTemplateSpotMarketOptions spotOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateInstanceMarketOptions model) {
            marketType(model.marketType);
            spotOptions(model.spotOptions);
        }

        public final String getMarketType() {
            return marketType;
        }

        @Override
        public final Builder marketType(String marketType) {
            this.marketType = marketType;
            return this;
        }

        @Override
        public final Builder marketType(MarketType marketType) {
            this.marketType(marketType == null ? null : marketType.toString());
            return this;
        }

        public final void setMarketType(String marketType) {
            this.marketType = marketType;
        }

        public final LaunchTemplateSpotMarketOptions.Builder getSpotOptions() {
            return spotOptions != null ? spotOptions.toBuilder() : null;
        }

        @Override
        public final Builder spotOptions(LaunchTemplateSpotMarketOptions spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        public final void setSpotOptions(LaunchTemplateSpotMarketOptions.BuilderImpl spotOptions) {
            this.spotOptions = spotOptions != null ? spotOptions.build() : null;
        }

        @Override
        public LaunchTemplateInstanceMarketOptions build() {
            return new LaunchTemplateInstanceMarketOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
