/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeScheduledInstanceAvailability.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScheduledInstanceAvailabilityRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeScheduledInstanceAvailabilityRequest.Builder, DescribeScheduledInstanceAvailabilityRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeScheduledInstanceAvailabilityRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<SlotDateTimeRangeRequest> FIRST_SLOT_START_TIME_RANGE_FIELD = SdkField
            .<SlotDateTimeRangeRequest> builder(MarshallingType.SDK_POJO)
            .memberName("FirstSlotStartTimeRange")
            .getter(getter(DescribeScheduledInstanceAvailabilityRequest::firstSlotStartTimeRange))
            .setter(setter(Builder::firstSlotStartTimeRange))
            .constructor(SlotDateTimeRangeRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstSlotStartTimeRange")
                    .unmarshallLocationName("FirstSlotStartTimeRange").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeScheduledInstanceAvailabilityRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<Integer> MAX_SLOT_DURATION_IN_HOURS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSlotDurationInHours")
            .getter(getter(DescribeScheduledInstanceAvailabilityRequest::maxSlotDurationInHours))
            .setter(setter(Builder::maxSlotDurationInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSlotDurationInHours")
                    .unmarshallLocationName("MaxSlotDurationInHours").build()).build();

    private static final SdkField<Integer> MIN_SLOT_DURATION_IN_HOURS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinSlotDurationInHours")
            .getter(getter(DescribeScheduledInstanceAvailabilityRequest::minSlotDurationInHours))
            .setter(setter(Builder::minSlotDurationInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSlotDurationInHours")
                    .unmarshallLocationName("MinSlotDurationInHours").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeScheduledInstanceAvailabilityRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<ScheduledInstanceRecurrenceRequest> RECURRENCE_FIELD = SdkField
            .<ScheduledInstanceRecurrenceRequest> builder(MarshallingType.SDK_POJO)
            .memberName("Recurrence")
            .getter(getter(DescribeScheduledInstanceAvailabilityRequest::recurrence))
            .setter(setter(Builder::recurrence))
            .constructor(ScheduledInstanceRecurrenceRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence")
                    .unmarshallLocationName("Recurrence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            FIRST_SLOT_START_TIME_RANGE_FIELD, MAX_RESULTS_FIELD, MAX_SLOT_DURATION_IN_HOURS_FIELD,
            MIN_SLOT_DURATION_IN_HOURS_FIELD, NEXT_TOKEN_FIELD, RECURRENCE_FIELD));

    private final List<Filter> filters;

    private final SlotDateTimeRangeRequest firstSlotStartTimeRange;

    private final Integer maxResults;

    private final Integer maxSlotDurationInHours;

    private final Integer minSlotDurationInHours;

    private final String nextToken;

    private final ScheduledInstanceRecurrenceRequest recurrence;

    private DescribeScheduledInstanceAvailabilityRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.firstSlotStartTimeRange = builder.firstSlotStartTimeRange;
        this.maxResults = builder.maxResults;
        this.maxSlotDurationInHours = builder.maxSlotDurationInHours;
        this.minSlotDurationInHours = builder.minSlotDurationInHours;
        this.nextToken = builder.nextToken;
        this.recurrence = builder.recurrence;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The time period for the first schedule to start.
     * </p>
     * 
     * @return The time period for the first schedule to start.
     */
    public final SlotDateTimeRangeRequest firstSlotStartTimeRange() {
        return firstSlotStartTimeRange;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. This value can be between 5 and 300. The default value
     * is 300. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. This value can be between 5 and 300. The
     *         default value is 300. To retrieve the remaining results, make another call with the returned
     *         <code>NextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The maximum available duration, in hours. This value must be greater than <code>MinSlotDurationInHours</code> and
     * less than 1,720.
     * </p>
     * 
     * @return The maximum available duration, in hours. This value must be greater than
     *         <code>MinSlotDurationInHours</code> and less than 1,720.
     */
    public final Integer maxSlotDurationInHours() {
        return maxSlotDurationInHours;
    }

    /**
     * <p>
     * The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For example, the
     * minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is
     * 100 hours.
     * </p>
     * 
     * @return The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For
     *         example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum
     *         monthly schedule is 100 hours.
     */
    public final Integer minSlotDurationInHours() {
        return minSlotDurationInHours;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The schedule recurrence.
     * </p>
     * 
     * @return The schedule recurrence.
     */
    public final ScheduledInstanceRecurrenceRequest recurrence() {
        return recurrence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(firstSlotStartTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(maxSlotDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(minSlotDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(recurrence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstanceAvailabilityRequest)) {
            return false;
        }
        DescribeScheduledInstanceAvailabilityRequest other = (DescribeScheduledInstanceAvailabilityRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(firstSlotStartTimeRange(), other.firstSlotStartTimeRange())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(maxSlotDurationInHours(), other.maxSlotDurationInHours())
                && Objects.equals(minSlotDurationInHours(), other.minSlotDurationInHours())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(recurrence(), other.recurrence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeScheduledInstanceAvailabilityRequest").add("Filters", hasFilters() ? filters() : null)
                .add("FirstSlotStartTimeRange", firstSlotStartTimeRange()).add("MaxResults", maxResults())
                .add("MaxSlotDurationInHours", maxSlotDurationInHours()).add("MinSlotDurationInHours", minSlotDurationInHours())
                .add("NextToken", nextToken()).add("Recurrence", recurrence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "FirstSlotStartTimeRange":
            return Optional.ofNullable(clazz.cast(firstSlotStartTimeRange()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "MaxSlotDurationInHours":
            return Optional.ofNullable(clazz.cast(maxSlotDurationInHours()));
        case "MinSlotDurationInHours":
            return Optional.ofNullable(clazz.cast(minSlotDurationInHours()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Recurrence":
            return Optional.ofNullable(clazz.cast(recurrence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledInstanceAvailabilityRequest, T> g) {
        return obj -> g.apply((DescribeScheduledInstanceAvailabilityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityRequest> {
        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The time period for the first schedule to start.
         * </p>
         * 
         * @param firstSlotStartTimeRange
         *        The time period for the first schedule to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstSlotStartTimeRange(SlotDateTimeRangeRequest firstSlotStartTimeRange);

        /**
         * <p>
         * The time period for the first schedule to start.
         * </p>
         * This is a convenience that creates an instance of the {@link SlotDateTimeRangeRequest.Builder} avoiding the
         * need to create one manually via {@link SlotDateTimeRangeRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link SlotDateTimeRangeRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #firstSlotStartTimeRange(SlotDateTimeRangeRequest)}.
         * 
         * @param firstSlotStartTimeRange
         *        a consumer that will call methods on {@link SlotDateTimeRangeRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firstSlotStartTimeRange(SlotDateTimeRangeRequest)
         */
        default Builder firstSlotStartTimeRange(Consumer<SlotDateTimeRangeRequest.Builder> firstSlotStartTimeRange) {
            return firstSlotStartTimeRange(SlotDateTimeRangeRequest.builder().applyMutation(firstSlotStartTimeRange).build());
        }

        /**
         * <p>
         * The maximum number of results to return in a single call. This value can be between 5 and 300. The default
         * value is 300. To retrieve the remaining results, make another call with the returned <code>NextToken</code>
         * value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. This value can be between 5 and 300. The
         *        default value is 300. To retrieve the remaining results, make another call with the returned
         *        <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The maximum available duration, in hours. This value must be greater than <code>MinSlotDurationInHours</code>
         * and less than 1,720.
         * </p>
         * 
         * @param maxSlotDurationInHours
         *        The maximum available duration, in hours. This value must be greater than
         *        <code>MinSlotDurationInHours</code> and less than 1,720.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSlotDurationInHours(Integer maxSlotDurationInHours);

        /**
         * <p>
         * The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For example,
         * the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly
         * schedule is 100 hours.
         * </p>
         * 
         * @param minSlotDurationInHours
         *        The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For
         *        example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the
         *        minimum monthly schedule is 100 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSlotDurationInHours(Integer minSlotDurationInHours);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The schedule recurrence.
         * </p>
         * 
         * @param recurrence
         *        The schedule recurrence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrence(ScheduledInstanceRecurrenceRequest recurrence);

        /**
         * <p>
         * The schedule recurrence.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduledInstanceRecurrenceRequest.Builder}
         * avoiding the need to create one manually via {@link ScheduledInstanceRecurrenceRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduledInstanceRecurrenceRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #recurrence(ScheduledInstanceRecurrenceRequest)}.
         * 
         * @param recurrence
         *        a consumer that will call methods on {@link ScheduledInstanceRecurrenceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurrence(ScheduledInstanceRecurrenceRequest)
         */
        default Builder recurrence(Consumer<ScheduledInstanceRecurrenceRequest.Builder> recurrence) {
            return recurrence(ScheduledInstanceRecurrenceRequest.builder().applyMutation(recurrence).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private SlotDateTimeRangeRequest firstSlotStartTimeRange;

        private Integer maxResults;

        private Integer maxSlotDurationInHours;

        private Integer minSlotDurationInHours;

        private String nextToken;

        private ScheduledInstanceRecurrenceRequest recurrence;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstanceAvailabilityRequest model) {
            super(model);
            filters(model.filters);
            firstSlotStartTimeRange(model.firstSlotStartTimeRange);
            maxResults(model.maxResults);
            maxSlotDurationInHours(model.maxSlotDurationInHours);
            minSlotDurationInHours(model.minSlotDurationInHours);
            nextToken(model.nextToken);
            recurrence(model.recurrence);
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final SlotDateTimeRangeRequest.Builder getFirstSlotStartTimeRange() {
            return firstSlotStartTimeRange != null ? firstSlotStartTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder firstSlotStartTimeRange(SlotDateTimeRangeRequest firstSlotStartTimeRange) {
            this.firstSlotStartTimeRange = firstSlotStartTimeRange;
            return this;
        }

        public final void setFirstSlotStartTimeRange(SlotDateTimeRangeRequest.BuilderImpl firstSlotStartTimeRange) {
            this.firstSlotStartTimeRange = firstSlotStartTimeRange != null ? firstSlotStartTimeRange.build() : null;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Integer getMaxSlotDurationInHours() {
            return maxSlotDurationInHours;
        }

        @Override
        public final Builder maxSlotDurationInHours(Integer maxSlotDurationInHours) {
            this.maxSlotDurationInHours = maxSlotDurationInHours;
            return this;
        }

        public final void setMaxSlotDurationInHours(Integer maxSlotDurationInHours) {
            this.maxSlotDurationInHours = maxSlotDurationInHours;
        }

        public final Integer getMinSlotDurationInHours() {
            return minSlotDurationInHours;
        }

        @Override
        public final Builder minSlotDurationInHours(Integer minSlotDurationInHours) {
            this.minSlotDurationInHours = minSlotDurationInHours;
            return this;
        }

        public final void setMinSlotDurationInHours(Integer minSlotDurationInHours) {
            this.minSlotDurationInHours = minSlotDurationInHours;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final ScheduledInstanceRecurrenceRequest.Builder getRecurrence() {
            return recurrence != null ? recurrence.toBuilder() : null;
        }

        @Override
        public final Builder recurrence(ScheduledInstanceRecurrenceRequest recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final void setRecurrence(ScheduledInstanceRecurrenceRequest.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeScheduledInstanceAvailabilityRequest build() {
            return new DescribeScheduledInstanceAvailabilityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
