/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFpgaImagesRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeFpgaImagesRequest.Builder, DescribeFpgaImagesRequest> {
    private static final SdkField<List<String>> FPGA_IMAGE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FpgaImageIds")
            .getter(getter(DescribeFpgaImagesRequest::fpgaImageIds))
            .setter(setter(Builder::fpgaImageIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaImageId")
                    .unmarshallLocationName("FpgaImageId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> OWNERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Owners")
            .getter(getter(DescribeFpgaImagesRequest::owners))
            .setter(setter(Builder::owners))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner")
                    .unmarshallLocationName("Owner").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Owner")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Owner").unmarshallLocationName("Owner").build()).build())
                            .build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeFpgaImagesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeFpgaImagesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeFpgaImagesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FPGA_IMAGE_IDS_FIELD,
            OWNERS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<String> fpgaImageIds;

    private final List<String> owners;

    private final List<Filter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeFpgaImagesRequest(BuilderImpl builder) {
        super(builder);
        this.fpgaImageIds = builder.fpgaImageIds;
        this.owners = builder.owners;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * Returns true if the FpgaImageIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFpgaImageIds() {
        return fpgaImageIds != null && !(fpgaImageIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AFI IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFpgaImageIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The AFI IDs.
     */
    public final List<String> fpgaImageIds() {
        return fpgaImageIds;
    }

    /**
     * Returns true if the Owners property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOwners() {
        return owners != null && !(owners instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the AFI by owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the request), or
     * an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOwners()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Filters the AFI by owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the
     *         request), or an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code>).
     */
    public final List<String> owners() {
        return owners;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>create-time</code> - The creation time of the AFI.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>name</code> - The name of the AFI.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The AWS account ID of the AFI owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-code</code> - The product code.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>shell-version</code> - The version of the AWS Shell that was used to create the bitstream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> | <code>available</code> |
     * <code>unavailable</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>update-time</code> - The time of the most recent update.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>create-time</code> - The creation time of the AFI.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>name</code> - The name of the AFI.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The AWS account ID of the AFI owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-code</code> - The product code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>shell-version</code> - The version of the AWS Shell that was used to create the bitstream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> |
     *         <code>available</code> | <code>unavailable</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>update-time</code> - The time of the most recent update.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call.
     * </p>
     * 
     * @return The maximum number of results to return in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFpgaImageIds() ? fpgaImageIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOwners() ? owners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFpgaImagesRequest)) {
            return false;
        }
        DescribeFpgaImagesRequest other = (DescribeFpgaImagesRequest) obj;
        return hasFpgaImageIds() == other.hasFpgaImageIds() && Objects.equals(fpgaImageIds(), other.fpgaImageIds())
                && hasOwners() == other.hasOwners() && Objects.equals(owners(), other.owners())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFpgaImagesRequest").add("FpgaImageIds", hasFpgaImageIds() ? fpgaImageIds() : null)
                .add("Owners", hasOwners() ? owners() : null).add("Filters", hasFilters() ? filters() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FpgaImageIds":
            return Optional.ofNullable(clazz.cast(fpgaImageIds()));
        case "Owners":
            return Optional.ofNullable(clazz.cast(owners()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFpgaImagesRequest, T> g) {
        return obj -> g.apply((DescribeFpgaImagesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFpgaImagesRequest> {
        /**
         * <p>
         * The AFI IDs.
         * </p>
         * 
         * @param fpgaImageIds
         *        The AFI IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageIds(Collection<String> fpgaImageIds);

        /**
         * <p>
         * The AFI IDs.
         * </p>
         * 
         * @param fpgaImageIds
         *        The AFI IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageIds(String... fpgaImageIds);

        /**
         * <p>
         * Filters the AFI by owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the request),
         * or an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code>).
         * </p>
         * 
         * @param owners
         *        Filters the AFI by owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the
         *        request), or an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owners(Collection<String> owners);

        /**
         * <p>
         * Filters the AFI by owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the request),
         * or an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code>).
         * </p>
         * 
         * @param owners
         *        Filters the AFI by owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the
         *        request), or an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owners(String... owners);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>create-time</code> - The creation time of the AFI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code> - The name of the AFI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the AFI owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>shell-version</code> - The version of the AWS Shell that was used to create the bitstream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> |
         * <code>available</code> | <code>unavailable</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update-time</code> - The time of the most recent update.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>create-time</code> - The creation time of the AFI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>name</code> - The name of the AFI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the AFI owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code</code> - The product code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>shell-version</code> - The version of the AWS Shell that was used to create the bitstream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> |
         *        <code>available</code> | <code>unavailable</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update-time</code> - The time of the most recent update.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>create-time</code> - The creation time of the AFI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code> - The name of the AFI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the AFI owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>shell-version</code> - The version of the AWS Shell that was used to create the bitstream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> |
         * <code>available</code> | <code>unavailable</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update-time</code> - The time of the most recent update.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>create-time</code> - The creation time of the AFI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>name</code> - The name of the AFI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the AFI owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code</code> - The product code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>shell-version</code> - The version of the AWS Shell that was used to create the bitstream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> |
         *        <code>available</code> | <code>unavailable</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update-time</code> - The time of the most recent update.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>create-time</code> - The creation time of the AFI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code> - The name of the AFI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the AFI owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>shell-version</code> - The version of the AWS Shell that was used to create the bitstream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> |
         * <code>available</code> | <code>unavailable</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update-time</code> - The time of the most recent update.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> fpgaImageIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> owners = DefaultSdkAutoConstructList.getInstance();

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFpgaImagesRequest model) {
            super(model);
            fpgaImageIds(model.fpgaImageIds);
            owners(model.owners);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getFpgaImageIds() {
            if (fpgaImageIds instanceof SdkAutoConstructList) {
                return null;
            }
            return fpgaImageIds;
        }

        @Override
        public final Builder fpgaImageIds(Collection<String> fpgaImageIds) {
            this.fpgaImageIds = FpgaImageIdListCopier.copy(fpgaImageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fpgaImageIds(String... fpgaImageIds) {
            fpgaImageIds(Arrays.asList(fpgaImageIds));
            return this;
        }

        public final void setFpgaImageIds(Collection<String> fpgaImageIds) {
            this.fpgaImageIds = FpgaImageIdListCopier.copy(fpgaImageIds);
        }

        public final Collection<String> getOwners() {
            if (owners instanceof SdkAutoConstructList) {
                return null;
            }
            return owners;
        }

        @Override
        public final Builder owners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(String... owners) {
            owners(Arrays.asList(owners));
            return this;
        }

        public final void setOwners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFpgaImagesRequest build() {
            return new DescribeFpgaImagesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
