/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClientVpnTargetNetworksResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeClientVpnTargetNetworksResponse.Builder, DescribeClientVpnTargetNetworksResponse> {
    private static final SdkField<List<TargetNetwork>> CLIENT_VPN_TARGET_NETWORKS_FIELD = SdkField
            .<List<TargetNetwork>> builder(MarshallingType.LIST)
            .memberName("ClientVpnTargetNetworks")
            .getter(getter(DescribeClientVpnTargetNetworksResponse::clientVpnTargetNetworks))
            .setter(setter(Builder::clientVpnTargetNetworks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnTargetNetworks")
                    .unmarshallLocationName("clientVpnTargetNetworks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TargetNetwork> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetNetwork::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeClientVpnTargetNetworksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLIENT_VPN_TARGET_NETWORKS_FIELD, NEXT_TOKEN_FIELD));

    private final List<TargetNetwork> clientVpnTargetNetworks;

    private final String nextToken;

    private DescribeClientVpnTargetNetworksResponse(BuilderImpl builder) {
        super(builder);
        this.clientVpnTargetNetworks = builder.clientVpnTargetNetworks;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ClientVpnTargetNetworks property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasClientVpnTargetNetworks() {
        return clientVpnTargetNetworks != null && !(clientVpnTargetNetworks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the associated target networks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClientVpnTargetNetworks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the associated target networks.
     */
    public final List<TargetNetwork> clientVpnTargetNetworks() {
        return clientVpnTargetNetworks;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasClientVpnTargetNetworks() ? clientVpnTargetNetworks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClientVpnTargetNetworksResponse)) {
            return false;
        }
        DescribeClientVpnTargetNetworksResponse other = (DescribeClientVpnTargetNetworksResponse) obj;
        return hasClientVpnTargetNetworks() == other.hasClientVpnTargetNetworks()
                && Objects.equals(clientVpnTargetNetworks(), other.clientVpnTargetNetworks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClientVpnTargetNetworksResponse")
                .add("ClientVpnTargetNetworks", hasClientVpnTargetNetworks() ? clientVpnTargetNetworks() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVpnTargetNetworks":
            return Optional.ofNullable(clazz.cast(clientVpnTargetNetworks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClientVpnTargetNetworksResponse, T> g) {
        return obj -> g.apply((DescribeClientVpnTargetNetworksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeClientVpnTargetNetworksResponse> {
        /**
         * <p>
         * Information about the associated target networks.
         * </p>
         * 
         * @param clientVpnTargetNetworks
         *        Information about the associated target networks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpnTargetNetworks(Collection<TargetNetwork> clientVpnTargetNetworks);

        /**
         * <p>
         * Information about the associated target networks.
         * </p>
         * 
         * @param clientVpnTargetNetworks
         *        Information about the associated target networks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpnTargetNetworks(TargetNetwork... clientVpnTargetNetworks);

        /**
         * <p>
         * Information about the associated target networks.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TargetNetwork>.Builder} avoiding the need
         * to create one manually via {@link List<TargetNetwork>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetNetwork>.Builder#build()} is called immediately and
         * its result is passed to {@link #clientVpnTargetNetworks(List<TargetNetwork>)}.
         * 
         * @param clientVpnTargetNetworks
         *        a consumer that will call methods on {@link List<TargetNetwork>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientVpnTargetNetworks(List<TargetNetwork>)
         */
        Builder clientVpnTargetNetworks(Consumer<TargetNetwork.Builder>... clientVpnTargetNetworks);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<TargetNetwork> clientVpnTargetNetworks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClientVpnTargetNetworksResponse model) {
            super(model);
            clientVpnTargetNetworks(model.clientVpnTargetNetworks);
            nextToken(model.nextToken);
        }

        public final List<TargetNetwork.Builder> getClientVpnTargetNetworks() {
            List<TargetNetwork.Builder> result = TargetNetworkSetCopier.copyToBuilder(this.clientVpnTargetNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder clientVpnTargetNetworks(Collection<TargetNetwork> clientVpnTargetNetworks) {
            this.clientVpnTargetNetworks = TargetNetworkSetCopier.copy(clientVpnTargetNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientVpnTargetNetworks(TargetNetwork... clientVpnTargetNetworks) {
            clientVpnTargetNetworks(Arrays.asList(clientVpnTargetNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientVpnTargetNetworks(Consumer<TargetNetwork.Builder>... clientVpnTargetNetworks) {
            clientVpnTargetNetworks(Stream.of(clientVpnTargetNetworks).map(c -> TargetNetwork.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setClientVpnTargetNetworks(Collection<TargetNetwork.BuilderImpl> clientVpnTargetNetworks) {
            this.clientVpnTargetNetworks = TargetNetworkSetCopier.copyFromBuilder(clientVpnTargetNetworks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeClientVpnTargetNetworksResponse build() {
            return new DescribeClientVpnTargetNetworksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
