/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ClientVpnEndpointAttributeStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClientConnectResponseOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClientConnectResponseOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(ClientConnectResponseOptions.getter(ClientConnectResponseOptions::enabled)).setter(ClientConnectResponseOptions.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").unmarshallLocationName("enabled").build()}).build();
    private static final SdkField<String> LAMBDA_FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LambdaFunctionArn").getter(ClientConnectResponseOptions.getter(ClientConnectResponseOptions::lambdaFunctionArn)).setter(ClientConnectResponseOptions.setter(Builder::lambdaFunctionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionArn").unmarshallLocationName("lambdaFunctionArn").build()}).build();
    private static final SdkField<ClientVpnEndpointAttributeStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(ClientConnectResponseOptions.getter(ClientConnectResponseOptions::status)).setter(ClientConnectResponseOptions.setter(Builder::status)).constructor(ClientVpnEndpointAttributeStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, LAMBDA_FUNCTION_ARN_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String lambdaFunctionArn;
    private final ClientVpnEndpointAttributeStatus status;

    private ClientConnectResponseOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.lambdaFunctionArn = builder.lambdaFunctionArn;
        this.status = builder.status;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String lambdaFunctionArn() {
        return this.lambdaFunctionArn;
    }

    public final ClientVpnEndpointAttributeStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientConnectResponseOptions)) {
            return false;
        }
        ClientConnectResponseOptions other = (ClientConnectResponseOptions)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.lambdaFunctionArn(), other.lambdaFunctionArn()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"ClientConnectResponseOptions").add("Enabled", (Object)this.enabled()).add("LambdaFunctionArn", (Object)this.lambdaFunctionArn()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "LambdaFunctionArn": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientConnectResponseOptions, T> g) {
        return obj -> g.apply((ClientConnectResponseOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String lambdaFunctionArn;
        private ClientVpnEndpointAttributeStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientConnectResponseOptions model) {
            this.enabled(model.enabled);
            this.lambdaFunctionArn(model.lambdaFunctionArn);
            this.status(model.status);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getLambdaFunctionArn() {
            return this.lambdaFunctionArn;
        }

        @Override
        public final Builder lambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
            return this;
        }

        public final void setLambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
        }

        public final ClientVpnEndpointAttributeStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(ClientVpnEndpointAttributeStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ClientVpnEndpointAttributeStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public ClientConnectResponseOptions build() {
            return new ClientConnectResponseOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClientConnectResponseOptions> {
        public Builder enabled(Boolean var1);

        public Builder lambdaFunctionArn(String var1);

        public Builder status(ClientVpnEndpointAttributeStatus var1);

        default public Builder status(Consumer<ClientVpnEndpointAttributeStatus.Builder> status) {
            return this.status((ClientVpnEndpointAttributeStatus)((ClientVpnEndpointAttributeStatus.Builder)ClientVpnEndpointAttributeStatus.builder().applyMutation(status)).build());
        }
    }
}

