/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ReplaceRootVolumeTasksCopier {
    static List<ReplaceRootVolumeTask> copy(Collection<? extends ReplaceRootVolumeTask> replaceRootVolumeTasksParam) {
        List<ReplaceRootVolumeTask> list;
        if (replaceRootVolumeTasksParam == null || replaceRootVolumeTasksParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ReplaceRootVolumeTask> modifiableList = new ArrayList<>();
            replaceRootVolumeTasksParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ReplaceRootVolumeTask> copyFromBuilder(
            Collection<? extends ReplaceRootVolumeTask.Builder> replaceRootVolumeTasksParam) {
        List<ReplaceRootVolumeTask> list;
        if (replaceRootVolumeTasksParam == null || replaceRootVolumeTasksParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ReplaceRootVolumeTask> modifiableList = new ArrayList<>();
            replaceRootVolumeTasksParam.forEach(entry -> {
                ReplaceRootVolumeTask member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ReplaceRootVolumeTask.Builder> copyToBuilder(
            Collection<? extends ReplaceRootVolumeTask> replaceRootVolumeTasksParam) {
        List<ReplaceRootVolumeTask.Builder> list;
        if (replaceRootVolumeTasksParam == null || replaceRootVolumeTasksParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ReplaceRootVolumeTask.Builder> modifiableList = new ArrayList<>();
            replaceRootVolumeTasksParam.forEach(entry -> {
                ReplaceRootVolumeTask.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
