/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class PriceScheduleSpecificationListCopier {
    static List<PriceScheduleSpecification> copy(
            Collection<? extends PriceScheduleSpecification> priceScheduleSpecificationListParam) {
        List<PriceScheduleSpecification> list;
        if (priceScheduleSpecificationListParam == null || priceScheduleSpecificationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PriceScheduleSpecification> modifiableList = new ArrayList<>();
            priceScheduleSpecificationListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PriceScheduleSpecification> copyFromBuilder(
            Collection<? extends PriceScheduleSpecification.Builder> priceScheduleSpecificationListParam) {
        List<PriceScheduleSpecification> list;
        if (priceScheduleSpecificationListParam == null || priceScheduleSpecificationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PriceScheduleSpecification> modifiableList = new ArrayList<>();
            priceScheduleSpecificationListParam.forEach(entry -> {
                PriceScheduleSpecification member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PriceScheduleSpecification.Builder> copyToBuilder(
            Collection<? extends PriceScheduleSpecification> priceScheduleSpecificationListParam) {
        List<PriceScheduleSpecification.Builder> list;
        if (priceScheduleSpecificationListParam == null || priceScheduleSpecificationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PriceScheduleSpecification.Builder> modifiableList = new ArrayList<>();
            priceScheduleSpecificationListParam.forEach(entry -> {
                PriceScheduleSpecification.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
