/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIdentityIdFormatResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeIdentityIdFormatResponse.Builder, DescribeIdentityIdFormatResponse> {
    private static final SdkField<List<IdFormat>> STATUSES_FIELD = SdkField
            .<List<IdFormat>> builder(MarshallingType.LIST)
            .memberName("Statuses")
            .getter(getter(DescribeIdentityIdFormatResponse::statuses))
            .setter(setter(Builder::statuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusSet")
                    .unmarshallLocationName("statusSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IdFormat> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdFormat::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUSES_FIELD));

    private final List<IdFormat> statuses;

    private DescribeIdentityIdFormatResponse(BuilderImpl builder) {
        super(builder);
        this.statuses = builder.statuses;
    }

    /**
     * Returns true if the Statuses property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStatuses() {
        return statuses != null && !(statuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the ID format for the resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the ID format for the resources.
     */
    public final List<IdFormat> statuses() {
        return statuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStatuses() ? statuses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityIdFormatResponse)) {
            return false;
        }
        DescribeIdentityIdFormatResponse other = (DescribeIdentityIdFormatResponse) obj;
        return hasStatuses() == other.hasStatuses() && Objects.equals(statuses(), other.statuses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIdentityIdFormatResponse").add("Statuses", hasStatuses() ? statuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Statuses":
            return Optional.ofNullable(clazz.cast(statuses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIdentityIdFormatResponse, T> g) {
        return obj -> g.apply((DescribeIdentityIdFormatResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIdentityIdFormatResponse> {
        /**
         * <p>
         * Information about the ID format for the resources.
         * </p>
         * 
         * @param statuses
         *        Information about the ID format for the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Collection<IdFormat> statuses);

        /**
         * <p>
         * Information about the ID format for the resources.
         * </p>
         * 
         * @param statuses
         *        Information about the ID format for the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(IdFormat... statuses);

        /**
         * <p>
         * Information about the ID format for the resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IdFormat>.Builder} avoiding the need to
         * create one manually via {@link List<IdFormat>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IdFormat>.Builder#build()} is called immediately and its
         * result is passed to {@link #statuses(List<IdFormat>)}.
         * 
         * @param statuses
         *        a consumer that will call methods on {@link List<IdFormat>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statuses(List<IdFormat>)
         */
        Builder statuses(Consumer<IdFormat.Builder>... statuses);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<IdFormat> statuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityIdFormatResponse model) {
            super(model);
            statuses(model.statuses);
        }

        public final List<IdFormat.Builder> getStatuses() {
            List<IdFormat.Builder> result = IdFormatListCopier.copyToBuilder(this.statuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder statuses(Collection<IdFormat> statuses) {
            this.statuses = IdFormatListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(IdFormat... statuses) {
            statuses(Arrays.asList(statuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(Consumer<IdFormat.Builder>... statuses) {
            statuses(Stream.of(statuses).map(c -> IdFormat.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStatuses(Collection<IdFormat.BuilderImpl> statuses) {
            this.statuses = IdFormatListCopier.copyFromBuilder(statuses);
        }

        @Override
        public DescribeIdentityIdFormatResponse build() {
            return new DescribeIdentityIdFormatResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
