/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an import snapshot task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportSnapshotTask implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportSnapshotTask.Builder, ImportSnapshotTask> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ImportSnapshotTask::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> IMPORT_TASK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImportTaskId")
            .getter(getter(ImportSnapshotTask::importTaskId))
            .setter(setter(Builder::importTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTaskId")
                    .unmarshallLocationName("importTaskId").build()).build();

    private static final SdkField<SnapshotTaskDetail> SNAPSHOT_TASK_DETAIL_FIELD = SdkField
            .<SnapshotTaskDetail> builder(MarshallingType.SDK_POJO)
            .memberName("SnapshotTaskDetail")
            .getter(getter(ImportSnapshotTask::snapshotTaskDetail))
            .setter(setter(Builder::snapshotTaskDetail))
            .constructor(SnapshotTaskDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotTaskDetail")
                    .unmarshallLocationName("snapshotTaskDetail").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ImportSnapshotTask::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            IMPORT_TASK_ID_FIELD, SNAPSHOT_TASK_DETAIL_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String importTaskId;

    private final SnapshotTaskDetail snapshotTaskDetail;

    private final List<Tag> tags;

    private ImportSnapshotTask(BuilderImpl builder) {
        this.description = builder.description;
        this.importTaskId = builder.importTaskId;
        this.snapshotTaskDetail = builder.snapshotTaskDetail;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A description of the import snapshot task.
     * </p>
     * 
     * @return A description of the import snapshot task.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the import snapshot task.
     * </p>
     * 
     * @return The ID of the import snapshot task.
     */
    public final String importTaskId() {
        return importTaskId;
    }

    /**
     * <p>
     * Describes an import snapshot task.
     * </p>
     * 
     * @return Describes an import snapshot task.
     */
    public final SnapshotTaskDetail snapshotTaskDetail() {
        return snapshotTaskDetail;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the import snapshot task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags for the import snapshot task.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(importTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotTaskDetail());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSnapshotTask)) {
            return false;
        }
        ImportSnapshotTask other = (ImportSnapshotTask) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(importTaskId(), other.importTaskId())
                && Objects.equals(snapshotTaskDetail(), other.snapshotTaskDetail()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportSnapshotTask").add("Description", description()).add("ImportTaskId", importTaskId())
                .add("SnapshotTaskDetail", snapshotTaskDetail()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ImportTaskId":
            return Optional.ofNullable(clazz.cast(importTaskId()));
        case "SnapshotTaskDetail":
            return Optional.ofNullable(clazz.cast(snapshotTaskDetail()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportSnapshotTask, T> g) {
        return obj -> g.apply((ImportSnapshotTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportSnapshotTask> {
        /**
         * <p>
         * A description of the import snapshot task.
         * </p>
         * 
         * @param description
         *        A description of the import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the import snapshot task.
         * </p>
         * 
         * @param importTaskId
         *        The ID of the import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTaskId(String importTaskId);

        /**
         * <p>
         * Describes an import snapshot task.
         * </p>
         * 
         * @param snapshotTaskDetail
         *        Describes an import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotTaskDetail(SnapshotTaskDetail snapshotTaskDetail);

        /**
         * <p>
         * Describes an import snapshot task.
         * </p>
         * This is a convenience that creates an instance of the {@link SnapshotTaskDetail.Builder} avoiding the need to
         * create one manually via {@link SnapshotTaskDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link SnapshotTaskDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #snapshotTaskDetail(SnapshotTaskDetail)}.
         * 
         * @param snapshotTaskDetail
         *        a consumer that will call methods on {@link SnapshotTaskDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotTaskDetail(SnapshotTaskDetail)
         */
        default Builder snapshotTaskDetail(Consumer<SnapshotTaskDetail.Builder> snapshotTaskDetail) {
            return snapshotTaskDetail(SnapshotTaskDetail.builder().applyMutation(snapshotTaskDetail).build());
        }

        /**
         * <p>
         * The tags for the import snapshot task.
         * </p>
         * 
         * @param tags
         *        The tags for the import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the import snapshot task.
         * </p>
         * 
         * @param tags
         *        The tags for the import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the import snapshot task.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String importTaskId;

        private SnapshotTaskDetail snapshotTaskDetail;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSnapshotTask model) {
            description(model.description);
            importTaskId(model.importTaskId);
            snapshotTaskDetail(model.snapshotTaskDetail);
            tags(model.tags);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getImportTaskId() {
            return importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        public final SnapshotTaskDetail.Builder getSnapshotTaskDetail() {
            return snapshotTaskDetail != null ? snapshotTaskDetail.toBuilder() : null;
        }

        @Override
        public final Builder snapshotTaskDetail(SnapshotTaskDetail snapshotTaskDetail) {
            this.snapshotTaskDetail = snapshotTaskDetail;
            return this;
        }

        public final void setSnapshotTaskDetail(SnapshotTaskDetail.BuilderImpl snapshotTaskDetail) {
            this.snapshotTaskDetail = snapshotTaskDetail != null ? snapshotTaskDetail.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public ImportSnapshotTask build() {
            return new ImportSnapshotTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
