/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTransitGatewayConnectsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeTransitGatewayConnectsResponse.Builder, DescribeTransitGatewayConnectsResponse> {
    private static final SdkField<List<TransitGatewayConnect>> TRANSIT_GATEWAY_CONNECTS_FIELD = SdkField
            .<List<TransitGatewayConnect>> builder(MarshallingType.LIST)
            .memberName("TransitGatewayConnects")
            .getter(getter(DescribeTransitGatewayConnectsResponse::transitGatewayConnects))
            .setter(setter(Builder::transitGatewayConnects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayConnectSet")
                    .unmarshallLocationName("transitGatewayConnectSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TransitGatewayConnect> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransitGatewayConnect::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeTransitGatewayConnectsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_CONNECTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<TransitGatewayConnect> transitGatewayConnects;

    private final String nextToken;

    private DescribeTransitGatewayConnectsResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayConnects = builder.transitGatewayConnects;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the TransitGatewayConnects property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTransitGatewayConnects() {
        return transitGatewayConnects != null && !(transitGatewayConnects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Connect attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTransitGatewayConnects()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the Connect attachments.
     */
    public final List<TransitGatewayConnect> transitGatewayConnects() {
        return transitGatewayConnects;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTransitGatewayConnects() ? transitGatewayConnects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransitGatewayConnectsResponse)) {
            return false;
        }
        DescribeTransitGatewayConnectsResponse other = (DescribeTransitGatewayConnectsResponse) obj;
        return hasTransitGatewayConnects() == other.hasTransitGatewayConnects()
                && Objects.equals(transitGatewayConnects(), other.transitGatewayConnects())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTransitGatewayConnectsResponse")
                .add("TransitGatewayConnects", hasTransitGatewayConnects() ? transitGatewayConnects() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayConnects":
            return Optional.ofNullable(clazz.cast(transitGatewayConnects()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransitGatewayConnectsResponse, T> g) {
        return obj -> g.apply((DescribeTransitGatewayConnectsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTransitGatewayConnectsResponse> {
        /**
         * <p>
         * Information about the Connect attachments.
         * </p>
         * 
         * @param transitGatewayConnects
         *        Information about the Connect attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayConnects(Collection<TransitGatewayConnect> transitGatewayConnects);

        /**
         * <p>
         * Information about the Connect attachments.
         * </p>
         * 
         * @param transitGatewayConnects
         *        Information about the Connect attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayConnects(TransitGatewayConnect... transitGatewayConnects);

        /**
         * <p>
         * Information about the Connect attachments.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TransitGatewayConnect>.Builder} avoiding
         * the need to create one manually via {@link List<TransitGatewayConnect>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TransitGatewayConnect>.Builder#build()} is called
         * immediately and its result is passed to {@link #transitGatewayConnects(List<TransitGatewayConnect>)}.
         * 
         * @param transitGatewayConnects
         *        a consumer that will call methods on {@link List<TransitGatewayConnect>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayConnects(List<TransitGatewayConnect>)
         */
        Builder transitGatewayConnects(Consumer<TransitGatewayConnect.Builder>... transitGatewayConnects);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<TransitGatewayConnect> transitGatewayConnects = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransitGatewayConnectsResponse model) {
            super(model);
            transitGatewayConnects(model.transitGatewayConnects);
            nextToken(model.nextToken);
        }

        public final Collection<TransitGatewayConnect.Builder> getTransitGatewayConnects() {
            if (transitGatewayConnects instanceof SdkAutoConstructList) {
                return null;
            }
            return transitGatewayConnects != null ? transitGatewayConnects.stream().map(TransitGatewayConnect::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder transitGatewayConnects(Collection<TransitGatewayConnect> transitGatewayConnects) {
            this.transitGatewayConnects = TransitGatewayConnectListCopier.copy(transitGatewayConnects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayConnects(TransitGatewayConnect... transitGatewayConnects) {
            transitGatewayConnects(Arrays.asList(transitGatewayConnects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayConnects(Consumer<TransitGatewayConnect.Builder>... transitGatewayConnects) {
            transitGatewayConnects(Stream.of(transitGatewayConnects)
                    .map(c -> TransitGatewayConnect.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTransitGatewayConnects(Collection<TransitGatewayConnect.BuilderImpl> transitGatewayConnects) {
            this.transitGatewayConnects = TransitGatewayConnectListCopier.copyFromBuilder(transitGatewayConnects);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeTransitGatewayConnectsResponse build() {
            return new DescribeTransitGatewayConnectsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
