/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstancesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeInstancesResponse.Builder, DescribeInstancesResponse> {
    private static final SdkField<List<Reservation>> RESERVATIONS_FIELD = SdkField
            .<List<Reservation>> builder(MarshallingType.LIST)
            .memberName("Reservations")
            .getter(getter(DescribeInstancesResponse::reservations))
            .setter(setter(Builder::reservations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationSet")
                    .unmarshallLocationName("reservationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Reservation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Reservation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeInstancesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Reservation> reservations;

    private final String nextToken;

    private DescribeInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.reservations = builder.reservations;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Reservations property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasReservations() {
        return reservations != null && !(reservations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the reservations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReservations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the reservations.
     */
    public final List<Reservation> reservations() {
        return reservations;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReservations() ? reservations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesResponse)) {
            return false;
        }
        DescribeInstancesResponse other = (DescribeInstancesResponse) obj;
        return hasReservations() == other.hasReservations() && Objects.equals(reservations(), other.reservations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstancesResponse").add("Reservations", hasReservations() ? reservations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Reservations":
            return Optional.ofNullable(clazz.cast(reservations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstancesResponse, T> g) {
        return obj -> g.apply((DescribeInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInstancesResponse> {
        /**
         * <p>
         * Information about the reservations.
         * </p>
         * 
         * @param reservations
         *        Information about the reservations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservations(Collection<Reservation> reservations);

        /**
         * <p>
         * Information about the reservations.
         * </p>
         * 
         * @param reservations
         *        Information about the reservations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservations(Reservation... reservations);

        /**
         * <p>
         * Information about the reservations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Reservation>.Builder} avoiding the need to
         * create one manually via {@link List<Reservation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Reservation>.Builder#build()} is called immediately and its
         * result is passed to {@link #reservations(List<Reservation>)}.
         * 
         * @param reservations
         *        a consumer that will call methods on {@link List<Reservation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservations(List<Reservation>)
         */
        Builder reservations(Consumer<Reservation.Builder>... reservations);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<Reservation> reservations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesResponse model) {
            super(model);
            reservations(model.reservations);
            nextToken(model.nextToken);
        }

        public final Collection<Reservation.Builder> getReservations() {
            if (reservations instanceof SdkAutoConstructList) {
                return null;
            }
            return reservations != null ? reservations.stream().map(Reservation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservations(Collection<Reservation> reservations) {
            this.reservations = ReservationListCopier.copy(reservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservations(Reservation... reservations) {
            reservations(Arrays.asList(reservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservations(Consumer<Reservation.Builder>... reservations) {
            reservations(Stream.of(reservations).map(c -> Reservation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReservations(Collection<Reservation.BuilderImpl> reservations) {
            this.reservations = ReservationListCopier.copyFromBuilder(reservations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstancesResponse build() {
            return new DescribeInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
