/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBundleTasksRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeBundleTasksRequest.Builder, DescribeBundleTasksRequest> {
    private static final SdkField<List<String>> BUNDLE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BundleIds")
            .getter(getter(DescribeBundleTasksRequest::bundleIds))
            .setter(setter(Builder::bundleIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId")
                    .unmarshallLocationName("BundleId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("BundleId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("BundleId").unmarshallLocationName("BundleId").build()).build())
                            .build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeBundleTasksRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_IDS_FIELD,
            FILTERS_FIELD));

    private final List<String> bundleIds;

    private final List<Filter> filters;

    private DescribeBundleTasksRequest(BuilderImpl builder) {
        super(builder);
        this.bundleIds = builder.bundleIds;
        this.filters = builder.filters;
    }

    /**
     * Returns true if the BundleIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasBundleIds() {
        return bundleIds != null && !(bundleIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The bundle task IDs.
     * </p>
     * <p>
     * Default: Describes all your bundle tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBundleIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The bundle task IDs.</p>
     *         <p>
     *         Default: Describes all your bundle tasks.
     */
    public final List<String> bundleIds() {
        return bundleIds;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>bundle-id</code> - The ID of the bundle task.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>error-code</code> - If the task failed, the error code returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>error-message</code> - If the task failed, the error message returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-id</code> - The ID of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>progress</code> - The level of task completion, as a percentage (for example, 20%).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3-prefix</code> - The beginning of the AMI name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> |
     * <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> |
     * <code>failed</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>update-time</code> - The time of the most recent update for the task.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>bundle-id</code> - The ID of the bundle task.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>error-code</code> - If the task failed, the error code returned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>error-message</code> - If the task failed, the error message returned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-id</code> - The ID of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>progress</code> - The level of task completion, as a percentage (for example, 20%).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3-prefix</code> - The beginning of the AMI name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> |
     *         <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> |
     *         <code>failed</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>update-time</code> - The time of the most recent update for the task.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBundleIds() ? bundleIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBundleTasksRequest)) {
            return false;
        }
        DescribeBundleTasksRequest other = (DescribeBundleTasksRequest) obj;
        return hasBundleIds() == other.hasBundleIds() && Objects.equals(bundleIds(), other.bundleIds())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBundleTasksRequest").add("BundleIds", hasBundleIds() ? bundleIds() : null)
                .add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BundleIds":
            return Optional.ofNullable(clazz.cast(bundleIds()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBundleTasksRequest, T> g) {
        return obj -> g.apply((DescribeBundleTasksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBundleTasksRequest> {
        /**
         * <p>
         * The bundle task IDs.
         * </p>
         * <p>
         * Default: Describes all your bundle tasks.
         * </p>
         * 
         * @param bundleIds
         *        The bundle task IDs.</p>
         *        <p>
         *        Default: Describes all your bundle tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleIds(Collection<String> bundleIds);

        /**
         * <p>
         * The bundle task IDs.
         * </p>
         * <p>
         * Default: Describes all your bundle tasks.
         * </p>
         * 
         * @param bundleIds
         *        The bundle task IDs.</p>
         *        <p>
         *        Default: Describes all your bundle tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleIds(String... bundleIds);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>bundle-id</code> - The ID of the bundle task.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>error-code</code> - If the task failed, the error code returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>error-message</code> - If the task failed, the error message returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>progress</code> - The level of task completion, as a percentage (for example, 20%).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3-prefix</code> - The beginning of the AMI name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> |
         * <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> |
         * <code>failed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update-time</code> - The time of the most recent update for the task.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>bundle-id</code> - The ID of the bundle task.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>error-code</code> - If the task failed, the error code returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>error-message</code> - If the task failed, the error message returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>progress</code> - The level of task completion, as a percentage (for example, 20%).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3-prefix</code> - The beginning of the AMI name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> |
         *        <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> |
         *        <code>failed</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update-time</code> - The time of the most recent update for the task.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>bundle-id</code> - The ID of the bundle task.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>error-code</code> - If the task failed, the error code returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>error-message</code> - If the task failed, the error message returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>progress</code> - The level of task completion, as a percentage (for example, 20%).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3-prefix</code> - The beginning of the AMI name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> |
         * <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> |
         * <code>failed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update-time</code> - The time of the most recent update for the task.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>bundle-id</code> - The ID of the bundle task.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>error-code</code> - If the task failed, the error code returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>error-message</code> - If the task failed, the error message returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>progress</code> - The level of task completion, as a percentage (for example, 20%).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3-prefix</code> - The beginning of the AMI name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> |
         *        <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> |
         *        <code>failed</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update-time</code> - The time of the most recent update for the task.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>bundle-id</code> - The ID of the bundle task.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>error-code</code> - If the task failed, the error code returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>error-message</code> - If the task failed, the error message returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>progress</code> - The level of task completion, as a percentage (for example, 20%).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3-prefix</code> - The beginning of the AMI name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> |
         * <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> |
         * <code>failed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update-time</code> - The time of the most recent update for the task.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> bundleIds = DefaultSdkAutoConstructList.getInstance();

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBundleTasksRequest model) {
            super(model);
            bundleIds(model.bundleIds);
            filters(model.filters);
        }

        public final Collection<String> getBundleIds() {
            if (bundleIds instanceof SdkAutoConstructList) {
                return null;
            }
            return bundleIds;
        }

        @Override
        public final Builder bundleIds(Collection<String> bundleIds) {
            this.bundleIds = BundleIdStringListCopier.copy(bundleIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundleIds(String... bundleIds) {
            bundleIds(Arrays.asList(bundleIds));
            return this;
        }

        public final void setBundleIds(Collection<String> bundleIds) {
            this.bundleIds = BundleIdStringListCopier.copy(bundleIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            if (filters instanceof SdkAutoConstructList) {
                return null;
            }
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeBundleTasksRequest build() {
            return new DescribeBundleTasksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
