/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.UserBucket;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotDiskContainer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotDiskContainer> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SnapshotDiskContainer.getter(SnapshotDiskContainer::description)).setter(SnapshotDiskContainer.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(SnapshotDiskContainer.getter(SnapshotDiskContainer::format)).setter(SnapshotDiskContainer.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").unmarshallLocationName("Format").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(SnapshotDiskContainer.getter(SnapshotDiskContainer::url)).setter(SnapshotDiskContainer.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").unmarshallLocationName("Url").build()}).build();
    private static final SdkField<UserBucket> USER_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserBucket").getter(SnapshotDiskContainer.getter(SnapshotDiskContainer::userBucket)).setter(SnapshotDiskContainer.setter(Builder::userBucket)).constructor(UserBucket::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserBucket").unmarshallLocationName("UserBucket").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, FORMAT_FIELD, URL_FIELD, USER_BUCKET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String format;
    private final String url;
    private final UserBucket userBucket;

    private SnapshotDiskContainer(BuilderImpl builder) {
        this.description = builder.description;
        this.format = builder.format;
        this.url = builder.url;
        this.userBucket = builder.userBucket;
    }

    public String description() {
        return this.description;
    }

    public String format() {
        return this.format;
    }

    public String url() {
        return this.url;
    }

    public UserBucket userBucket() {
        return this.userBucket;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.userBucket());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotDiskContainer)) {
            return false;
        }
        SnapshotDiskContainer other = (SnapshotDiskContainer)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.format(), other.format()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.userBucket(), other.userBucket());
    }

    public String toString() {
        return ToString.builder((String)"SnapshotDiskContainer").add("Description", (Object)this.description()).add("Format", (Object)this.format()).add("Url", (Object)this.url()).add("UserBucket", (Object)this.userBucket()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "UserBucket": {
                return Optional.ofNullable(clazz.cast(this.userBucket()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotDiskContainer, T> g) {
        return obj -> g.apply((SnapshotDiskContainer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String format;
        private String url;
        private UserBucket userBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotDiskContainer model) {
            this.description(model.description);
            this.format(model.format);
            this.url(model.url);
            this.userBucket(model.userBucket);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final UserBucket.Builder getUserBucket() {
            return this.userBucket != null ? this.userBucket.toBuilder() : null;
        }

        @Override
        public final Builder userBucket(UserBucket userBucket) {
            this.userBucket = userBucket;
            return this;
        }

        public final void setUserBucket(UserBucket.BuilderImpl userBucket) {
            this.userBucket = userBucket != null ? userBucket.build() : null;
        }

        public SnapshotDiskContainer build() {
            return new SnapshotDiskContainer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotDiskContainer> {
        public Builder description(String var1);

        public Builder format(String var1);

        public Builder url(String var1);

        public Builder userBucket(UserBucket var1);

        default public Builder userBucket(Consumer<UserBucket.Builder> userBucket) {
            return this.userBucket((UserBucket)((UserBucket.Builder)UserBucket.builder().applyMutation(userBucket)).build());
        }
    }
}

