/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfig;
import software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSpotFleetRequestsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeSpotFleetRequestsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSpotFleetRequestsResponse.getter(DescribeSpotFleetRequestsResponse::nextToken)).setter(DescribeSpotFleetRequestsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<SpotFleetRequestConfig>> SPOT_FLEET_REQUEST_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SpotFleetRequestConfigs").getter(DescribeSpotFleetRequestsResponse.getter(DescribeSpotFleetRequestsResponse::spotFleetRequestConfigs)).setter(DescribeSpotFleetRequestsResponse.setter(Builder::spotFleetRequestConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestConfigSet").unmarshallLocationName("spotFleetRequestConfigSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpotFleetRequestConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SPOT_FLEET_REQUEST_CONFIGS_FIELD));
    private final String nextToken;
    private final List<SpotFleetRequestConfig> spotFleetRequestConfigs;

    private DescribeSpotFleetRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.spotFleetRequestConfigs = builder.spotFleetRequestConfigs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasSpotFleetRequestConfigs() {
        return this.spotFleetRequestConfigs != null && !(this.spotFleetRequestConfigs instanceof SdkAutoConstructList);
    }

    public List<SpotFleetRequestConfig> spotFleetRequestConfigs() {
        return this.spotFleetRequestConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpotFleetRequestConfigs() ? this.spotFleetRequestConfigs() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetRequestsResponse)) {
            return false;
        }
        DescribeSpotFleetRequestsResponse other = (DescribeSpotFleetRequestsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSpotFleetRequestConfigs() == other.hasSpotFleetRequestConfigs() && Objects.equals(this.spotFleetRequestConfigs(), other.spotFleetRequestConfigs());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSpotFleetRequestsResponse").add("NextToken", (Object)this.nextToken()).add("SpotFleetRequestConfigs", this.hasSpotFleetRequestConfigs() ? this.spotFleetRequestConfigs() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SpotFleetRequestConfigs": {
                return Optional.ofNullable(clazz.cast(this.spotFleetRequestConfigs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpotFleetRequestsResponse, T> g) {
        return obj -> g.apply((DescribeSpotFleetRequestsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SpotFleetRequestConfig> spotFleetRequestConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetRequestsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.spotFleetRequestConfigs(model.spotFleetRequestConfigs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SpotFleetRequestConfig.Builder> getSpotFleetRequestConfigs() {
            if (this.spotFleetRequestConfigs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.spotFleetRequestConfigs != null ? (Collection)this.spotFleetRequestConfigs.stream().map(SpotFleetRequestConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder spotFleetRequestConfigs(Collection<SpotFleetRequestConfig> spotFleetRequestConfigs) {
            this.spotFleetRequestConfigs = SpotFleetRequestConfigSetCopier.copy(spotFleetRequestConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotFleetRequestConfigs(SpotFleetRequestConfig ... spotFleetRequestConfigs) {
            this.spotFleetRequestConfigs(Arrays.asList(spotFleetRequestConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotFleetRequestConfigs(Consumer<SpotFleetRequestConfig.Builder> ... spotFleetRequestConfigs) {
            this.spotFleetRequestConfigs(Stream.of(spotFleetRequestConfigs).map(c -> (SpotFleetRequestConfig)((SpotFleetRequestConfig.Builder)SpotFleetRequestConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSpotFleetRequestConfigs(Collection<SpotFleetRequestConfig.BuilderImpl> spotFleetRequestConfigs) {
            this.spotFleetRequestConfigs = SpotFleetRequestConfigSetCopier.copyFromBuilder(spotFleetRequestConfigs);
        }

        @Override
        public DescribeSpotFleetRequestsResponse build() {
            return new DescribeSpotFleetRequestsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSpotFleetRequestsResponse> {
        public Builder nextToken(String var1);

        public Builder spotFleetRequestConfigs(Collection<SpotFleetRequestConfig> var1);

        public Builder spotFleetRequestConfigs(SpotFleetRequestConfig ... var1);

        public Builder spotFleetRequestConfigs(Consumer<SpotFleetRequestConfig.Builder> ... var1);
    }
}

