/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an attachment change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInterfaceAttachmentChanges implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInterfaceAttachmentChanges.Builder, NetworkInterfaceAttachmentChanges> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AttachmentId")
            .getter(getter(NetworkInterfaceAttachmentChanges::attachmentId))
            .setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId")
                    .unmarshallLocationName("attachmentId").build()).build();

    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteOnTermination")
            .getter(getter(NetworkInterfaceAttachmentChanges::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination")
                    .unmarshallLocationName("deleteOnTermination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD,
            DELETE_ON_TERMINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attachmentId;

    private final Boolean deleteOnTermination;

    private NetworkInterfaceAttachmentChanges(BuilderImpl builder) {
        this.attachmentId = builder.attachmentId;
        this.deleteOnTermination = builder.deleteOnTermination;
    }

    /**
     * <p>
     * The ID of the network interface attachment.
     * </p>
     * 
     * @return The ID of the network interface attachment.
     */
    public String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * Indicates whether the network interface is deleted when the instance is terminated.
     * </p>
     * 
     * @return Indicates whether the network interface is deleted when the instance is terminated.
     */
    public Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfaceAttachmentChanges)) {
            return false;
        }
        NetworkInterfaceAttachmentChanges other = (NetworkInterfaceAttachmentChanges) obj;
        return Objects.equals(attachmentId(), other.attachmentId())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NetworkInterfaceAttachmentChanges").add("AttachmentId", attachmentId())
                .add("DeleteOnTermination", deleteOnTermination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterfaceAttachmentChanges, T> g) {
        return obj -> g.apply((NetworkInterfaceAttachmentChanges) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInterfaceAttachmentChanges> {
        /**
         * <p>
         * The ID of the network interface attachment.
         * </p>
         * 
         * @param attachmentId
         *        The ID of the network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * Indicates whether the network interface is deleted when the instance is terminated.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the network interface is deleted when the instance is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);
    }

    static final class BuilderImpl implements Builder {
        private String attachmentId;

        private Boolean deleteOnTermination;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfaceAttachmentChanges model) {
            attachmentId(model.attachmentId);
            deleteOnTermination(model.deleteOnTermination);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public NetworkInterfaceAttachmentChanges build() {
            return new NetworkInterfaceAttachmentChanges(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
