/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstanceCreditSpecificationResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyInstanceCreditSpecificationResponse.Builder, ModifyInstanceCreditSpecificationResponse> {
    private static final SdkField<List<SuccessfulInstanceCreditSpecificationItem>> SUCCESSFUL_INSTANCE_CREDIT_SPECIFICATIONS_FIELD = SdkField
            .<List<SuccessfulInstanceCreditSpecificationItem>> builder(MarshallingType.LIST)
            .memberName("SuccessfulInstanceCreditSpecifications")
            .getter(getter(ModifyInstanceCreditSpecificationResponse::successfulInstanceCreditSpecifications))
            .setter(setter(Builder::successfulInstanceCreditSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SuccessfulInstanceCreditSpecificationSet")
                    .unmarshallLocationName("successfulInstanceCreditSpecificationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SuccessfulInstanceCreditSpecificationItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuccessfulInstanceCreditSpecificationItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<UnsuccessfulInstanceCreditSpecificationItem>> UNSUCCESSFUL_INSTANCE_CREDIT_SPECIFICATIONS_FIELD = SdkField
            .<List<UnsuccessfulInstanceCreditSpecificationItem>> builder(MarshallingType.LIST)
            .memberName("UnsuccessfulInstanceCreditSpecifications")
            .getter(getter(ModifyInstanceCreditSpecificationResponse::unsuccessfulInstanceCreditSpecifications))
            .setter(setter(Builder::unsuccessfulInstanceCreditSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("UnsuccessfulInstanceCreditSpecificationSet")
                    .unmarshallLocationName("unsuccessfulInstanceCreditSpecificationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<UnsuccessfulInstanceCreditSpecificationItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnsuccessfulInstanceCreditSpecificationItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUCCESSFUL_INSTANCE_CREDIT_SPECIFICATIONS_FIELD, UNSUCCESSFUL_INSTANCE_CREDIT_SPECIFICATIONS_FIELD));

    private final List<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications;

    private final List<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications;

    private ModifyInstanceCreditSpecificationResponse(BuilderImpl builder) {
        super(builder);
        this.successfulInstanceCreditSpecifications = builder.successfulInstanceCreditSpecifications;
        this.unsuccessfulInstanceCreditSpecifications = builder.unsuccessfulInstanceCreditSpecifications;
    }

    /**
     * Returns true if the SuccessfulInstanceCreditSpecifications property was specified by the sender (it may be
     * empty), or false if the sender did not specify the value (it will be empty). For responses returned by the SDK,
     * the sender is the AWS service.
     */
    public boolean hasSuccessfulInstanceCreditSpecifications() {
        return successfulInstanceCreditSpecifications != null
                && !(successfulInstanceCreditSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the instances whose credit option for CPU usage was successfully modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuccessfulInstanceCreditSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the instances whose credit option for CPU usage was successfully modified.
     */
    public List<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications() {
        return successfulInstanceCreditSpecifications;
    }

    /**
     * Returns true if the UnsuccessfulInstanceCreditSpecifications property was specified by the sender (it may be
     * empty), or false if the sender did not specify the value (it will be empty). For responses returned by the SDK,
     * the sender is the AWS service.
     */
    public boolean hasUnsuccessfulInstanceCreditSpecifications() {
        return unsuccessfulInstanceCreditSpecifications != null
                && !(unsuccessfulInstanceCreditSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the instances whose credit option for CPU usage was not modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnsuccessfulInstanceCreditSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the instances whose credit option for CPU usage was not modified.
     */
    public List<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications() {
        return unsuccessfulInstanceCreditSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSuccessfulInstanceCreditSpecifications() ? successfulInstanceCreditSpecifications() : null);
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasUnsuccessfulInstanceCreditSpecifications() ? unsuccessfulInstanceCreditSpecifications()
                        : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceCreditSpecificationResponse)) {
            return false;
        }
        ModifyInstanceCreditSpecificationResponse other = (ModifyInstanceCreditSpecificationResponse) obj;
        return hasSuccessfulInstanceCreditSpecifications() == other.hasSuccessfulInstanceCreditSpecifications()
                && Objects.equals(successfulInstanceCreditSpecifications(), other.successfulInstanceCreditSpecifications())
                && hasUnsuccessfulInstanceCreditSpecifications() == other.hasUnsuccessfulInstanceCreditSpecifications()
                && Objects.equals(unsuccessfulInstanceCreditSpecifications(), other.unsuccessfulInstanceCreditSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString
                .builder("ModifyInstanceCreditSpecificationResponse")
                .add("SuccessfulInstanceCreditSpecifications",
                        hasSuccessfulInstanceCreditSpecifications() ? successfulInstanceCreditSpecifications() : null)
                .add("UnsuccessfulInstanceCreditSpecifications",
                        hasUnsuccessfulInstanceCreditSpecifications() ? unsuccessfulInstanceCreditSpecifications() : null)
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessfulInstanceCreditSpecifications":
            return Optional.ofNullable(clazz.cast(successfulInstanceCreditSpecifications()));
        case "UnsuccessfulInstanceCreditSpecifications":
            return Optional.ofNullable(clazz.cast(unsuccessfulInstanceCreditSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceCreditSpecificationResponse, T> g) {
        return obj -> g.apply((ModifyInstanceCreditSpecificationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyInstanceCreditSpecificationResponse> {
        /**
         * <p>
         * Information about the instances whose credit option for CPU usage was successfully modified.
         * </p>
         * 
         * @param successfulInstanceCreditSpecifications
         *        Information about the instances whose credit option for CPU usage was successfully modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulInstanceCreditSpecifications(
                Collection<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications);

        /**
         * <p>
         * Information about the instances whose credit option for CPU usage was successfully modified.
         * </p>
         * 
         * @param successfulInstanceCreditSpecifications
         *        Information about the instances whose credit option for CPU usage was successfully modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulInstanceCreditSpecifications(
                SuccessfulInstanceCreditSpecificationItem... successfulInstanceCreditSpecifications);

        /**
         * <p>
         * Information about the instances whose credit option for CPU usage was successfully modified.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <SuccessfulInstanceCreditSpecificationItem>.Builder} avoiding the need to create one manually via
         * {@link List<SuccessfulInstanceCreditSpecificationItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SuccessfulInstanceCreditSpecificationItem>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #successfulInstanceCreditSpecifications(List<SuccessfulInstanceCreditSpecificationItem>)}.
         * 
         * @param successfulInstanceCreditSpecifications
         *        a consumer that will call methods on {@link List<SuccessfulInstanceCreditSpecificationItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfulInstanceCreditSpecifications(List<SuccessfulInstanceCreditSpecificationItem>)
         */
        Builder successfulInstanceCreditSpecifications(
                Consumer<SuccessfulInstanceCreditSpecificationItem.Builder>... successfulInstanceCreditSpecifications);

        /**
         * <p>
         * Information about the instances whose credit option for CPU usage was not modified.
         * </p>
         * 
         * @param unsuccessfulInstanceCreditSpecifications
         *        Information about the instances whose credit option for CPU usage was not modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulInstanceCreditSpecifications(
                Collection<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications);

        /**
         * <p>
         * Information about the instances whose credit option for CPU usage was not modified.
         * </p>
         * 
         * @param unsuccessfulInstanceCreditSpecifications
         *        Information about the instances whose credit option for CPU usage was not modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulInstanceCreditSpecifications(
                UnsuccessfulInstanceCreditSpecificationItem... unsuccessfulInstanceCreditSpecifications);

        /**
         * <p>
         * Information about the instances whose credit option for CPU usage was not modified.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <UnsuccessfulInstanceCreditSpecificationItem>.Builder} avoiding the need to create one manually via
         * {@link List<UnsuccessfulInstanceCreditSpecificationItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <UnsuccessfulInstanceCreditSpecificationItem>.Builder#build()} is called immediately and its result is passed
         * to {@link #unsuccessfulInstanceCreditSpecifications(List<UnsuccessfulInstanceCreditSpecificationItem>)}.
         * 
         * @param unsuccessfulInstanceCreditSpecifications
         *        a consumer that will call methods on {@link List<UnsuccessfulInstanceCreditSpecificationItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsuccessfulInstanceCreditSpecifications(List<UnsuccessfulInstanceCreditSpecificationItem>)
         */
        Builder unsuccessfulInstanceCreditSpecifications(
                Consumer<UnsuccessfulInstanceCreditSpecificationItem.Builder>... unsuccessfulInstanceCreditSpecifications);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications = DefaultSdkAutoConstructList
                .getInstance();

        private List<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceCreditSpecificationResponse model) {
            super(model);
            successfulInstanceCreditSpecifications(model.successfulInstanceCreditSpecifications);
            unsuccessfulInstanceCreditSpecifications(model.unsuccessfulInstanceCreditSpecifications);
        }

        public final Collection<SuccessfulInstanceCreditSpecificationItem.Builder> getSuccessfulInstanceCreditSpecifications() {
            if (successfulInstanceCreditSpecifications instanceof SdkAutoConstructList) {
                return null;
            }
            return successfulInstanceCreditSpecifications != null ? successfulInstanceCreditSpecifications.stream()
                    .map(SuccessfulInstanceCreditSpecificationItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successfulInstanceCreditSpecifications(
                Collection<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications) {
            this.successfulInstanceCreditSpecifications = SuccessfulInstanceCreditSpecificationSetCopier
                    .copy(successfulInstanceCreditSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulInstanceCreditSpecifications(
                SuccessfulInstanceCreditSpecificationItem... successfulInstanceCreditSpecifications) {
            successfulInstanceCreditSpecifications(Arrays.asList(successfulInstanceCreditSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulInstanceCreditSpecifications(
                Consumer<SuccessfulInstanceCreditSpecificationItem.Builder>... successfulInstanceCreditSpecifications) {
            successfulInstanceCreditSpecifications(Stream.of(successfulInstanceCreditSpecifications)
                    .map(c -> SuccessfulInstanceCreditSpecificationItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessfulInstanceCreditSpecifications(
                Collection<SuccessfulInstanceCreditSpecificationItem.BuilderImpl> successfulInstanceCreditSpecifications) {
            this.successfulInstanceCreditSpecifications = SuccessfulInstanceCreditSpecificationSetCopier
                    .copyFromBuilder(successfulInstanceCreditSpecifications);
        }

        public final Collection<UnsuccessfulInstanceCreditSpecificationItem.Builder> getUnsuccessfulInstanceCreditSpecifications() {
            if (unsuccessfulInstanceCreditSpecifications instanceof SdkAutoConstructList) {
                return null;
            }
            return unsuccessfulInstanceCreditSpecifications != null ? unsuccessfulInstanceCreditSpecifications.stream()
                    .map(UnsuccessfulInstanceCreditSpecificationItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unsuccessfulInstanceCreditSpecifications(
                Collection<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications) {
            this.unsuccessfulInstanceCreditSpecifications = UnsuccessfulInstanceCreditSpecificationSetCopier
                    .copy(unsuccessfulInstanceCreditSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulInstanceCreditSpecifications(
                UnsuccessfulInstanceCreditSpecificationItem... unsuccessfulInstanceCreditSpecifications) {
            unsuccessfulInstanceCreditSpecifications(Arrays.asList(unsuccessfulInstanceCreditSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulInstanceCreditSpecifications(
                Consumer<UnsuccessfulInstanceCreditSpecificationItem.Builder>... unsuccessfulInstanceCreditSpecifications) {
            unsuccessfulInstanceCreditSpecifications(Stream.of(unsuccessfulInstanceCreditSpecifications)
                    .map(c -> UnsuccessfulInstanceCreditSpecificationItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUnsuccessfulInstanceCreditSpecifications(
                Collection<UnsuccessfulInstanceCreditSpecificationItem.BuilderImpl> unsuccessfulInstanceCreditSpecifications) {
            this.unsuccessfulInstanceCreditSpecifications = UnsuccessfulInstanceCreditSpecificationSetCopier
                    .copyFromBuilder(unsuccessfulInstanceCreditSpecifications);
        }

        @Override
        public ModifyInstanceCreditSpecificationResponse build() {
            return new ModifyInstanceCreditSpecificationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
