/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse extends Ec2Response
        implements
        ToCopyableBuilder<DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse.Builder, DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse> {
    private static final SdkField<List<LocalGatewayRouteTableVirtualInterfaceGroupAssociation>> LOCAL_GATEWAY_ROUTE_TABLE_VIRTUAL_INTERFACE_GROUP_ASSOCIATIONS_FIELD = SdkField
            .<List<LocalGatewayRouteTableVirtualInterfaceGroupAssociation>> builder(MarshallingType.LIST)
            .memberName("LocalGatewayRouteTableVirtualInterfaceGroupAssociations")
            .getter(getter(DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse::localGatewayRouteTableVirtualInterfaceGroupAssociations))
            .setter(setter(Builder::localGatewayRouteTableVirtualInterfaceGroupAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalGatewayRouteTableVirtualInterfaceGroupAssociationSet")
                    .unmarshallLocationName("localGatewayRouteTableVirtualInterfaceGroupAssociationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LocalGatewayRouteTableVirtualInterfaceGroupAssociation> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOCAL_GATEWAY_ROUTE_TABLE_VIRTUAL_INTERFACE_GROUP_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<LocalGatewayRouteTableVirtualInterfaceGroupAssociation> localGatewayRouteTableVirtualInterfaceGroupAssociations;

    private final String nextToken;

    private DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.localGatewayRouteTableVirtualInterfaceGroupAssociations = builder.localGatewayRouteTableVirtualInterfaceGroupAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the LocalGatewayRouteTableVirtualInterfaceGroupAssociations property was specified by the sender
     * (it may be empty), or false if the sender did not specify the value (it will be empty). For responses returned by
     * the SDK, the sender is the AWS service.
     */
    public boolean hasLocalGatewayRouteTableVirtualInterfaceGroupAssociations() {
        return localGatewayRouteTableVirtualInterfaceGroupAssociations != null
                && !(localGatewayRouteTableVirtualInterfaceGroupAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLocalGatewayRouteTableVirtualInterfaceGroupAssociations()} to see if a value was sent in
     * this field.
     * </p>
     * 
     * @return Information about the associations.
     */
    public List<LocalGatewayRouteTableVirtualInterfaceGroupAssociation> localGatewayRouteTableVirtualInterfaceGroupAssociations() {
        return localGatewayRouteTableVirtualInterfaceGroupAssociations;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31
                * hashCode
                + Objects
                        .hashCode(hasLocalGatewayRouteTableVirtualInterfaceGroupAssociations() ? localGatewayRouteTableVirtualInterfaceGroupAssociations()
                                : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse)) {
            return false;
        }
        DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse other = (DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse) obj;
        return hasLocalGatewayRouteTableVirtualInterfaceGroupAssociations() == other
                .hasLocalGatewayRouteTableVirtualInterfaceGroupAssociations()
                && Objects.equals(localGatewayRouteTableVirtualInterfaceGroupAssociations(),
                        other.localGatewayRouteTableVirtualInterfaceGroupAssociations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString
                .builder("DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse")
                .add("LocalGatewayRouteTableVirtualInterfaceGroupAssociations",
                        hasLocalGatewayRouteTableVirtualInterfaceGroupAssociations() ? localGatewayRouteTableVirtualInterfaceGroupAssociations()
                                : null).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayRouteTableVirtualInterfaceGroupAssociations":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTableVirtualInterfaceGroupAssociations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(
            Function<DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse> {
        /**
         * <p>
         * Information about the associations.
         * </p>
         * 
         * @param localGatewayRouteTableVirtualInterfaceGroupAssociations
         *        Information about the associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTableVirtualInterfaceGroupAssociations(
                Collection<LocalGatewayRouteTableVirtualInterfaceGroupAssociation> localGatewayRouteTableVirtualInterfaceGroupAssociations);

        /**
         * <p>
         * Information about the associations.
         * </p>
         * 
         * @param localGatewayRouteTableVirtualInterfaceGroupAssociations
         *        Information about the associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTableVirtualInterfaceGroupAssociations(
                LocalGatewayRouteTableVirtualInterfaceGroupAssociation... localGatewayRouteTableVirtualInterfaceGroupAssociations);

        /**
         * <p>
         * Information about the associations.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <LocalGatewayRouteTableVirtualInterfaceGroupAssociation>.Builder} avoiding the need to create one manually
         * via {@link List<LocalGatewayRouteTableVirtualInterfaceGroupAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <LocalGatewayRouteTableVirtualInterfaceGroupAssociation>.Builder#build()} is called immediately and its
         * result is passed to {@link #localGatewayRouteTableVirtualInterfaceGroupAssociations(List<
         * LocalGatewayRouteTableVirtualInterfaceGroupAssociation>)}.
         * 
         * @param localGatewayRouteTableVirtualInterfaceGroupAssociations
         *        a consumer that will call methods on {@link List
         *        <LocalGatewayRouteTableVirtualInterfaceGroupAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localGatewayRouteTableVirtualInterfaceGroupAssociations(List<
         *      LocalGatewayRouteTableVirtualInterfaceGroupAssociation>)
         */
        Builder localGatewayRouteTableVirtualInterfaceGroupAssociations(
                Consumer<LocalGatewayRouteTableVirtualInterfaceGroupAssociation.Builder>... localGatewayRouteTableVirtualInterfaceGroupAssociations);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<LocalGatewayRouteTableVirtualInterfaceGroupAssociation> localGatewayRouteTableVirtualInterfaceGroupAssociations = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse model) {
            super(model);
            localGatewayRouteTableVirtualInterfaceGroupAssociations(model.localGatewayRouteTableVirtualInterfaceGroupAssociations);
            nextToken(model.nextToken);
        }

        public final Collection<LocalGatewayRouteTableVirtualInterfaceGroupAssociation.Builder> getLocalGatewayRouteTableVirtualInterfaceGroupAssociations() {
            if (localGatewayRouteTableVirtualInterfaceGroupAssociations instanceof SdkAutoConstructList) {
                return null;
            }
            return localGatewayRouteTableVirtualInterfaceGroupAssociations != null ? localGatewayRouteTableVirtualInterfaceGroupAssociations
                    .stream().map(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder localGatewayRouteTableVirtualInterfaceGroupAssociations(
                Collection<LocalGatewayRouteTableVirtualInterfaceGroupAssociation> localGatewayRouteTableVirtualInterfaceGroupAssociations) {
            this.localGatewayRouteTableVirtualInterfaceGroupAssociations = LocalGatewayRouteTableVirtualInterfaceGroupAssociationSetCopier
                    .copy(localGatewayRouteTableVirtualInterfaceGroupAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayRouteTableVirtualInterfaceGroupAssociations(
                LocalGatewayRouteTableVirtualInterfaceGroupAssociation... localGatewayRouteTableVirtualInterfaceGroupAssociations) {
            localGatewayRouteTableVirtualInterfaceGroupAssociations(Arrays
                    .asList(localGatewayRouteTableVirtualInterfaceGroupAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayRouteTableVirtualInterfaceGroupAssociations(
                Consumer<LocalGatewayRouteTableVirtualInterfaceGroupAssociation.Builder>... localGatewayRouteTableVirtualInterfaceGroupAssociations) {
            localGatewayRouteTableVirtualInterfaceGroupAssociations(Stream
                    .of(localGatewayRouteTableVirtualInterfaceGroupAssociations)
                    .map(c -> LocalGatewayRouteTableVirtualInterfaceGroupAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLocalGatewayRouteTableVirtualInterfaceGroupAssociations(
                Collection<LocalGatewayRouteTableVirtualInterfaceGroupAssociation.BuilderImpl> localGatewayRouteTableVirtualInterfaceGroupAssociations) {
            this.localGatewayRouteTableVirtualInterfaceGroupAssociations = LocalGatewayRouteTableVirtualInterfaceGroupAssociationSetCopier
                    .copyFromBuilder(localGatewayRouteTableVirtualInterfaceGroupAssociations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse build() {
            return new DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
