/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateRouteTableRequest extends Ec2Request implements
        ToCopyableBuilder<AssociateRouteTableRequest.Builder, AssociateRouteTableRequest> {
    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RouteTableId")
            .getter(getter(AssociateRouteTableRequest::routeTableId))
            .setter(setter(Builder::routeTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId")
                    .unmarshallLocationName("routeTableId").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(AssociateRouteTableRequest::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GatewayId")
            .getter(getter(AssociateRouteTableRequest::gatewayId))
            .setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId")
                    .unmarshallLocationName("GatewayId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_TABLE_ID_FIELD,
            SUBNET_ID_FIELD, GATEWAY_ID_FIELD));

    private final String routeTableId;

    private final String subnetId;

    private final String gatewayId;

    private AssociateRouteTableRequest(BuilderImpl builder) {
        super(builder);
        this.routeTableId = builder.routeTableId;
        this.subnetId = builder.subnetId;
        this.gatewayId = builder.gatewayId;
    }

    /**
     * <p>
     * The ID of the route table.
     * </p>
     * 
     * @return The ID of the route table.
     */
    public String routeTableId() {
        return routeTableId;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The ID of the internet gateway or virtual private gateway.
     * </p>
     * 
     * @return The ID of the internet gateway or virtual private gateway.
     */
    public String gatewayId() {
        return gatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateRouteTableRequest)) {
            return false;
        }
        AssociateRouteTableRequest other = (AssociateRouteTableRequest) obj;
        return Objects.equals(routeTableId(), other.routeTableId()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(gatewayId(), other.gatewayId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociateRouteTableRequest").add("RouteTableId", routeTableId()).add("SubnetId", subnetId())
                .add("GatewayId", gatewayId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "GatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateRouteTableRequest, T> g) {
        return obj -> g.apply((AssociateRouteTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AssociateRouteTableRequest> {
        /**
         * <p>
         * The ID of the route table.
         * </p>
         * 
         * @param routeTableId
         *        The ID of the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The ID of the internet gateway or virtual private gateway.
         * </p>
         * 
         * @param gatewayId
         *        The ID of the internet gateway or virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String routeTableId;

        private String subnetId;

        private String gatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateRouteTableRequest model) {
            super(model);
            routeTableId(model.routeTableId);
            subnetId(model.subnetId);
            gatewayId(model.gatewayId);
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateRouteTableRequest build() {
            return new AssociateRouteTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
