/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An entry for a prefix list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddPrefixListEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<AddPrefixListEntry.Builder, AddPrefixListEntry> {
    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Cidr")
            .getter(getter(AddPrefixListEntry::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr")
                    .unmarshallLocationName("Cidr").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(AddPrefixListEntry::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CIDR_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cidr;

    private final String description;

    private AddPrefixListEntry(BuilderImpl builder) {
        this.cidr = builder.cidr;
        this.description = builder.description;
    }

    /**
     * <p>
     * The CIDR block.
     * </p>
     * 
     * @return The CIDR block.
     */
    public String cidr() {
        return cidr;
    }

    /**
     * <p>
     * A description for the entry.
     * </p>
     * <p>
     * Constraints: Up to 255 characters in length.
     * </p>
     * 
     * @return A description for the entry.</p>
     *         <p>
     *         Constraints: Up to 255 characters in length.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPrefixListEntry)) {
            return false;
        }
        AddPrefixListEntry other = (AddPrefixListEntry) obj;
        return Objects.equals(cidr(), other.cidr()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddPrefixListEntry").add("Cidr", cidr()).add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddPrefixListEntry, T> g) {
        return obj -> g.apply((AddPrefixListEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddPrefixListEntry> {
        /**
         * <p>
         * The CIDR block.
         * </p>
         * 
         * @param cidr
         *        The CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * A description for the entry.
         * </p>
         * <p>
         * Constraints: Up to 255 characters in length.
         * </p>
         * 
         * @param description
         *        A description for the entry.</p>
         *        <p>
         *        Constraints: Up to 255 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String cidr;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(AddPrefixListEntry model) {
            cidr(model.cidr);
            description(model.description);
        }

        public final String getCidr() {
            return cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public AddPrefixListEntry build() {
            return new AddPrefixListEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
