/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.PublicIpv4Pool;
import software.amazon.awssdk.services.ec2.model.PublicIpv4PoolSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePublicIpv4PoolsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribePublicIpv4PoolsResponse> {
    private static final SdkField<List<PublicIpv4Pool>> PUBLIC_IPV4_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PublicIpv4Pools").getter(DescribePublicIpv4PoolsResponse.getter(DescribePublicIpv4PoolsResponse::publicIpv4Pools)).setter(DescribePublicIpv4PoolsResponse.setter(Builder::publicIpv4Pools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpv4PoolSet").unmarshallLocationName("publicIpv4PoolSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PublicIpv4Pool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribePublicIpv4PoolsResponse.getter(DescribePublicIpv4PoolsResponse::nextToken)).setter(DescribePublicIpv4PoolsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_IPV4_POOLS_FIELD, NEXT_TOKEN_FIELD));
    private final List<PublicIpv4Pool> publicIpv4Pools;
    private final String nextToken;

    private DescribePublicIpv4PoolsResponse(BuilderImpl builder) {
        super(builder);
        this.publicIpv4Pools = builder.publicIpv4Pools;
        this.nextToken = builder.nextToken;
    }

    public boolean hasPublicIpv4Pools() {
        return this.publicIpv4Pools != null && !(this.publicIpv4Pools instanceof SdkAutoConstructList);
    }

    public List<PublicIpv4Pool> publicIpv4Pools() {
        return this.publicIpv4Pools;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublicIpv4Pools() ? this.publicIpv4Pools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePublicIpv4PoolsResponse)) {
            return false;
        }
        DescribePublicIpv4PoolsResponse other = (DescribePublicIpv4PoolsResponse)((Object)obj);
        return this.hasPublicIpv4Pools() == other.hasPublicIpv4Pools() && Objects.equals(this.publicIpv4Pools(), other.publicIpv4Pools()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribePublicIpv4PoolsResponse").add("PublicIpv4Pools", this.hasPublicIpv4Pools() ? this.publicIpv4Pools() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublicIpv4Pools": {
                return Optional.ofNullable(clazz.cast(this.publicIpv4Pools()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePublicIpv4PoolsResponse, T> g) {
        return obj -> g.apply((DescribePublicIpv4PoolsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<PublicIpv4Pool> publicIpv4Pools = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePublicIpv4PoolsResponse model) {
            super(model);
            this.publicIpv4Pools(model.publicIpv4Pools);
            this.nextToken(model.nextToken);
        }

        public final Collection<PublicIpv4Pool.Builder> getPublicIpv4Pools() {
            if (this.publicIpv4Pools instanceof SdkAutoConstructList) {
                return null;
            }
            return this.publicIpv4Pools != null ? (Collection)this.publicIpv4Pools.stream().map(PublicIpv4Pool::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder publicIpv4Pools(Collection<PublicIpv4Pool> publicIpv4Pools) {
            this.publicIpv4Pools = PublicIpv4PoolSetCopier.copy(publicIpv4Pools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicIpv4Pools(PublicIpv4Pool ... publicIpv4Pools) {
            this.publicIpv4Pools(Arrays.asList(publicIpv4Pools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicIpv4Pools(Consumer<PublicIpv4Pool.Builder> ... publicIpv4Pools) {
            this.publicIpv4Pools(Stream.of(publicIpv4Pools).map(c -> (PublicIpv4Pool)((PublicIpv4Pool.Builder)PublicIpv4Pool.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPublicIpv4Pools(Collection<PublicIpv4Pool.BuilderImpl> publicIpv4Pools) {
            this.publicIpv4Pools = PublicIpv4PoolSetCopier.copyFromBuilder(publicIpv4Pools);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePublicIpv4PoolsResponse build() {
            return new DescribePublicIpv4PoolsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePublicIpv4PoolsResponse> {
        public Builder publicIpv4Pools(Collection<PublicIpv4Pool> var1);

        public Builder publicIpv4Pools(PublicIpv4Pool ... var1);

        public Builder publicIpv4Pools(Consumer<PublicIpv4Pool.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

