/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the subnet association with the transit gateway multicast domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubnetAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<SubnetAssociation.Builder, SubnetAssociation> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(SubnetAssociation::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(SubnetAssociation::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String subnetId;

    private final String state;

    private SubnetAssociation(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The state of the subnet association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayMulitcastDomainAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the subnet association.
     * @see TransitGatewayMulitcastDomainAssociationState
     */
    public TransitGatewayMulitcastDomainAssociationState state() {
        return TransitGatewayMulitcastDomainAssociationState.fromValue(state);
    }

    /**
     * <p>
     * The state of the subnet association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayMulitcastDomainAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the subnet association.
     * @see TransitGatewayMulitcastDomainAssociationState
     */
    public String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetAssociation)) {
            return false;
        }
        SubnetAssociation other = (SubnetAssociation) obj;
        return Objects.equals(subnetId(), other.subnetId()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SubnetAssociation").add("SubnetId", subnetId()).add("State", stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubnetAssociation, T> g) {
        return obj -> g.apply((SubnetAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubnetAssociation> {
        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The state of the subnet association.
         * </p>
         * 
         * @param state
         *        The state of the subnet association.
         * @see TransitGatewayMulitcastDomainAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayMulitcastDomainAssociationState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the subnet association.
         * </p>
         * 
         * @param state
         *        The state of the subnet association.
         * @see TransitGatewayMulitcastDomainAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayMulitcastDomainAssociationState
         */
        Builder state(TransitGatewayMulitcastDomainAssociationState state);
    }

    static final class BuilderImpl implements Builder {
        private String subnetId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetAssociation model) {
            subnetId(model.subnetId);
            state(model.state);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayMulitcastDomainAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public SubnetAssociation build() {
            return new SubnetAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
